/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.common.sdk.intercept;

import cn.hutool.core.util.StrUtil;
import cn.spatiotemporal.web.core.constants.enums.ReturnEnum;
import cn.spatiotemporal.web.core.domain.entity.admin.User;
import cn.spatiotemporal.web.core.domain.vo.ReturnVO;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.cicv.foton.common.sdk.config.ConstantsSDK;
import com.cicv.foton.common.sdk.domain.entity.BaseModel;
import com.cicv.foton.common.sdk.domain.entity.SelectEntry;
import com.cicv.foton.common.sdk.service.SdkContext;
import com.cicv.foton.common.sdk.utils.ThreadLocalUtil;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.MethodParameter;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
public class ResponseBodyInterceptor
implements ResponseBodyAdvice<Object> {
    private static final Logger log = LoggerFactory.getLogger(ResponseBodyInterceptor.class);
    @Resource
    private RedisTemplate<String, Object> dpRedisTemplate;
    @Value(value="${foton.application.name}")
    private String appName;
    @Value(value="${foton.data-permission.is-master:false}")
    private boolean isMaster;
    @Value(value="${foton.data-permission.percent:80}")
    private double fieldPercent;
    @Value(value="${foton.data-permission.is-close:false}")
    private boolean isClose;

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return true;
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        try {
            User currentUser;
            Object data;
            ReturnVO result;
            if (!(!(body instanceof ReturnVO) || !(result = (ReturnVO)body).getCode().equals(ReturnEnum.SUCCESS.getCode()) || Objects.isNull(data = result.getData()) || Objects.isNull(currentUser = SdkContext.getCurrentUser()) || Objects.isNull(currentUser.getTenantId()) || Objects.isNull(currentUser.getMemberId()) || this.isClose)) {
                Long memberId = currentUser.getMemberId();
                Object appId = this.dpRedisTemplate.opsForValue().get((Object)("foton:application:currentappid:" + memberId));
                BaseModel tables = ThreadLocalUtil.getTables();
                if (null != tables && CollectionUtils.isNotEmpty(tables.getAllTables()) && !Objects.isNull(appId)) {
                    HashMap<String, Set<Object>> modelMap;
                    Map<String, List<SelectEntry>> selectItemsMap;
                    Map<String, Map<String, Set<String>>> fieldsMap;
                    log.info("===== process threadlocal model:{}", (Object)tables.toString());
                    Map<String, String> allTablesMap = tables.getAllTables();
                    List<SelectEntry> selectItems = tables.getSelectItems();
                    if (!allTablesMap.isEmpty() && !(fieldsMap = this.getDesensitization(allTablesMap, memberId, appId, selectItemsMap = selectItems.stream().filter(m -> !Objects.isNull(m.getName()) && !Objects.isNull(m.getAliasName())).collect(Collectors.groupingBy(SelectEntry::getAliasName)), modelMap = new HashMap<String, Set<Object>>())).isEmpty()) {
                        if (data instanceof Collection) {
                            Collection objList = (Collection)data;
                            ArrayList<Object> resultList = new ArrayList<Object>();
                            for (Object obj : objList) {
                                resultList.add(this.desensitize(obj, com.cicv.foton.common.sdk.utils.StrUtil.isJson(obj), fieldsMap, this.fieldPercent));
                            }
                            result.setData(resultList);
                        } else {
                            this.desensitize(data, com.cicv.foton.common.sdk.utils.StrUtil.isJson(data), fieldsMap, this.fieldPercent);
                        }
                    }
                }
            }
            ThreadLocalUtil.getInstance().clear();
        }
        catch (Exception e) {
            log.error("ResponseBody\u5904\u7406\u53d1\u751f\u5f02\u5e38\u3002", (Throwable)e);
        }
        return body;
    }

    private Map<String, Map<String, Set<String>>> getDesensitization(Map<String, String> allTablesMap, Long memberId, Object appId, Map<String, List<SelectEntry>> selectItemsMap, Map<String, Set<Object>> modelMap) {
        HashMap<String, Map<String, Set<String>>> desensitizationMap = new HashMap<String, Map<String, Set<String>>>();
        Set permIds = this.dpRedisTemplate.opsForSet().members((Object)String.format("foton:member:permission:%s", memberId));
        if (Objects.isNull(permIds) || permIds.isEmpty()) {
            return desensitizationMap;
        }
        block0: for (Map.Entry<String, String> entry : allTablesMap.entrySet()) {
            Set indFields;
            String aliasName = entry.getKey();
            String modelName = entry.getValue();
            Set fullFields = this.dpRedisTemplate.opsForSet().members((Object)("foton:application:datamodel:" + this.appName + ":" + modelName));
            if (Objects.isNull(fullFields) || fullFields.isEmpty() || Objects.isNull(indFields = this.dpRedisTemplate.opsForSet().members((Object)("foton:application:datamodel:ind:" + this.appName + ":" + modelName))) || indFields.isEmpty()) continue;
            for (Object permId : permIds) {
                Set keys = this.dpRedisTemplate.keys((Object)String.format("foton:colfields:%s:%s:%s:%s:%s", permId, appId, this.appName, modelName, "*"));
                if (keys.isEmpty()) continue;
                String key = (String)keys.iterator().next();
                final Set select = this.dpRedisTemplate.opsForSet().members((Object)key).stream().map(o -> StrUtil.toCamelCase((CharSequence)o.toString())).collect(Collectors.toSet());
                final Set full = fullFields.stream().map(o -> StrUtil.toCamelCase((CharSequence)o.toString())).collect(Collectors.toSet());
                final Set ind = indFields.stream().map(o -> StrUtil.toCamelCase((CharSequence)o.toString())).collect(Collectors.toSet());
                desensitizationMap.put(aliasName, (Map<String, Set<String>>)new HashMap<String, Set<String>>(){
                    {
                        this.put("selected", select);
                        this.put("full", full);
                        this.put("ind", ind);
                    }
                });
                continue block0;
            }
        }
        return desensitizationMap;
    }

    private Object desensitize(Object object, boolean flag, Map<String, Map<String, Set<String>>> fieldsMap, double fieldPercent) throws InvocationTargetException, IllegalAccessException {
        Object nullVal = null;
        Field[] fields = object.getClass().getDeclaredFields();
        Set<String> currentFeilds = ResponseBodyInterceptor.getCurrentFeilds(fields, object.getClass().getSuperclass());
        Map<String, Object> currentMap = ResponseBodyInterceptor.isCurrentLevel(currentFeilds, fieldsMap, fieldPercent);
        Set other = (Set)currentMap.get("other");
        for (String name : currentFeilds) {
            PropertyDescriptor ps = BeanUtils.getPropertyDescriptor(object.getClass(), (String)name);
            if (null == ps || ps.getReadMethod() == null || ps.getWriteMethod() == null) continue;
            Object value = ps.getReadMethod().invoke(object, new Object[0]);
            if (value instanceof Collection) {
                Collection objList = (Collection)value;
                for (Object obj : objList) {
                    this.desensitize(obj, com.cicv.foton.common.sdk.utils.StrUtil.isJson(obj), fieldsMap, fieldPercent);
                }
                continue;
            }
            if (value == null) continue;
            if (!currentMap.isEmpty()) {
                if (com.cicv.foton.common.sdk.utils.StrUtil.isJson(value)) {
                    this.desensitize(value, true, fieldsMap, fieldPercent);
                    continue;
                }
                if (!other.contains(name)) continue;
                ps.getWriteMethod().invoke(object, nullVal);
                continue;
            }
            if (!com.cicv.foton.common.sdk.utils.StrUtil.isJson(value)) continue;
            this.desensitize(value, true, fieldsMap, fieldPercent);
        }
        return object;
    }

    private static Object getReplaceVal(Object feildVal, Map<Object, Object> currentLevel, String key) {
        Integer deseType;
        Map colConfig = (Map)currentLevel.get(key);
        if (!Objects.isNull(colConfig) && !Objects.isNull(feildVal) && feildVal instanceof String && !Objects.isNull(deseType = (Integer)colConfig.get("deseType"))) {
            String replacedChar = (String)colConfig.get("replacedChar");
            String strValue = com.cicv.foton.common.sdk.utils.StrUtil.nvl(feildVal);
            if (Objects.equals(ConstantsSDK.PART_REPLACE, deseType)) {
                Integer startInclude = (Integer)colConfig.get("startInclude");
                Integer endExclude = (Integer)colConfig.get("endExclude");
                feildVal = com.cicv.foton.common.sdk.utils.StrUtil.replace((CharSequence)strValue, (int)(strValue.length() < startInclude ? strValue.length() : startInclude.intValue()), (int)(strValue.length() < endExclude ? strValue.length() : endExclude.intValue()), (CharSequence)replacedChar);
            } else if (Objects.equals(ConstantsSDK.ALL_REPLACE, deseType)) {
                feildVal = com.cicv.foton.common.sdk.utils.StrUtil.replace((CharSequence)strValue, (int)0, (int)strValue.length(), (CharSequence)replacedChar);
            }
        }
        return feildVal;
    }

    private static Set<String> getCurrentFeilds(Field[] fields, Class<?> superclass) {
        Set<String> currentKeySet = new HashSet<String>();
        for (Field field : fields) {
            currentKeySet.add(field.getName());
        }
        currentKeySet = ResponseBodyInterceptor.currentKeySet(currentKeySet, superclass);
        return currentKeySet;
    }

    private static Map<String, Object> isCurrentLevel(Set<String> getCurrentFeilds, Map<String, Map<String, Set<String>>> fieldsMap, double fieldPercent) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        for (Map.Entry<String, Map<String, Set<String>>> entry : fieldsMap.entrySet()) {
            Map<String, Set<String>> map = entry.getValue();
            Set<String> full = map.get("full");
            Set<String> select = map.get("selected");
            Set<String> ind = map.get("ind");
            getCurrentFeilds.retainAll(full);
            double percent = (double)getCurrentFeilds.size() / (double)full.size() * 100.0;
            if (!(percent > fieldPercent)) continue;
            ind.removeAll(select);
            resultMap.put("other", ind);
            break;
        }
        return resultMap;
    }

    private static Set<String> currentKeySet(Set<String> currentKeySet, Class<?> superclass) {
        Field[] superFields = superclass.getDeclaredFields();
        if (superFields.length > 0) {
            for (Field field : superFields) {
                currentKeySet.add(field.getName());
            }
            ResponseBodyInterceptor.currentKeySet(currentKeySet, superclass.getSuperclass());
        }
        return currentKeySet;
    }
}

