/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.common.sdk.config;

import com.cicv.foton.common.sdk.annotation.ModelGroupAccess;
import com.cicv.foton.common.sdk.service.impl.ModelGroupService;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.stereotype.Component;

@Component
public class ModelGroupAccessInitializer
implements BeanPostProcessor {
    private final ModelGroupService modelGroupService;

    public ModelGroupAccessInitializer(ModelGroupService modelGroupService) {
        this.modelGroupService = modelGroupService;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class targetClass = AopUtils.getTargetClass((Object)bean);
        if (targetClass.isAnnotationPresent(ModelGroupAccess.class)) {
            ModelGroupAccess annotation = targetClass.getAnnotation(ModelGroupAccess.class);
            this.modelGroupService.initModelGroupMapping(annotation.modelName(), annotation.groupCodes());
            this.modelGroupService.initDataAccessControl(annotation.modelName(), annotation.groupCodes());
        }
        return bean;
    }
}

