/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.common.sdk.service.impl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ModelGroupService {
    private static final Logger log = LoggerFactory.getLogger(ModelGroupService.class);
    @Value(value="${foton.application.name:}")
    private String appName;
    @Resource(name="dpRedisTemplate")
    private RedisTemplate<String, Object> dpRedisTemplate;
    @Autowired
    private SqlSessionFactory sqlSessionFactory;

    public void initModelGroupMapping(String modelName, String[] groupCodes) {
        this.dpRedisTemplate.opsForSet().add((Object)String.format("foton:modelgroupmapping:%s:%s", this.appName, modelName), (Object[])groupCodes);
        log.info("ModelGroupMapping register modelName:{}, groupCodes:{}", (Object)modelName, (Object)Arrays.toString(groupCodes));
    }

    @Transactional
    public void initDataAccessControl(String modelName, String[] groupCodes) {
        try (SqlSession sqlSession = this.sqlSessionFactory.openSession(true);){
            Connection conn = sqlSession.getConnection();
            if (this.isConnectionValid(conn)) {
                String tblName = modelName + "_data_access_control";
                if (!this.tableExists(conn, tblName)) {
                    this.createTable(conn, tblName, this.getDatabaseType(conn));
                    log.info("Table {} has been created.", (Object)tblName);
                } else {
                    log.info("Table {} already exists.", (Object)tblName);
                }
            }
        }
        catch (Exception e) {
            log.error("Error occurred while initializing data access control for modelName {}", (Object)modelName, (Object)e);
            throw new RuntimeException(e);
        }
    }

    @Transactional
    public void writeDataAccessControl(String modelName, Set<String> groupNodeIds, Object idValue) {
        Long id = this.toLong(idValue);
        if (id > 0L) {
            try (SqlSession sqlSession = this.sqlSessionFactory.openSession(true);){
                Connection conn = sqlSession.getConnection();
                if (this.isConnectionValid(conn)) {
                    String tblName = modelName + "_data_access_control";
                    String insertSql = "INSERT INTO " + tblName + " (group_node_id, record_id) VALUES (?, ?)";
                    PreparedStatement ps = conn.prepareStatement(insertSql);
                    for (String groupNode : groupNodeIds) {
                        ps.setString(1, groupNode);
                        ps.setLong(2, id);
                        ps.addBatch();
                    }
                    int[] batchResults = ps.executeBatch();
                    ps.close();
                    log.info("Data access control:{}, batch write count:{}", (Object)tblName, (Object)batchResults.length);
                }
            }
            catch (Exception e) {
                log.error("Error occurred while write data access control for modelName {}", (Object)modelName, (Object)e);
                throw new RuntimeException(e);
            }
        }
    }

    private boolean isConnectionValid(Connection con) {
        if (con == null) {
            return false;
        }
        try {
            return !con.isClosed();
        }
        catch (SQLException e) {
            return false;
        }
    }

    private boolean tableExists(Connection conn, String tableName) throws Exception {
        DatabaseMetaData metaData = conn.getMetaData();
        ResultSet tables = metaData.getTables(null, null, tableName, new String[]{"TABLE"});
        return tables.next();
    }

    private String getDatabaseType(Connection conn) throws Exception {
        DatabaseMetaData metaData = conn.getMetaData();
        String productName = metaData.getDatabaseProductName().toLowerCase();
        return productName;
    }

    private void createTable(Connection conn, String tableName, String dbType) throws Exception {
        if (dbType.contains("postgresql")) {
            this.createPostgresqlTable(conn, tableName);
        } else if (dbType.contains("mysql")) {
            this.createMysqlTable(conn, tableName);
        } else {
            throw new IllegalArgumentException("Unsupported database type: " + dbType);
        }
    }

    private void createPostgresqlTable(Connection conn, String tableName) throws Exception {
        String sql1 = "CREATE TABLE %s (\r\n  id BIGSERIAL NOT NULL,  \r\n  group_node_id varchar(128) NOT NULL,          \r\n  record_id INT8 NOT NULL,                      \r\n  \"version\" int8,\r\n  \"is_deleted\" int2 NOT NULL DEFAULT 0,\r\n  \"tenant_id\" int8,\r\n  \"create_user\" varchar(20),\r\n  \"create_time\" timestamp(3) DEFAULT LOCALTIMESTAMP, \r\n  \"update_user\" varchar(20),\r\n  \"update_time\" timestamp(3),\r\n  CONSTRAINT \"%s_pk\" PRIMARY KEY (\"id\")\r\n) ";
        this.executeSql(conn, String.format(sql1, tableName, tableName));
        String sql2 = "COMMENT ON TABLE %s IS '%s\u6570\u636e\u8bbf\u95ee\u63a7\u5236\u8868'";
        this.executeSql(conn, String.format(sql2, tableName, tableName.substring(0, tableName.lastIndexOf("_data_access_control") - 1)));
        String sql3 = "CREATE INDEX \"idx_%sid\" ON \"%s\" USING btree (\r\n  \"group_node_id\" \"pg_catalog\".\"text_ops\" ASC NULLS LAST,\r\n  \"record_id\" \"pg_catalog\".\"int8_ops\" ASC NULLS LAST\r\n)";
        this.executeSql(conn, String.format(sql3, tableName, tableName));
    }

    private void createMysqlTable(Connection conn, String tableName) throws Exception {
        String sql = "CREATE TABLE `%s` (\r\n  `id` bigint(20) NOT NULL AUTO_INCREMENT,\r\n  `group_node_id` varchar(128) NOT NULL,\r\n  `record_id` bigint(20) NOT NULL,\r\n  `version` bigint(20) DEFAULT NULL,\r\n  `is_deleted` smallint(6) NOT NULL DEFAULT '0',\r\n  `tenant_id` bigint(20) DEFAULT NULL,\r\n  `create_user` varchar(20) DEFAULT NULL,\r\n  `create_time` datetime DEFAULT CURRENT_TIMESTAMP,\r\n  `update_user` varchar(20) DEFAULT NULL,\r\n  `update_time` datetime DEFAULT NULL,\r\n  PRIMARY KEY (`id`),\r\n  KEY `idx_%s` (`group_node_id`,`record_id`) USING BTREE\r\n) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='%s\u6570\u636e\u8bbf\u95ee\u63a7\u5236\u8868'";
        this.executeSql(conn, String.format(sql, tableName, tableName, tableName.substring(0, tableName.lastIndexOf("_data_access_control") - 1)));
    }

    private void executeSql(Connection conn, String sql) throws Exception {
        try (Statement stmt = conn.createStatement();){
            stmt.execute(sql);
        }
    }

    public Long toLong(Object str) {
        Long rtn = 0L;
        try {
            if (!Objects.isNull(str)) {
                if (str instanceof Double || str instanceof String) {
                    double valueOf = Double.valueOf(str.toString());
                    rtn = (long)valueOf;
                } else {
                    rtn = Long.valueOf(str.toString());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rtn;
    }
}

