/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.common.sdk.filter;

import cn.spatiotemporal.web.core.config.security.SecurityProperties;
import cn.spatiotemporal.web.core.constants.enums.ReturnEnum;
import cn.spatiotemporal.web.core.domain.entity.admin.User;
import cn.spatiotemporal.web.core.domain.vo.ReturnVO;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.cicv.foton.common.sdk.config.ConstantsSDK;
import com.cicv.foton.common.sdk.service.SdkContext;
import com.cicv.foton.common.sdk.utils.AuthorityUtils;
import com.cicv.foton.common.sdk.utils.JwtTokenUtils;
import com.cicv.foton.common.sdk.utils.RedisDao;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.stereotype.Component;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
@Order(value=1)
public class JwtAuthenticationTokenFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(JwtAuthenticationTokenFilter.class);
    @Autowired
    SecurityProperties securityProperties;
    @Autowired
    RedisDao redisDao;
    @Value(value="${foton.session.ischeck:false}")
    private boolean isOpenSessionCheck;
    @Value(value="${foton.session.maxcount:10000}")
    private Integer maxSessionCount;
    @Value(value="${spatiotemporal.cache.usernameKey:spatiotemporal:username}")
    private String usernameKey;
    @Value(value="${spatiotemporal.cache.expire:1800}")
    private int expire;
    @Resource(name="dpRedisTemplate")
    private RedisTemplate<String, Object> dpRedisTemplate;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if ("disable".equals(this.securityProperties.getMode())) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (this.permitPassUrl(request.getServletPath())) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String token = request.getHeader("X-Token");
        if (token == null) {
            if (this.permitAccess(request.getServletPath())) {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            this.sendError(request, response, ReturnEnum.ERROR_NO_AUTHORITY);
            return;
        }
        String username = JwtTokenUtils.parseToken(token);
        this.logger.debug((Object)("checking authentication " + username));
        String userToken = AuthorityUtils.checkToken(username);
        if (StringUtils.isEmpty((CharSequence)userToken)) {
            this.sendError(request, response, ReturnEnum.ERROR_TOKEN_EXPIRED);
            return;
        }
        if (!token.equals(userToken)) {
            this.sendError(request, response, ReturnEnum.ERROR_OTHER_DEVICE);
            return;
        }
        if (username != null) {
            if (!this.checkSessionConnect(username)) {
                this.sendError(request, response, "500", "\u5df2\u8fbe\u4f1a\u8bdd\u6700\u5927\u6570\u91cf");
                return;
            }
            UserDetails userDetails = AuthorityUtils.getCurrentUser4dp(token);
            if (userDetails != null) {
                UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)userDetails, null, userDetails.getAuthorities());
                authentication.setDetails((Object)new WebAuthenticationDetailsSource().buildDetails(request));
                this.logger.debug((Object)("authenticated user " + username + ", setting security context"));
                SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
                SdkContext.setCurrentUser((User)userDetails);
                if (AuthorityUtils.needResume()) {
                    AuthorityUtils.resetExpire(token, userDetails);
                }
            }
        } else {
            this.sendError(request, response, ReturnEnum.ERROR_NO_AUTHORITY);
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void sendError(HttpServletRequest request, HttpServletResponse response, ReturnEnum returnEnum) throws ServletException, IOException {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/html;charset=utf-8");
        String failed = new String(JSON.toJSONString((Object)new ReturnVO(returnEnum)).getBytes("utf-8"), "utf-8");
        log.error(failed);
        response.getWriter().write(failed);
    }

    private void sendError(HttpServletRequest request, HttpServletResponse response, String code, String msg) throws ServletException, IOException {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/html;charset=utf-8");
        String failed = new String(JSON.toJSONString((Object)new ReturnVO(code, msg)).getBytes("utf-8"), "utf-8");
        log.error(failed);
        response.getWriter().write(failed);
    }

    private boolean permitPassUrl(String path) {
        String[] permitAccess = ConstantsSDK.PASS_URL;
        if (permitAccess == null) {
            return false;
        }
        AntPathMatcher matcher = new AntPathMatcher();
        for (String pattern : permitAccess) {
            if (!matcher.match(pattern, path)) continue;
            return true;
        }
        return false;
    }

    private boolean permitAccess(String path) {
        String[] permitAccess = this.securityProperties.getPermitAccess();
        if (permitAccess == null) {
            return false;
        }
        AntPathMatcher matcher = new AntPathMatcher();
        for (String pattern : permitAccess) {
            if (!matcher.match(pattern, path)) continue;
            return true;
        }
        return false;
    }

    private boolean checkSessionConnect(String username) {
        String applicationName;
        boolean flag = true;
        if (this.isOpenSessionCheck && !StringUtils.isEmpty((CharSequence)(applicationName = SdkContext.getApplicationName())) && !StringUtils.isEmpty((CharSequence)username)) {
            String key = this.usernameKey + ":" + username + ":" + applicationName;
            Set keys = this.dpRedisTemplate.keys((Object)(this.usernameKey + ":*:" + applicationName));
            keys.add(key);
            if (keys.size() > this.maxSessionCount) {
                flag = false;
            } else {
                this.dpRedisTemplate.opsForValue().set((Object)key, (Object)applicationName, (long)this.expire, TimeUnit.SECONDS);
            }
        }
        return flag;
    }
}

