/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.common.sdk.aspect;

import cn.hutool.core.thread.ExecutorBuilder;
import cn.hutool.core.thread.RejectPolicy;
import cn.hutool.core.thread.ThreadFactoryBuilder;
import cn.hutool.core.util.ReflectUtil;
import com.cicv.foton.common.sdk.annotation.ModelGroupAccess;
import com.cicv.foton.common.sdk.domain.entity.BaseAccess;
import com.cicv.foton.common.sdk.service.impl.ModelGroupService;
import com.cicv.foton.common.sdk.utils.MyThreadExceptionHandler;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.collections.CollectionUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ModelGroupAccessAspect {
    private final ModelGroupService modelGroupService;
    private final ExecutorService executorService;

    public ModelGroupAccessAspect(ModelGroupService modelGroupService) {
        this.modelGroupService = modelGroupService;
        this.executorService = ExecutorBuilder.create().setCorePoolSize(5).setMaxPoolSize(10).setWorkQueue(new LinkedBlockingQueue(50)).setHandler(RejectPolicy.BLOCK.getValue()).setThreadFactory(ThreadFactoryBuilder.create().setNamePrefix("modelGroupControlThread-").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new MyThreadExceptionHandler()).build()).build();
    }

    @Pointcut(value="@within(com.cicv.foton.common.sdk.annotation.ModelGroupAccess)")
    public void withinGroupPointCut() {
    }

    @AfterReturning(pointcut="withinGroupPointCut()", returning="result")
    public void afterInsert(JoinPoint joinPoint, Object result) {
        this.executorService.execute(() -> this.async(joinPoint, result));
    }

    private void async(JoinPoint joinPoint, Object result) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        String methodName = method.getName();
        ModelGroupAccess annotation = method.getDeclaringClass().getAnnotation(ModelGroupAccess.class);
        if (annotation != null && (methodName.startsWith("insert") || methodName.startsWith("create"))) {
            Object[] args;
            for (Object arg : args = joinPoint.getArgs()) {
                if (arg == null) continue;
                this.processArgs(arg, annotation);
            }
        }
    }

    private void processArgs(Object arg, ModelGroupAccess annotation) {
        Field[] fields;
        if (arg == null) {
            return;
        }
        Class<?> clazz = arg.getClass();
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!field.getType().isAssignableFrom(BaseAccess.class)) continue;
            try {
                Field idField;
                field.setAccessible(true);
                BaseAccess baseAccess = (BaseAccess)field.get(arg);
                if (baseAccess == null || !baseAccess.getAutoFill().booleanValue() || !CollectionUtils.isNotEmpty(baseAccess.getGroupNodeIds()) || (idField = ReflectUtil.getField(clazz, (String)annotation.idFieldName())) == null) continue;
                idField.setAccessible(true);
                Object idValue = idField.get(arg);
                this.modelGroupService.writeDataAccessControl(annotation.modelName(), baseAccess.getGroupNodeIds(), idValue);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to access field: " + field.getName(), e);
            }
        }
    }
}

