/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.common.sdk.config;

import com.alibaba.fastjson.support.spring.FastJsonRedisSerializer;
import com.google.common.base.Objects;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisClientConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import redis.clients.jedis.JedisPoolConfig;

@Configuration
public class DataPermissionRedisConfig {
    private static final Logger log = LoggerFactory.getLogger(DataPermissionRedisConfig.class);
    @Value(value="${spring.redis.data-permission.host}")
    private String dpHost;
    @Value(value="${spring.redis.data-permission.port:6379}")
    private String dpPort;
    @Value(value="${spring.redis.data-permission.password:null}")
    private String dpPassword;
    @Value(value="${spring.redis.data-permission.database:0}")
    private Integer dpDatabase;
    @Value(value="${spring.redis.data-permission.max-redirects:3}")
    private Integer MAX_REDIRECTS;
    @Value(value="${spring.redis.pool.max-idle:8}")
    private Integer MAX_IDLE;
    @Value(value="${spring.redis.pool.max-active:20}")
    private Integer MAX_TOTAL;
    private static final long MAX_WAIT_MILLIS = 6000L;

    @Bean(name={"tenantRedisConnectionFactory"})
    @Qualifier(value="tenantRedisConnectionFactory")
    public RedisConnectionFactory connectionFactory() {
        JedisClientConfiguration.JedisPoolingClientConfigurationBuilder jpccb = (JedisClientConfiguration.JedisPoolingClientConfigurationBuilder)JedisClientConfiguration.builder();
        jpccb.poolConfig((GenericObjectPoolConfig)this.poolConfig(this.MAX_IDLE, this.MAX_TOTAL, 6000L, false));
        JedisClientConfiguration jedisClientConfiguration = jpccb.build();
        String type = "";
        type = this.dpHost.indexOf(",") > 0 ? "cluster" : "singleton";
        if ("cluster".equals(type)) {
            RedisClusterConfiguration redisClusterConfiguration = new RedisClusterConfiguration();
            String[] cNodes = this.dpHost.split(",");
            HashSet<RedisNode> nodes = new HashSet<RedisNode>();
            for (String node : cNodes) {
                String[] split = node.split(":");
                nodes.add(new RedisNode(split[0].trim(), Integer.valueOf(split[1]).intValue()));
            }
            redisClusterConfiguration.setClusterNodes(nodes);
            redisClusterConfiguration.setPassword(this.dpPassword);
            redisClusterConfiguration.setMaxRedirects(this.MAX_REDIRECTS.intValue());
            return new JedisConnectionFactory(redisClusterConfiguration, jedisClientConfiguration);
        }
        RedisStandaloneConfiguration redisConfiguration = new RedisStandaloneConfiguration();
        redisConfiguration.setHostName(this.dpHost);
        redisConfiguration.setPort(Integer.valueOf(this.dpPort).intValue());
        if (!StringUtils.isEmpty((String)this.dpPassword) && !Objects.equal((Object)"null", (Object)this.dpPassword)) {
            redisConfiguration.setPassword(this.dpPassword);
        }
        if (this.dpDatabase != 0) {
            redisConfiguration.setDatabase(this.dpDatabase.intValue());
        }
        return new JedisConnectionFactory(redisConfiguration, jedisClientConfiguration);
    }

    private JedisPoolConfig poolConfig(int maxIdle, int maxTotal, long maxWaitMillis, boolean testOnBorrow) {
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxIdle(maxIdle);
        poolConfig.setMaxTotal(maxTotal);
        poolConfig.setMaxWaitMillis(maxWaitMillis);
        poolConfig.setTestOnBorrow(testOnBorrow);
        return poolConfig;
    }

    @Bean(name={"dpRedisTemplate"})
    public RedisTemplate<String, Object> dpRedisTemplate(@Qualifier(value="tenantRedisConnectionFactory") RedisConnectionFactory tenantRedisConnectionFactory) {
        RedisTemplate dpRedisTemplate = new RedisTemplate();
        dpRedisTemplate.setConnectionFactory(tenantRedisConnectionFactory);
        FastJsonRedisSerializer fastJsonRedisSerializer = new FastJsonRedisSerializer(Object.class);
        dpRedisTemplate.setValueSerializer((RedisSerializer)fastJsonRedisSerializer);
        dpRedisTemplate.setHashValueSerializer((RedisSerializer)fastJsonRedisSerializer);
        StringRedisSerializer stringRedisSerializer = new StringRedisSerializer();
        dpRedisTemplate.setKeySerializer((RedisSerializer)stringRedisSerializer);
        dpRedisTemplate.setHashKeySerializer((RedisSerializer)stringRedisSerializer);
        dpRedisTemplate.afterPropertiesSet();
        return dpRedisTemplate;
    }
}

