/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.common.sdk.utils;

import java.util.List;
import java.util.Objects;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubSelect;

public class SqlUtil {
    public static String replaceTableName(String sql, String oldTableName, String newTableName) throws JSQLParserException {
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        if (statement instanceof Select) {
            Select selectStatement = (Select)statement;
            SqlUtil.replaceTableNameInSelect(selectStatement.getSelectBody(), oldTableName, newTableName);
        }
        return statement.toString();
    }

    private static void replaceTableNameInSelect(SelectBody selectBody, String oldTableName, String newTableName) {
        if (selectBody instanceof PlainSelect) {
            PlainSelect plainSelect = (PlainSelect)selectBody;
            SqlUtil.replaceTableNameInPlainSelect(plainSelect, oldTableName, newTableName);
        } else if (selectBody instanceof SetOperationList) {
            SetOperationList setOperationList = (SetOperationList)selectBody;
            for (SelectBody body : setOperationList.getSelects()) {
                SqlUtil.replaceTableNameInSelect(body, oldTableName, newTableName);
            }
        }
    }

    private static void replaceTableNameInPlainSelect(PlainSelect plainSelect, String oldTableName, String newTableName) {
        FromItem fromItem = plainSelect.getFromItem();
        if (fromItem instanceof Table && ((Table)fromItem).getName().equalsIgnoreCase(oldTableName)) {
            ((Table)fromItem).setName(newTableName);
            SqlUtil.setAlias(fromItem, oldTableName);
        } else if (fromItem instanceof SubSelect) {
            SqlUtil.replaceTableNameInSelect(((SubSelect)fromItem).getSelectBody(), oldTableName, newTableName);
        }
        List joins = plainSelect.getJoins();
        if (joins != null) {
            for (Join join : joins) {
                FromItem joinItem = join.getRightItem();
                if (joinItem instanceof Table && ((Table)joinItem).getName().equalsIgnoreCase(oldTableName)) {
                    ((Table)joinItem).setName(newTableName);
                    SqlUtil.setAlias(joinItem, oldTableName);
                    continue;
                }
                if (!(joinItem instanceof SubSelect)) continue;
                SqlUtil.replaceTableNameInSelect(((SubSelect)joinItem).getSelectBody(), oldTableName, newTableName);
            }
        }
        if (plainSelect.getWhere() != null) {
            SqlUtil.replaceTableNameInExpression(plainSelect.getWhere(), oldTableName, newTableName);
        }
    }

    private static void replaceTableNameInExpression(Expression expression, String oldTableName, String newTableName) {
        if (expression instanceof SubSelect) {
            SubSelect subSelect = (SubSelect)expression;
            SqlUtil.replaceTableNameInSelect(subSelect.getSelectBody(), oldTableName, newTableName);
        } else if (expression instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)expression;
            SqlUtil.replaceTableNameInExpression(binaryExpression.getLeftExpression(), oldTableName, newTableName);
            SqlUtil.replaceTableNameInExpression(binaryExpression.getRightExpression(), oldTableName, newTableName);
        }
    }

    private static void setAlias(FromItem fromItem, String oldTableName) {
        Table table = (Table)fromItem;
        Alias alias = table.getAlias();
        if (Objects.isNull(alias)) {
            table.setAlias(new Alias(oldTableName, true));
        }
    }

    public static void main(String[] args) throws JSQLParserException {
        String sql = "SELECT  id,vin,model,make,year,color,engine_type,power_type,fuel_type,battery_capacity,range,is_deleted AS deleted,version,tenant_id,create_user,create_time,update_user,update_time  FROM foton_vehicles foton_vehicles  WHERE  is_deleted=0 AND (model = 'Aoling') limit 5 ";
        sql = "(SELECT fv.*\r\nFROM foton_vehicles fv\r\nINNER JOIN foton_vehicles_data_access_control dac ON fv.id = dac.record_id\r\nWHERE dac.group_node_id IN ('n3', 'n1')) ";
        sql = "select t1.s_id as id,t1.s_name,t1.join_date, \nt2.score, \nt2.* \nfrom schema1.edu_college_student t1\njoin schema2.foton_vehicles t2\non t2.s_id = t1.s_id \nwhere 1=1 \n";
        sql = "select foton_vehicles.*,t1.* \nfrom original_data.edu_college_student As t1\nJOIN original_data.foton_vehicles foton_vehicles \non t1.s_id = foton_vehicles.s_id \nwhere 1=1 ";
        sql = "select t1.*,t1.*,t2.*\nfrom foton_vehicles t1\njoin edu_college_test_score t2 on t2.s_id = t1.s_id";
        sql = "select\n  t1.s_id,\n  t1.s_name,\n  max(t2.score) as maxscore,\n  t2.course\nfrom\n  original_data.foton_vehicles t1\n  join original_data.foton_vehicles t2 on t2.s_id = t1.s_id\ngroup by\n  t2.course,\n  t1.s_id,\n  t1.s_name";
        sql = "select t2.id from (select t1.id from (select id from original_data.foton_vehicles) t1) t2";
        sql = "select t1.stime,t1.sscore from (select o.create_time as stime,t.score as sscore from original_data.edu_college_student o join original_data.foton_vehicles t on t.s_id = o.s_id ) t1";
        sql = "select t1.*, t4.* from original_data.edu_college_student t1, (select t1.id from (select id from original_data.foton_vehicles)) t4 where t1.id = t4.id";
        sql = "select\n  v1.id as t_id,\n  v1.s_name as t_s_name,\n  v1.join_date as t_date,\n  v1.score As t_score,\n  t3.course AS t_course\nfrom\n  (\n    select\n      t1.s_id as id,\n      t1.s_name,\n      t1.join_date,\n      t2.score\n    from\n      original_data.foton_vehicles t1\n      join original_data.foton_vehicles t2 on t2.s_id = t1.s_id\n    where\n      1 = 1\n  ) v1\n  join original_data.foton_vehicles t3 on t3.s_id = v1.id\n  limit 10";
        sql = "select '\u6b63\u5e38\u7b7e\u5230' as '\u7b7e\u5230\u60c5\u51b5',sum(1) as '\u6b21\u6570' from `original_data`.foton_vehicles where is_early = 0 and is_later = 0 \nunion all \nSELECT '\u8fdf\u5230' AS '\u7b7e\u5230\u60c5\u51b5',if(SUM(is_later)is null,0,SUM(is_later)) AS '\u6b21\u6570' FROM `original_data`.foton_vehicles WHERE is_later = 1\nunion all \nSELECT '\u65e9\u9000' AS '\u7b7e\u5230\u60c5\u51b5',if(SUM(is_early)is null,0,SUM(is_early)) AS '\u6b21\u6570' FROM `original_data`.foton_vehicles WHERE is_early = 1";
        String keyword = "foton_vehicles";
        String replacement = "new_vehicles";
        Long s = System.currentTimeMillis();
        String modifiedSql = SqlUtil.replaceTableName(sql, keyword, replacement);
        System.out.println(modifiedSql);
        System.out.println(System.currentTimeMillis() - s);
    }
}

