/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.common.sdk.service;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
import cn.spatiotemporal.web.core.domain.entity.admin.User;
import cn.spatiotemporal.web.core.exception.BaseBusinessException;
import com.alibaba.fastjson.JSON;
import com.cicv.foton.common.sdk.domain.entity.BaseModel;
import com.cicv.foton.common.sdk.domain.entity.ServiceConfig;
import com.cicv.foton.common.sdk.domain.vo.ServiceResource;
import com.cicv.foton.common.sdk.utils.AuthorityUtils;
import com.cicv.foton.common.sdk.utils.RedisDao;
import com.cicv.foton.common.sdk.utils.StrUtil;
import com.cicv.foton.common.sdk.utils.ThreadLocalUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class SdkContext {
    private static final Logger log = LoggerFactory.getLogger(SdkContext.class);
    @Resource(name="dpRedisTemplate")
    private RedisTemplate<String, Object> dpRedisTemplate;
    private static RedisTemplate<String, Object> staticDpRedisTemplate;
    @Autowired
    RedisDao redisDao;
    private static final String USER_ATTRIBUTES = "USER_ATTRIBUTES";
    private static final String LOGIN_USER_KEY = "foton:login:user:";
    @Value(value="${foton.application.name:}")
    private String appName;
    private static String applicationName;

    @PostConstruct
    public void init() {
        applicationName = this.appName;
        staticDpRedisTemplate = this.dpRedisTemplate;
    }

    public static String getApplicationName() {
        return applicationName;
    }

    public static void setSvcOrigin() {
        RequestContextHolder.getRequestAttributes().setAttribute("requestSource", (Object)SdkContext.getApplicationName(), 0);
    }

    public static void setCurrentUser(User currentUser) {
        RequestContextHolder.currentRequestAttributes().setAttribute(USER_ATTRIBUTES, (Object)currentUser, 0);
    }

    public static Object getUserAllInfo() {
        User user = SdkContext.getCurrentUser();
        if (!Objects.isNull(user) && !Objects.isNull(user.getMemberId())) {
            return staticDpRedisTemplate.opsForValue().get((Object)(LOGIN_USER_KEY + SdkContext.getCurrentUser().getMemberId()));
        }
        return null;
    }

    public static User getCurrentUser() {
        User user = null;
        try {
            String requestAppName = SdkContext.getRequestAppName();
            user = (User)RequestContextHolder.currentRequestAttributes().getAttribute(USER_ATTRIBUTES, 0);
            if (null != user) {
                user.setUri(requestAppName);
                SdkContext.setCurrentUser(user);
                return user;
            }
            ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            HttpServletRequest request = requestAttributes.getRequest();
            String token = request.getHeader("X-Token");
            if (StringUtils.isNotEmpty((String)token)) {
                user = (User)AuthorityUtils.getCurrentUser4dp(token);
            }
            if (null == user) {
                throw new BaseBusinessException("400", "\u672a\u767b\u5f55\u7528\u6237!");
            }
            user.setUri(requestAppName);
            SdkContext.setCurrentUser(user);
        }
        catch (Exception e) {
            log.warn("\u672a\u767b\u5f55\u7528\u6237");
        }
        return user;
    }

    public static List<ServiceResource> getCurrentResource() {
        List<ServiceResource> list = new ArrayList<ServiceResource>();
        User user = SdkContext.getCurrentUser();
        if (!Objects.isNull(user) && !Objects.isNull(user.getMemberId())) {
            String key = "foton:application:resource:" + user.getMemberId();
            Object object = staticDpRedisTemplate.opsForHash().get((Object)key, (Object)SdkContext.getApplicationName());
            if (null != object) {
                list = JSONUtil.toList((JSONArray)JSONUtil.parseArray((Object)object), ServiceResource.class);
            }
        }
        return list;
    }

    public static Object getResourceByAppId(String appId) {
        User user = SdkContext.getCurrentUser();
        if (!Objects.isNull(user) && !Objects.isNull(user.getMemberId())) {
            String key = "foton:application:resource:" + user.getMemberId();
            Object object = staticDpRedisTemplate.opsForHash().get((Object)key, (Object)appId);
            return object;
        }
        return null;
    }

    public static List<ServiceConfig> getCurrentConfig(String appId) {
        List<ServiceConfig> list = new ArrayList<ServiceConfig>();
        Object object = staticDpRedisTemplate.opsForHash().get((Object)("foton:application:config:" + appId), (Object)SdkContext.getApplicationName());
        if (null != object) {
            list = JSONUtil.toList((JSONArray)JSONUtil.parseArray((Object)object), ServiceConfig.class);
        }
        return list;
    }

    public static Map<Object, Object> getCurrentDataGroupRowDataPremssion(String modelName, String dataGroupId) {
        User user = SdkContext.getCurrentUser();
        if (!Objects.isNull(user)) {
            return SdkContext.getDataPremssion(modelName, "foton:application:datapermission:datagroup:", dataGroupId, "row");
        }
        return new HashMap<Object, Object>();
    }

    public static Map<Object, Object> getCurrentOrgRowDataPremssion(String modelName) {
        User user = SdkContext.getCurrentUser();
        if (!Objects.isNull(user)) {
            return SdkContext.getDataPremssion(modelName, "foton:application:datapermission:orgId:", String.valueOf(user.getOrgId()), "row");
        }
        return new HashMap<Object, Object>();
    }

    public static Map<Object, Object> getCurrentDataGroupColDataPremssion(String modelName, String dataGroupId) {
        User user = SdkContext.getCurrentUser();
        if (!Objects.isNull(user)) {
            return SdkContext.getDataPremssion(modelName, "foton:application:datapermission:datagroup:", dataGroupId, "col");
        }
        return new HashMap<Object, Object>();
    }

    public static Map<Object, Object> getCurrentOrgColDataPremssion(String modelName) {
        User user = SdkContext.getCurrentUser();
        if (!Objects.isNull(user)) {
            return SdkContext.getDataPremssion(modelName, "foton:application:datapermission:orgId:", String.valueOf(user.getOrgId()), "col");
        }
        return new HashMap<Object, Object>();
    }

    private static Map<Object, Object> getDataPremssion(String modelName, String method, String dataGroupId, String type) {
        Map<Object, Object> map = new HashMap<Object, Object>();
        BaseModel tables = ThreadLocalUtil.getTables();
        if (StringUtils.isNotBlank((String)modelName)) {
            String key = StrUtil.concatStr(method, SdkContext.getApplicationName(), modelName, String.valueOf(dataGroupId), type);
            map = staticDpRedisTemplate.opsForHash().entries((Object)key);
            if (Objects.isNull(map)) {
                map = new HashMap();
            }
        }
        return map;
    }

    public static String getRequestSource() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (null != requestAttributes) {
            return StrUtil.nvl(requestAttributes.getAttribute("requestSource", 0));
        }
        return null;
    }

    public static boolean isQueryAll(User currentUser) {
        try {
            Long memberId = currentUser.getMemberId();
            String requestAppName = currentUser.getUri();
            log.info("\u5f53\u524drequestAppName:{}", (Object)requestAppName);
            Long tenantId = currentUser.getTenantId();
            if (!Objects.equals(0L, tenantId) || StringUtils.isBlank((String)requestAppName) || Objects.isNull(memberId)) {
                return false;
            }
            Object appId = staticDpRedisTemplate.opsForValue().get((Object)("foton:application:currentappid:" + memberId));
            if (Objects.isNull(appId)) {
                return false;
            }
            Map entries = staticDpRedisTemplate.opsForHash().entries((Object)("foton:application:config:" + appId));
            if (Objects.isNull(entries) || entries.isEmpty()) {
                return false;
            }
            Object config = entries.get(requestAppName);
            if (Objects.isNull(config)) {
                return false;
            }
            List list = JSON.parseArray((String)config.toString(), ServiceConfig.class);
            if (Objects.isNull(list = list.stream().filter(m -> Objects.equals("visible", m.getCfgType())).collect(Collectors.toList())) || list.isEmpty()) {
                return false;
            }
            if (Objects.equals("1", ((ServiceConfig)list.get(0)).getValue())) {
                return true;
            }
        }
        catch (Exception e) {
            log.info("\u6821\u9a8c\u662f\u5426\u53ef\u770b\u5168\u90e8\u662f\u6570\u636e\u5f02\u5e38");
        }
        return false;
    }

    public static String getRequestAppName() {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        String requestAppName = null;
        if (attributes != null) {
            HttpServletRequest request = attributes.getRequest();
            requestAppName = request.getHeader("X-Forwarded-Prefix");
        }
        return requestAppName;
    }

    public static Set<String> getCuurentGroupNodeIds() {
        HashSet<String> set = new HashSet<String>();
        User user = SdkContext.getCurrentUser();
        if (Objects.isNull(user) || Objects.isNull(user.getTenantId()) || Objects.isNull(user.getMemberId())) {
            return set;
        }
        Long tenantId = user.getTenantId();
        String key = String.format("foton:application:membergroup:memberid2membergroup:%s:%s", tenantId, SdkContext.getApplicationName());
        Object val = staticDpRedisTemplate.opsForHash().get((Object)key, (Object)String.valueOf(user.getMemberId()));
        if (Objects.isNull(val)) {
            return set;
        }
        return new HashSet<String>(JSON.parseArray((String)JSON.toJSONString((Object)val), String.class).stream().map(Object::toString).collect(Collectors.toSet()));
    }

    public static Set<String> getCuurentGroupAllNodeIds() {
        HashSet<String> allNodeIds = new HashSet<String>();
        Set<String> nodeIds = SdkContext.getCuurentGroupNodeIds();
        allNodeIds.addAll(nodeIds);
        for (String nodeId : nodeIds) {
            Set members = staticDpRedisTemplate.opsForSet().members((Object)String.format("foton:application:membergroup:ishavechildperm:%s:%s", SdkContext.getCurrentUser().getTenantId(), nodeId));
            if (members.isEmpty()) continue;
            List collect = members.stream().map(Object::toString).collect(Collectors.toList());
            allNodeIds.addAll(collect);
        }
        return new HashSet<String>(allNodeIds);
    }
}

