/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.common.sdk.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;

public class JsonToSql {
    public static void main(String[] args) {
        String jsonQuery = "{\"and\":[{\"field\":\"department\",\"operator\":\"=\",\"value\":\"NOA\"},{\"or\":[{\"field\":\"status\",\"operator\":\"=\",\"value\":\"active\"},{\"field\":\"status\",\"operator\":\"=\",\"value\":\"onleave\"}]}]}";
        String sqlQuery = JsonToSql.buildSql(jsonQuery);
        System.out.println(sqlQuery);
    }

    public static String buildSql(String jsonQuery) {
        String sqlQuery = "";
        try {
            ObjectMapper mapper = new ObjectMapper();
            JsonNode queryJsonSimple = mapper.readTree(jsonQuery);
            sqlQuery = JsonToSql.buildSql(queryJsonSimple);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sqlQuery;
    }

    private static String buildSql(JsonNode queryJson) throws IOException {
        if (queryJson.has("and")) {
            ArrayNode andClauses = (ArrayNode)queryJson.get("and");
            return JsonToSql.buildAndClause(andClauses);
        }
        if (queryJson.has("or")) {
            ArrayNode orClauses = (ArrayNode)queryJson.get("or");
            return JsonToSql.buildOrClause(orClauses);
        }
        return JsonToSql.buildSimpleCondition(queryJson);
    }

    private static String buildSimpleCondition(JsonNode condition) throws IOException {
        String field = condition.get("field").asText();
        String operator = condition.get("operator").asText();
        JsonNode valueNode = condition.get("value");
        return field + " " + operator + " " + JsonToSql.quote(valueNode);
    }

    private static String buildOrClause(ArrayNode orClauses) throws IOException {
        StringBuilder sql = new StringBuilder("(");
        for (int i = 0; i < orClauses.size(); ++i) {
            JsonNode clause;
            if (i > 0) {
                sql.append(" OR ");
            }
            if ((clause = orClauses.get(i)).isObject()) {
                ObjectNode obj = (ObjectNode)clause;
                String field = obj.get("field") != null ? obj.get("field").asText() : null;
                String operator = obj.get("operator") != null ? obj.get("operator").asText() : null;
                JsonNode valueNode = obj.get("value");
                if (obj.has("and")) {
                    JsonNode andNode = obj.get("and");
                    if (!andNode.isArray()) continue;
                    sql.append("(").append(JsonToSql.buildAndClause((ArrayNode)andNode)).append(")");
                    continue;
                }
                if (obj.has("or")) {
                    JsonNode orNode = obj.get("or");
                    if (!orNode.isArray()) continue;
                    sql.append("(").append(JsonToSql.buildOrClause((ArrayNode)orNode)).append(")");
                    continue;
                }
                if (field == null || operator == null || valueNode == null) continue;
                sql.append(field).append(" ").append(operator).append(" ").append(JsonToSql.quote(valueNode));
                continue;
            }
            if (!clause.isArray()) continue;
            sql.append(JsonToSql.buildOrClause((ArrayNode)clause));
        }
        sql.append(")");
        return sql.toString();
    }

    private static String buildAndClause(ArrayNode andClauses) throws IOException {
        StringBuilder sql = new StringBuilder("(");
        for (int i = 0; i < andClauses.size(); ++i) {
            JsonNode clause;
            if (i > 0) {
                sql.append(" AND ");
            }
            if ((clause = andClauses.get(i)).isObject()) {
                ObjectNode obj = (ObjectNode)clause;
                String field = obj.get("field") != null ? obj.get("field").asText() : null;
                String operator = obj.get("operator") != null ? obj.get("operator").asText() : null;
                JsonNode valueNode = obj.get("value");
                if (obj.has("and")) {
                    JsonNode andNode = obj.get("and");
                    if (!andNode.isArray()) continue;
                    sql.append("(").append(JsonToSql.buildAndClause((ArrayNode)andNode)).append(")");
                    continue;
                }
                if (obj.has("or")) {
                    JsonNode orNode = obj.get("or");
                    if (!orNode.isArray()) continue;
                    sql.append("(").append(JsonToSql.buildOrClause((ArrayNode)orNode)).append(")");
                    continue;
                }
                if (field == null || operator == null || valueNode == null) continue;
                sql.append(field).append(" ").append(operator).append(" ").append(JsonToSql.quote(valueNode));
                continue;
            }
            if (!clause.isArray()) continue;
            sql.append(JsonToSql.buildAndClause((ArrayNode)clause));
        }
        sql.append(")");
        return sql.toString();
    }

    private static String quote(JsonNode valueNode) {
        if (valueNode != null && valueNode.isTextual()) {
            return "'" + valueNode.asText() + "'";
        }
        if (valueNode != null) {
            return valueNode.asText();
        }
        return "NULL";
    }
}

