/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.common.sdk.intercept;

import cn.spatiotemporal.web.core.domain.entity.admin.User;
import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import com.cicv.foton.common.sdk.service.SdkContext;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.NullValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

public class TenantLineHandlerInterceptor
implements TenantLineHandler {
    private static final Logger log = LoggerFactory.getLogger(TenantLineHandlerInterceptor.class);
    private List<String> ignoreTableNames;
    private RedisTemplate<String, Object> dpRedisTemplate;
    private String appName;

    public TenantLineHandlerInterceptor(List<String> ignoreTableNames, RedisTemplate<String, Object> dpRedisTemplate, String appName) {
        this.ignoreTableNames = ignoreTableNames;
        this.dpRedisTemplate = dpRedisTemplate;
        this.appName = appName;
    }

    public boolean ignoreTable(String tableName) {
        return this.ignoreTableNames.contains(tableName);
    }

    public String getTenantIdColumn() {
        return "tenant_id";
    }

    public Expression getTenantId() {
        try {
            User currentUser = SdkContext.getCurrentUser();
            if (null == currentUser || null == currentUser.getTenantId()) {
                return new NullValue();
            }
            if (SdkContext.isQueryAll(currentUser)) {
                return new NullValue();
            }
            return new LongValue(currentUser.getTenantId().longValue());
        }
        catch (Exception e) {
            throw new RuntimeException("\u83b7\u53d6\u79df\u6237\u4fe1\u606f\u51fa\u73b0\u9519\u8bef\uff01", e);
        }
    }
}

