/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.common.sdk.intercept;

import cn.hutool.core.util.StrUtil;
import cn.spatiotemporal.web.core.constants.enums.ReturnEnum;
import cn.spatiotemporal.web.core.domain.entity.admin.User;
import cn.spatiotemporal.web.core.domain.vo.ReturnVO;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.cicv.foton.common.sdk.config.ConstantsSDK;
import com.cicv.foton.common.sdk.domain.entity.BaseModel;
import com.cicv.foton.common.sdk.domain.entity.SelectEntry;
import com.cicv.foton.common.sdk.service.SdkContext;
import com.cicv.foton.common.sdk.utils.ThreadLocalUtil;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.MethodParameter;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
public class ResponseBodyInterceptor
implements ResponseBodyAdvice<Object> {
    private static final Logger log = LoggerFactory.getLogger(ResponseBodyInterceptor.class);
    @Resource
    private RedisTemplate<String, Object> dpRedisTemplate;
    @Value(value="${foton.application.name}")
    private String appName;
    @Value(value="${foton.data-permission.is-master:false}")
    private boolean isMaster;
    @Value(value="${foton.data-permission.percent:80}")
    private double fieldPercent;

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return true;
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        try {
            User currentUser;
            Object data;
            ReturnVO result;
            if (body instanceof ReturnVO && (result = (ReturnVO)body).getCode().equals(ReturnEnum.SUCCESS.getCode()) && !Objects.isNull(data = result.getData()) && !Objects.isNull(currentUser = SdkContext.getCurrentUser()) && !Objects.isNull(currentUser.getTenantId()) && !this.isMaster) {
                Long orgId = currentUser.getOrgId();
                BaseModel tables = ThreadLocalUtil.getTables();
                if (null != tables && CollectionUtils.isNotEmpty(tables.getAllTables()) && CollectionUtils.isNotEmpty(tables.getSelectItems())) {
                    HashMap<String, Set<Object>> modelMap;
                    Map<String, List<SelectEntry>> selectItemsMap;
                    Map<String, Map<Object, Object>> colInfoList;
                    log.info("===== process threadlocal model:{}", (Object)tables.toString());
                    Map<String, String> allTablesMap = tables.getAllTables();
                    List<SelectEntry> selectItems = tables.getSelectItems();
                    if (!(allTablesMap.isEmpty() || selectItems.isEmpty() || (colInfoList = this.getDesensitization(allTablesMap, orgId, selectItemsMap = selectItems.stream().filter(m -> !Objects.isNull(m.getName()) && !Objects.isNull(m.getAliasName())).collect(Collectors.groupingBy(SelectEntry::getAliasName)), modelMap = new HashMap<String, Set<Object>>())).isEmpty() && selectItemsMap.isEmpty())) {
                        if (data instanceof Collection) {
                            Collection objList = (Collection)data;
                            ArrayList<Object> resultList = new ArrayList<Object>();
                            for (Object obj : objList) {
                                resultList.add(this.desensitize(obj, com.cicv.foton.common.sdk.utils.StrUtil.isJson(obj), colInfoList, selectItemsMap, this.fieldPercent, modelMap));
                            }
                            result.setData(resultList);
                        } else {
                            this.desensitize(data, com.cicv.foton.common.sdk.utils.StrUtil.isJson(data), colInfoList, selectItemsMap, this.fieldPercent, modelMap);
                        }
                    }
                }
            }
            ThreadLocalUtil.getInstance().clear();
        }
        catch (Exception e) {
            log.error("ResponseBody\u5904\u7406\u53d1\u751f\u5f02\u5e38\u3002", (Throwable)e);
        }
        return body;
    }

    private Map<String, Map<Object, Object>> getDesensitization(Map<String, String> allTablesMap, Long orgId, Map<String, List<SelectEntry>> selectItemsMap, Map<String, Set<Object>> modelMap) {
        HashMap<String, Map<Object, Object>> desensitizationMap = new HashMap<String, Map<Object, Object>>();
        for (Map.Entry<String, String> entry : allTablesMap.entrySet()) {
            String aliasName = entry.getKey();
            String modelName = entry.getValue();
            String key = com.cicv.foton.common.sdk.utils.StrUtil.concatStr("foton:application:datapermission:orgId:", this.appName, modelName, String.valueOf(orgId), "col");
            Set keys = this.dpRedisTemplate.keys((Object)key);
            if (Objects.isNull(keys) || keys.isEmpty()) {
                selectItemsMap.remove(aliasName);
                continue;
            }
            String rowKey = (String)keys.stream().findFirst().get();
            Map entries = this.dpRedisTemplate.opsForHash().entries((Object)rowKey);
            if (entries.isEmpty()) {
                selectItemsMap.remove(aliasName);
                continue;
            }
            String modelKey = com.cicv.foton.common.sdk.utils.StrUtil.concatStr("foton:application:datamodel:", this.appName, modelName);
            Set model = this.dpRedisTemplate.opsForSet().members((Object)modelKey);
            if (!Objects.isNull(model) && !model.isEmpty()) {
                modelMap.put(aliasName, model);
            }
            desensitizationMap.put(aliasName, entries);
        }
        return desensitizationMap;
    }

    private Object desensitize(Object object, boolean flag, Map<String, Map<Object, Object>> colInfoList, Map<String, List<SelectEntry>> selectItemsMap, double fieldPercent, Map<String, Set<Object>> modelMap) throws InvocationTargetException, IllegalAccessException {
        Object nullVal = null;
        Field[] fields = object.getClass().getDeclaredFields();
        Set<String> currentFeilds = ResponseBodyInterceptor.getCurrentFeilds(fields, object.getClass().getSuperclass());
        Map<String, Object> currentMap = ResponseBodyInterceptor.isCurrentLevel(currentFeilds, colInfoList, selectItemsMap, fieldPercent, modelMap);
        Map currentLevel = (Map)currentMap.get("currentMap");
        Set collect = (Set)currentMap.get("collect");
        Set keySet = currentLevel.keySet();
        for (String name : currentFeilds) {
            PropertyDescriptor ps = BeanUtils.getPropertyDescriptor(object.getClass(), (String)name);
            if (null == ps || ps.getReadMethod() == null || ps.getWriteMethod() == null) continue;
            Object value = ps.getReadMethod().invoke(object, new Object[0]);
            if (value instanceof Collection) {
                Collection objList = (Collection)value;
                for (Object obj : objList) {
                    this.desensitize(obj, com.cicv.foton.common.sdk.utils.StrUtil.isJson(obj), colInfoList, selectItemsMap, fieldPercent, modelMap);
                }
                continue;
            }
            if (value == null) continue;
            if (!currentLevel.isEmpty()) {
                if (keySet.contains(name)) {
                    if (!(value instanceof String)) continue;
                    String strValue = com.cicv.foton.common.sdk.utils.StrUtil.nvl(value);
                    ps.getWriteMethod().invoke(object, ResponseBodyInterceptor.getReplaceVal(strValue, currentLevel, name));
                    continue;
                }
                if (com.cicv.foton.common.sdk.utils.StrUtil.isJson(value)) {
                    this.desensitize(value, true, colInfoList, selectItemsMap, fieldPercent, modelMap);
                    continue;
                }
                if (collect.contains(name)) continue;
                ps.getWriteMethod().invoke(object, nullVal);
                continue;
            }
            if (!com.cicv.foton.common.sdk.utils.StrUtil.isJson(value)) continue;
            this.desensitize(value, true, colInfoList, selectItemsMap, fieldPercent, modelMap);
        }
        return object;
    }

    private static Object getReplaceVal(Object feildVal, Map<Object, Object> currentLevel, String key) {
        Integer deseType;
        Map colConfig = (Map)currentLevel.get(key);
        if (!Objects.isNull(colConfig) && !Objects.isNull(feildVal) && feildVal instanceof String && !Objects.isNull(deseType = (Integer)colConfig.get("deseType"))) {
            String replacedChar = (String)colConfig.get("replacedChar");
            String strValue = com.cicv.foton.common.sdk.utils.StrUtil.nvl(feildVal);
            if (Objects.equals(ConstantsSDK.PART_REPLACE, deseType)) {
                Integer startInclude = (Integer)colConfig.get("startInclude");
                Integer endExclude = (Integer)colConfig.get("endExclude");
                feildVal = com.cicv.foton.common.sdk.utils.StrUtil.replace((CharSequence)strValue, (int)(strValue.length() < startInclude ? strValue.length() : startInclude.intValue()), (int)(strValue.length() < endExclude ? strValue.length() : endExclude.intValue()), (CharSequence)replacedChar);
            } else if (Objects.equals(ConstantsSDK.ALL_REPLACE, deseType)) {
                feildVal = com.cicv.foton.common.sdk.utils.StrUtil.replace((CharSequence)strValue, (int)0, (int)strValue.length(), (CharSequence)replacedChar);
            }
        }
        return feildVal;
    }

    private static Set<String> getCurrentFeilds(Field[] fields, Class<?> superclass) {
        Set<String> currentKeySet = new HashSet<String>();
        for (Field field : fields) {
            currentKeySet.add(field.getName());
        }
        currentKeySet = ResponseBodyInterceptor.currentKeySet(currentKeySet, superclass);
        return currentKeySet;
    }

    private static Map<String, Object> isCurrentLevel(Set<String> getCurrentFeilds, Map<String, Map<Object, Object>> colInfoList, Map<String, List<SelectEntry>> selectItemsMap, double fieldPercent, Map<String, Set<Object>> modelMap) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        List<Object> collect = new ArrayList();
        HashSet<String> copiedSet = new HashSet<String>(getCurrentFeilds);
        HashMap<String, Object> currentMap = new HashMap<String, Object>();
        for (Map.Entry<String, List<SelectEntry>> entry : selectItemsMap.entrySet()) {
            double total;
            List<SelectEntry> value = entry.getValue();
            collect = value.stream().map(o -> StrUtil.toCamelCase((CharSequence)o.getColumnAliasName())).distinct().collect(Collectors.toList());
            HashSet intersection = new HashSet(collect);
            intersection.retainAll(getCurrentFeilds);
            double intersectionToal = intersection.size();
            double percent = intersectionToal / (total = (double)collect.size()) * 100.0;
            if (!(percent > fieldPercent)) continue;
            Map<Object, Object> map = colInfoList.get(entry.getKey());
            if (!Objects.isNull(map) && !map.isEmpty()) {
                for (Map.Entry<Object, Object> e : map.entrySet()) {
                    currentMap.put(com.cicv.foton.common.sdk.utils.StrUtil.toCamelCase((CharSequence)String.valueOf(e.getKey())), e.getValue());
                }
            }
            Set<Object> set = modelMap.get(entry.getKey());
            Set<Object> modelFeilds = new HashSet();
            if (!Objects.isNull(set)) {
                modelFeilds = set.stream().map(m -> com.cicv.foton.common.sdk.utils.StrUtil.toCamelCase((CharSequence)m.toString().replace("\"", ""))).distinct().collect(Collectors.toSet());
            }
            copiedSet.removeAll(modelFeilds);
            break;
        }
        resultMap.put("currentMap", currentMap);
        resultMap.put("collect", copiedSet);
        return resultMap;
    }

    private static Set<String> currentKeySet(Set<String> currentKeySet, Class<?> superclass) {
        Field[] superFields = superclass.getDeclaredFields();
        if (superFields.length > 0) {
            for (Field field : superFields) {
                currentKeySet.add(field.getName());
            }
            ResponseBodyInterceptor.currentKeySet(currentKeySet, superclass.getSuperclass());
        }
        return currentKeySet;
    }
}

