/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.common.sdk.utils;

import cn.spatiotemporal.web.core.constants.enums.ReturnEnum;
import cn.spatiotemporal.web.core.domain.entity.admin.User;
import cn.spatiotemporal.web.core.exception.BaseBusinessException;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.cicv.foton.common.sdk.utils.RedisDao;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class AuthorityUtils {
    private static final Logger log = LoggerFactory.getLogger(AuthorityUtils.class);
    @Value(value="${spatiotemporal.cache.jwtKey:spatiotemporal:jwt:token}")
    private String jwtKey;
    @Value(value="${spatiotemporal.cache.usernameKey:spatiotemporal:username}")
    private String usernameKey;
    @Value(value="${spatiotemporal.cache.expire:1800}")
    private int expire;
    @Value(value="${spatiotemporal.cache.delayExpireByAccess:false}")
    private boolean resume;
    @Resource
    private RedisDao redisDao;
    @Resource(name="dpRedisTemplate")
    private RedisTemplate<String, Object> dpRedisTemplate;
    private static RedisTemplate<String, Object> staticDpRedisTemplate;
    private static AuthorityUtils instance;

    @PostConstruct
    public void init() {
        instance = this;
        AuthorityUtils.instance.jwtKey = this.jwtKey;
        AuthorityUtils.instance.usernameKey = this.usernameKey;
        AuthorityUtils.instance.expire = this.expire;
        AuthorityUtils.instance.redisDao = this.redisDao;
        staticDpRedisTemplate = this.dpRedisTemplate;
    }

    public static String checkToken(String username) {
        return (String)staticDpRedisTemplate.opsForValue().get((Object)(AuthorityUtils.instance.usernameKey + ":" + username));
    }

    public static void putCurrentUser(String token, UserDetails user) {
        if (AuthorityUtils.instance.redisDao != null) {
            AuthorityUtils.instance.redisDao.put(AuthorityUtils.instance.jwtKey + ":" + token, user, AuthorityUtils.instance.expire);
            AuthorityUtils.instance.redisDao.put(AuthorityUtils.instance.usernameKey + ":" + user.getUsername(), token, AuthorityUtils.instance.expire);
        } else {
            log.error("AuthorityUtils.redisTemplate is null");
        }
        if (null != staticDpRedisTemplate) {
            staticDpRedisTemplate.opsForValue().set((Object)(AuthorityUtils.instance.jwtKey + ":" + token), (Object)user, (long)AuthorityUtils.instance.expire, TimeUnit.SECONDS);
            staticDpRedisTemplate.opsForValue().set((Object)(AuthorityUtils.instance.usernameKey + ":" + user.getUsername()), (Object)token, (long)AuthorityUtils.instance.expire, TimeUnit.SECONDS);
        } else {
            log.error("AuthorityUtils.dpredisTemplate is null");
        }
    }

    public static void putPrefixUser(String token, String prefix, UserDetails user) {
        if (AuthorityUtils.instance.redisDao != null) {
            AuthorityUtils.instance.redisDao.put(AuthorityUtils.instance.jwtKey + ":" + token, user, AuthorityUtils.instance.expire);
            AuthorityUtils.instance.redisDao.put(AuthorityUtils.instance.usernameKey + ":" + prefix + user.getUsername(), token, AuthorityUtils.instance.expire);
        } else {
            log.error("AuthorityUtils.redisTemplate is null");
        }
        if (null != staticDpRedisTemplate) {
            staticDpRedisTemplate.opsForValue().set((Object)(AuthorityUtils.instance.jwtKey + ":" + token), (Object)user, (long)AuthorityUtils.instance.expire, TimeUnit.SECONDS);
            staticDpRedisTemplate.opsForValue().set((Object)(AuthorityUtils.instance.usernameKey + ":" + user.getUsername()), (Object)token, (long)AuthorityUtils.instance.expire, TimeUnit.SECONDS);
        } else {
            log.error("AuthorityUtils.dpredisTemplate is null");
        }
    }

    public static UserDetails getCurrentUser4dp(String token) {
        Object object = staticDpRedisTemplate.opsForValue().get((Object)(AuthorityUtils.instance.jwtKey + ":" + token));
        if (null == object) {
            throw new BaseBusinessException(ReturnEnum.ERROR_TOKEN_EXPIRED);
        }
        if (object instanceof JSONObject) {
            return (UserDetails)((JSONObject)object).toJavaObject(User.class);
        }
        if (object instanceof Map) {
            String json = JSON.toJSONString((Object)((Map)object));
            return (UserDetails)JSON.parseObject((String)json, User.class);
        }
        String objStr = JSONObject.toJSONString((Object)object);
        return (UserDetails)JSONObject.parseObject((String)objStr, User.class);
    }

    public static UserDetails getCurrentUser(String token) {
        Object user = AuthorityUtils.instance.redisDao.get(AuthorityUtils.instance.jwtKey + ":" + token);
        if (user == null) {
            throw new BaseBusinessException(ReturnEnum.ERROR_TOKEN_EXPIRED);
        }
        if (user instanceof JSONObject) {
            return (UserDetails)((JSONObject)user).toJavaObject(User.class);
        }
        if (user instanceof Map) {
            String json = JSON.toJSONString((Object)((Map)user));
            return (UserDetails)JSON.parseObject((String)json, User.class);
        }
        return (UserDetails)AuthorityUtils.instance.redisDao.getBean(AuthorityUtils.instance.jwtKey + ":" + token, User.class);
    }

    public static UserDetails getCurrentUser() {
        UserDetails user = null;
        if (RequestContextHolder.getRequestAttributes() != null) {
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            if (request != null && request.getAttribute("portalUser") != null) {
                user = (UserDetails)request.getAttribute("portalUser");
            } else if (SecurityContextHolder.getContext().getAuthentication() != null) {
                Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
                if (principal instanceof UserDetails) {
                    user = (UserDetails)principal;
                } else {
                    User dummy = new User();
                    dummy.setUsername(String.valueOf(principal));
                    user = dummy;
                }
            }
        }
        return user;
    }

    public static User getLoginUser() {
        UserDetails user = null;
        if (RequestContextHolder.getRequestAttributes() != null) {
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            if (request != null && request.getAttribute("portalUser") != null) {
                user = (UserDetails)request.getAttribute("portalUser");
            } else if (SecurityContextHolder.getContext().getAuthentication() != null) {
                Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
                if (principal instanceof UserDetails) {
                    user = (UserDetails)principal;
                } else {
                    User dummy = new User();
                    dummy.setUsername(String.valueOf(principal));
                    user = dummy;
                }
            }
        }
        return (User)user;
    }

    public static boolean needResume() {
        return AuthorityUtils.instance.resume;
    }

    public static void resetExpire(String token, UserDetails user) {
        if (null != AuthorityUtils.instance.redisDao && AuthorityUtils.instance.redisDao.testConn()) {
            AuthorityUtils.instance.redisDao.expire(AuthorityUtils.instance.jwtKey + ":" + token, AuthorityUtils.instance.expire);
            AuthorityUtils.instance.redisDao.expire(AuthorityUtils.instance.usernameKey + ":" + user.getUsername(), AuthorityUtils.instance.expire);
        }
        if (null != staticDpRedisTemplate) {
            staticDpRedisTemplate.expire((Object)(AuthorityUtils.instance.jwtKey + ":" + token), (long)AuthorityUtils.instance.expire, TimeUnit.SECONDS);
            staticDpRedisTemplate.expire((Object)(AuthorityUtils.instance.usernameKey + ":" + user.getUsername()), (long)AuthorityUtils.instance.expire, TimeUnit.SECONDS);
        }
    }

    static {
        JSON.DEFAULT_GENERATE_FEATURE = SerializerFeature.config((int)JSON.DEFAULT_GENERATE_FEATURE, (SerializerFeature)SerializerFeature.SkipTransientField, (boolean)false);
    }
}

