/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.common.sdk.intercept;

import cn.hutool.core.util.ObjectUtil;
import cn.spatiotemporal.web.core.domain.entity.admin.User;
import com.baomidou.mybatisplus.core.plugins.InterceptorIgnoreHelper;
import com.baomidou.mybatisplus.core.toolkit.ClassUtils;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.extension.parser.JsqlParserSupport;
import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.toolkit.PropertyMapper;
import com.cicv.foton.common.sdk.domain.entity.BaseModel;
import com.cicv.foton.common.sdk.domain.entity.SelectEntry;
import com.cicv.foton.common.sdk.domain.entity.TableEntry;
import com.cicv.foton.common.sdk.extension.DataPermissionHandlerFactory;
import com.cicv.foton.common.sdk.service.SdkContext;
import com.cicv.foton.common.sdk.utils.StrUtil;
import com.cicv.foton.common.sdk.utils.ThreadLocalUtil;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.HexValue;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.NotExpression;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExistsExpression;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.MultiExpressionList;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.LateralSubSelect;
import net.sf.jsqlparser.statement.select.ParenthesisFromItem;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubJoin;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.ValuesList;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.statement.update.Update;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

public class TenantLineInnerInterceptor
extends JsqlParserSupport
implements InnerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(TenantLineInnerInterceptor.class);
    private TenantLineHandler tenantLineHandler;
    private List<String> ignoreTableNames;
    private RedisTemplate<String, Object> dpRedisTemplate;
    private String appName;
    private boolean isMaster;
    private DataPermissionHandlerFactory dataPermissionHandlerFactory;

    public TenantLineInnerInterceptor(TenantLineHandler tenantLineHandler, String appName, RedisTemplate<String, Object> dpRedisTemplate, boolean isMaster, DataPermissionHandlerFactory dataPermissionHandlerFactory) {
        this.tenantLineHandler = tenantLineHandler;
        this.dpRedisTemplate = dpRedisTemplate;
        this.appName = appName;
        this.isMaster = isMaster;
        this.dataPermissionHandlerFactory = dataPermissionHandlerFactory;
    }

    public void beforeQuery(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) throws SQLException {
        if (InterceptorIgnoreHelper.willIgnoreTenantLine((String)ms.getId())) {
            return;
        }
        PluginUtils.MPBoundSql mpBs = PluginUtils.mpBoundSql((BoundSql)boundSql);
        mpBs.sql(this.parserSingle(mpBs.sql(), null));
    }

    public void beforePrepare(StatementHandler sh, Connection connection, Integer transactionTimeout) {
        PluginUtils.MPStatementHandler mpSh = PluginUtils.mpStatementHandler((StatementHandler)sh);
        MappedStatement ms = mpSh.mappedStatement();
        SqlCommandType sct = ms.getSqlCommandType();
        if (sct == SqlCommandType.INSERT || sct == SqlCommandType.UPDATE || sct == SqlCommandType.DELETE) {
            if (InterceptorIgnoreHelper.willIgnoreTenantLine((String)ms.getId())) {
                return;
            }
            PluginUtils.MPBoundSql mpBs = mpSh.mPBoundSql();
            mpBs.sql(this.parserMulti(mpBs.sql(), null));
        }
    }

    protected void processSelect(Select select, int index, String sql, Object obj) {
        this.processSelectBody(select.getSelectBody());
        List withItemsList = select.getWithItemsList();
        if (!CollectionUtils.isEmpty((Collection)withItemsList)) {
            withItemsList.forEach(this::processSelectBody);
        }
        BaseModel allBaseModel = ThreadLocalUtil.getTables();
    }

    protected void processSelectBody(SelectBody selectBody) {
        if (selectBody == null) {
            return;
        }
        if (selectBody instanceof PlainSelect) {
            this.processPlainSelect((PlainSelect)selectBody);
        } else if (selectBody instanceof WithItem) {
            WithItem withItem = (WithItem)selectBody;
            this.processSelectBody(withItem.getSubSelect().getSelectBody());
        } else {
            SetOperationList operationList = (SetOperationList)selectBody;
            List selectBodys = operationList.getSelects();
            if (CollectionUtils.isNotEmpty((Collection)selectBodys)) {
                selectBodys.forEach(this::processSelectBody);
            }
        }
    }

    protected void processInsert(Insert insert, int index, String sql, Object obj) {
        Select select;
        Expression tenantId = this.tenantLineHandler.getTenantId();
        if (tenantId instanceof NullValue) {
            return;
        }
        if (this.tenantLineHandler.ignoreTable(insert.getTable().getName())) {
            return;
        }
        List columns = insert.getColumns();
        if (CollectionUtils.isEmpty((Collection)columns)) {
            return;
        }
        String tenantIdColumn = this.tenantLineHandler.getTenantIdColumn();
        if (this.tenantLineHandler.ignoreInsert(columns, tenantIdColumn)) {
            return;
        }
        columns.add(new Column(tenantIdColumn));
        List duplicateUpdateColumns = insert.getDuplicateUpdateExpressionList();
        if (CollectionUtils.isNotEmpty((Collection)duplicateUpdateColumns)) {
            EqualsTo equalsTo = new EqualsTo();
            equalsTo.setLeftExpression((Expression)new StringValue(tenantIdColumn));
            equalsTo.setRightExpression(this.tenantLineHandler.getTenantId());
            duplicateUpdateColumns.add(equalsTo);
        }
        if ((select = insert.getSelect()) != null) {
            this.processInsertSelect(select.getSelectBody());
        } else if (insert.getItemsList() != null) {
            ItemsList itemsList = insert.getItemsList();
            if (itemsList instanceof MultiExpressionList) {
                ((MultiExpressionList)itemsList).getExpressionLists().forEach(el -> el.getExpressions().add(this.tenantLineHandler.getTenantId()));
            } else {
                ((ExpressionList)itemsList).getExpressions().add(this.tenantLineHandler.getTenantId());
            }
        } else {
            throw ExceptionUtils.mpe((String)"Failed to process multiple-table update, please exclude the tableName or statementId", (Object[])new Object[0]);
        }
    }

    protected void processUpdate(Update update, int index, String sql, Object obj) {
        Table table = update.getTable();
        if (this.tenantLineHandler.ignoreTable(table.getName())) {
            return;
        }
        Expression tenantId = this.tenantLineHandler.getTenantId();
        if (tenantId instanceof NullValue) {
            return;
        }
        update.setWhere((Expression)this.andExpression(table, update.getWhere()));
    }

    protected void processDelete(Delete delete, int index, String sql, Object obj) {
        if (this.tenantLineHandler.ignoreTable(delete.getTable().getName())) {
            return;
        }
        Expression tenantId = this.tenantLineHandler.getTenantId();
        if (tenantId instanceof NullValue) {
            return;
        }
        delete.setWhere((Expression)this.andExpression(delete.getTable(), delete.getWhere()));
    }

    protected BinaryExpression andExpression(Table table, Expression where) {
        EqualsTo equalsTo = new EqualsTo();
        equalsTo.setLeftExpression((Expression)this.getAliasColumn(table));
        equalsTo.setRightExpression(this.tenantLineHandler.getTenantId());
        if (null != where) {
            if (where instanceof OrExpression) {
                return new AndExpression((Expression)equalsTo, (Expression)new Parenthesis(where));
            }
            return new AndExpression((Expression)equalsTo, where);
        }
        return equalsTo;
    }

    protected void processInsertSelect(SelectBody selectBody) {
        PlainSelect plainSelect = (PlainSelect)selectBody;
        FromItem fromItem = plainSelect.getFromItem();
        if (fromItem instanceof Table) {
            this.processPlainSelect(plainSelect);
            this.appendSelectItem(plainSelect.getSelectItems());
        } else if (fromItem instanceof SubSelect) {
            SubSelect subSelect = (SubSelect)fromItem;
            this.appendSelectItem(plainSelect.getSelectItems());
            this.processInsertSelect(subSelect.getSelectBody());
        }
    }

    protected void appendSelectItem(List<SelectItem> selectItems) {
        SelectItem item;
        if (CollectionUtils.isEmpty(selectItems)) {
            return;
        }
        if (selectItems.size() == 1 && ((item = selectItems.get(0)) instanceof AllColumns || item instanceof AllTableColumns)) {
            return;
        }
        selectItems.add((SelectItem)new SelectExpressionItem((Expression)new Column(this.tenantLineHandler.getTenantIdColumn())));
    }

    protected void processPlainSelect(PlainSelect plainSelect) {
        BaseModel baseModel = new BaseModel();
        ArrayList<SelectEntry> selectList = new ArrayList<SelectEntry>();
        ArrayList<TableEntry> fromList = new ArrayList<TableEntry>();
        ArrayList<TableEntry> joinList = new ArrayList<TableEntry>();
        List selectItems = plainSelect.getSelectItems();
        if (CollectionUtils.isNotEmpty((Collection)selectItems)) {
            selectItems.forEach(this::processSelectItem);
            for (SelectItem selectItem : selectItems) {
                if (selectItem instanceof SelectExpressionItem) {
                    SelectEntry selectEntry;
                    SelectExpressionItem selectExpressionItem = (SelectExpressionItem)selectItem;
                    if (selectExpressionItem.getExpression() instanceof Column) {
                        Column column = (Column)selectExpressionItem.getExpression();
                        selectEntry = new SelectEntry();
                        if (null != column.getTable()) {
                            selectEntry.setName(column.getTable().getName());
                        }
                        selectEntry.setColumnName(column.getColumnName());
                        if (null != selectExpressionItem.getAlias()) {
                            selectEntry.setColumnAliasName(selectExpressionItem.getAlias().getName());
                        } else {
                            selectEntry.setColumnAliasName(selectEntry.getColumnName());
                        }
                        selectList.add(selectEntry);
                        continue;
                    }
                    if (!(selectExpressionItem.getExpression() instanceof Function)) continue;
                    Function function = (Function)selectExpressionItem.getExpression();
                    selectEntry = new SelectEntry();
                    if (null != function) {
                        selectEntry.setColumnName(function.toString());
                    }
                    if (null != selectExpressionItem.getAlias()) {
                        selectEntry.setColumnAliasName(selectExpressionItem.getAlias().getName());
                    } else {
                        selectEntry.setColumnAliasName(selectEntry.getColumnName());
                    }
                    selectList.add(selectEntry);
                    continue;
                }
                log.error("### \u6355\u83b7 'select *' \u8fdd\u89c4SQL:'{}'\uff0c\u9700\u4fee\u6b63\uff01", (Object)plainSelect.toString());
            }
            baseModel.setSelectItems(selectList);
            this.putCombinedBaseModel(baseModel);
        }
        Expression where = plainSelect.getWhere();
        this.processWhereSubSelect(where);
        FromItem fromItem = plainSelect.getFromItem();
        if (fromItem instanceof Table) {
            Table fromTable = (Table)fromItem;
            TableEntry tableEntry = new TableEntry();
            tableEntry.setName(fromTable.getName());
            tableEntry.setAliasName(null != fromTable.getAlias() ? fromTable.getAlias().getName() : tableEntry.getName());
            fromList.add(tableEntry);
            baseModel.setFromItems(fromList);
            this.putCombinedBaseModel(baseModel);
        }
        List<Table> list = this.processFromItem(fromItem);
        List<Table> mainTables = new ArrayList<Table>(list);
        List joins = plainSelect.getJoins();
        if (CollectionUtils.isNotEmpty((Collection)joins)) {
            mainTables = this.processJoins(mainTables, joins);
            for (Join join : joins) {
                FromItem joinItem = join.getRightItem();
                if (!(joinItem instanceof Table)) continue;
                Table tbl = (Table)joinItem;
                TableEntry tableEntry = new TableEntry();
                tableEntry.setName(tbl.getName());
                tableEntry.setAliasName(null != tbl.getAlias() ? tbl.getAlias().getName() : tableEntry.getName());
                joinList.add(tableEntry);
            }
            baseModel.setJoinItems(joinList);
            this.putCombinedBaseModel(baseModel);
        }
        log.info("1.OriginalExpression: {}", (Object)(Objects.isNull(where) ? null : where.toString()));
        Expression tenantExpression = where;
        if (CollectionUtils.isNotEmpty(mainTables) && null != (tenantExpression = this.builderExpression(where, mainTables))) {
            log.info("2.TenantExpression: {}", (Object)tenantExpression.toString());
            plainSelect.setWhere(tenantExpression);
        }
        if (CollectionUtils.isNotEmpty(baseModel.getFromItems()) || CollectionUtils.isNotEmpty(baseModel.getJoinItems())) {
            this.processBaseModel(baseModel);
            Expression dpExpression = this.builderExpression(tenantExpression, baseModel, mainTables);
            if (null != dpExpression) {
                log.info("3.DpExpression: {}", (Object)dpExpression.toString());
                plainSelect.setWhere(dpExpression);
            }
        }
    }

    private BaseModel processBaseModel(BaseModel baseModel) {
        HashMap<String, String> allTables = new HashMap<String, String>();
        BaseModel threadBaseModel = ThreadLocalUtil.getTables();
        if (null != threadBaseModel) {
            allTables.putAll(threadBaseModel.getAllTables());
        }
        if (CollectionUtils.isNotEmpty(baseModel.getFromItems())) {
            Map<String, String> fromaTables = baseModel.getFromItems().stream().collect(Collectors.toMap(TableEntry::getAliasName, TableEntry::getName, (value1, value2) -> value2));
            allTables.putAll(fromaTables);
        }
        if (CollectionUtils.isNotEmpty(baseModel.getJoinItems())) {
            Map<String, String> joinTables = baseModel.getJoinItems().stream().collect(Collectors.toMap(TableEntry::getAliasName, TableEntry::getName, (value1, value2) -> value2));
            allTables.putAll(joinTables);
        }
        if (CollectionUtils.isNotEmpty(baseModel.getSelectItems())) {
            Iterator<Serializable> iterator = baseModel.getSelectItems().iterator();
            while (iterator.hasNext()) {
                SelectEntry select;
                String tmpName = StrUtil.nvl((select = iterator.next()).getAliasName());
                String tblName = (String)allTables.get(tmpName);
                select.setName(StringUtils.isNotEmpty((String)tblName) ? tblName : select.getName());
                tmpName = StrUtil.nvl(select.getName());
                tblName = (String)allTables.get(tmpName);
                if (!StringUtils.isNotEmpty((String)tblName)) continue;
                select.setAliasName(tmpName);
                select.setName(tblName);
            }
        }
        if (CollectionUtils.isNotEmpty(baseModel.getFromItems()) && CollectionUtils.isNotEmpty(baseModel.getSelectItems())) {
            for (TableEntry table : baseModel.getFromItems()) {
                for (SelectEntry select : baseModel.getSelectItems()) {
                    if (StringUtils.isEmpty((String)select.getName())) {
                        select.setName(table.getName());
                    }
                    if (!StringUtils.isEmpty((String)select.getAliasName())) continue;
                    select.setAliasName(table.getAliasName());
                }
            }
        }
        baseModel.setAllTables(allTables);
        this.putCombinedBaseModel(baseModel);
        return baseModel;
    }

    private void putCombinedBaseModel(BaseModel baseModel) {
        BaseModel tmpBaseModel = (BaseModel)ObjectUtil.clone((Object)baseModel);
        BaseModel threadBaseModel = ThreadLocalUtil.getTables();
        if (null != tmpBaseModel) {
            HashMap<String, String> allTables = new HashMap<String, String>();
            if (CollectionUtils.isNotEmpty(tmpBaseModel.getFromItems())) {
                Map<String, String> fromaTables = tmpBaseModel.getFromItems().stream().collect(Collectors.toMap(TableEntry::getAliasName, TableEntry::getName, (value1, value2) -> value2));
                allTables.putAll(fromaTables);
            }
            if (CollectionUtils.isNotEmpty(tmpBaseModel.getJoinItems())) {
                Map<String, String> joinTables = tmpBaseModel.getJoinItems().stream().collect(Collectors.toMap(TableEntry::getAliasName, TableEntry::getName, (value1, value2) -> value2));
                allTables.putAll(joinTables);
            }
            tmpBaseModel.setAllTables(allTables);
            if (null != threadBaseModel) {
                HashMap baseTables = tmpBaseModel.getAllTables();
                HashMap threadTables = threadBaseModel.getAllTables();
                baseTables = baseTables == null ? new HashMap() : baseTables;
                threadTables = threadTables == null ? new HashMap() : threadTables;
                HashMap<String, String> combinedAllTables = new HashMap<String, String>(baseTables);
                combinedAllTables.putAll(threadTables);
                tmpBaseModel.setAllTables(combinedAllTables);
                ArrayList<SelectEntry> combinedSelectItems = new ArrayList<SelectEntry>();
                if (CollectionUtils.isNotEmpty(threadBaseModel.getSelectItems())) {
                    combinedSelectItems.addAll(threadBaseModel.getSelectItems());
                }
                if (CollectionUtils.isNotEmpty(tmpBaseModel.getSelectItems())) {
                    combinedSelectItems.addAll(tmpBaseModel.getSelectItems());
                }
                combinedSelectItems.removeIf(item -> StringUtils.isEmpty((String)item.getName()));
                if (CollectionUtils.isNotEmpty(combinedSelectItems)) {
                    Iterator iterator = combinedSelectItems.iterator();
                    while (iterator.hasNext()) {
                        Object select;
                        String tmpName = StrUtil.nvl(((SelectEntry)(select = (SelectEntry)iterator.next())).getAliasName());
                        String tblName = (String)allTables.get(tmpName);
                        ((SelectEntry)select).setName(StringUtils.isNotEmpty((String)tblName) ? tblName : ((SelectEntry)select).getName());
                        tmpName = StrUtil.nvl(((SelectEntry)select).getName());
                        tblName = (String)allTables.get(tmpName);
                        if (!StringUtils.isNotEmpty((String)tblName)) continue;
                        ((SelectEntry)select).setAliasName(tmpName);
                        ((SelectEntry)select).setName(tblName);
                    }
                }
                ArrayList<SelectEntry> uniqueSelectItems = new ArrayList<SelectEntry>();
                for (SelectEntry entry : combinedSelectItems) {
                    boolean isDuplicate = false;
                    for (SelectEntry uniqueEntry : uniqueSelectItems) {
                        if (!Objects.equals(entry.getName(), uniqueEntry.getName()) || !Objects.equals(entry.getAliasName(), uniqueEntry.getAliasName()) || !Objects.equals(entry.getColumnName(), uniqueEntry.getColumnName()) || !Objects.equals(entry.getColumnAliasName(), uniqueEntry.getColumnAliasName())) continue;
                        isDuplicate = true;
                        break;
                    }
                    if (isDuplicate) continue;
                    uniqueSelectItems.add(entry);
                }
                tmpBaseModel.setSelectItems(uniqueSelectItems);
                ArrayList<TableEntry> combinedFromItems = new ArrayList<TableEntry>();
                if (CollectionUtils.isNotEmpty(threadBaseModel.getFromItems())) {
                    combinedFromItems.addAll(threadBaseModel.getFromItems());
                }
                if (CollectionUtils.isNotEmpty(tmpBaseModel.getFromItems())) {
                    combinedFromItems.addAll(tmpBaseModel.getFromItems());
                }
                ArrayList<TableEntry> uniqueFromItems = new ArrayList<TableEntry>();
                for (TableEntry entry : combinedFromItems) {
                    boolean isDuplicate = false;
                    for (TableEntry uniqueEntry : uniqueFromItems) {
                        if (!Objects.equals(entry.getName(), uniqueEntry.getName()) || !Objects.equals(entry.getAliasName(), uniqueEntry.getAliasName())) continue;
                        isDuplicate = true;
                        break;
                    }
                    if (isDuplicate) continue;
                    uniqueFromItems.add(entry);
                }
                tmpBaseModel.setFromItems(uniqueFromItems);
                ArrayList<TableEntry> combinedJoinItems = new ArrayList<TableEntry>();
                if (CollectionUtils.isNotEmpty(threadBaseModel.getJoinItems())) {
                    combinedJoinItems.addAll(threadBaseModel.getJoinItems());
                }
                if (CollectionUtils.isNotEmpty(tmpBaseModel.getJoinItems())) {
                    combinedJoinItems.addAll(tmpBaseModel.getJoinItems());
                }
                ArrayList<TableEntry> uniqueJoinItems = new ArrayList<TableEntry>();
                for (TableEntry entry : combinedJoinItems) {
                    boolean isDuplicate = false;
                    for (TableEntry uniqueEntry : uniqueJoinItems) {
                        if (!Objects.equals(entry.getName(), uniqueEntry.getName()) || !Objects.equals(entry.getAliasName(), uniqueEntry.getAliasName())) continue;
                        isDuplicate = true;
                        break;
                    }
                    if (isDuplicate) continue;
                    uniqueJoinItems.add(entry);
                }
                tmpBaseModel.setJoinItems(uniqueJoinItems);
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("tablesName", tmpBaseModel);
            ThreadLocalUtil.getInstance().setContext(map);
        }
    }

    private BaseModel superposeBaseModel(BaseModel tables, BaseModel baseModel) {
        Map<String, String> allTables = tables.getAllTables();
        List<SelectEntry> selectItems = tables.getSelectItems();
        if (!Objects.isNull(baseModel)) {
            Map<String, String> nextAllTables = baseModel.getAllTables();
            List<SelectEntry> nextSelectItems = baseModel.getSelectItems();
            if (!nextAllTables.isEmpty()) {
                allTables.putAll(nextAllTables);
            }
            if (!nextSelectItems.isEmpty()) {
                selectItems.addAll(nextSelectItems);
            }
        }
        tables.setAllTables(allTables);
        tables.setSelectItems(selectItems);
        return tables;
    }

    private List<Table> processFromItem(FromItem fromItem) {
        while (fromItem instanceof ParenthesisFromItem) {
            fromItem = ((ParenthesisFromItem)fromItem).getFromItem();
        }
        ArrayList<Table> mainTables = new ArrayList<Table>();
        if (fromItem instanceof Table) {
            Table fromTable = (Table)fromItem;
            if (!this.tenantLineHandler.ignoreTable(fromTable.getName())) {
                mainTables.add(fromTable);
            }
        } else if (fromItem instanceof SubJoin) {
            List<Table> tables = this.processSubJoin((SubJoin)fromItem);
            mainTables.addAll(tables);
        } else {
            this.processOtherFromItem(fromItem);
        }
        return mainTables;
    }

    protected void processWhereSubSelect(Expression where) {
        if (where == null) {
            return;
        }
        if (where instanceof FromItem) {
            this.processOtherFromItem((FromItem)where);
            return;
        }
        if (where.toString().indexOf("SELECT") > 0) {
            if (where instanceof BinaryExpression) {
                BinaryExpression expression = (BinaryExpression)where;
                this.processWhereSubSelect(expression.getLeftExpression());
                this.processWhereSubSelect(expression.getRightExpression());
            } else if (where instanceof InExpression) {
                InExpression expression = (InExpression)where;
                Expression inExpression = expression.getRightExpression();
                if (inExpression instanceof SubSelect) {
                    this.processSelectBody(((SubSelect)inExpression).getSelectBody());
                }
            } else if (where instanceof ExistsExpression) {
                ExistsExpression expression = (ExistsExpression)where;
                this.processWhereSubSelect(expression.getRightExpression());
            } else if (where instanceof NotExpression) {
                NotExpression expression = (NotExpression)where;
                this.processWhereSubSelect(expression.getExpression());
            } else if (where instanceof Parenthesis) {
                Parenthesis expression = (Parenthesis)where;
                this.processWhereSubSelect(expression.getExpression());
            }
        }
    }

    protected void processSelectItem(SelectItem selectItem) {
        if (selectItem instanceof SelectExpressionItem) {
            SelectExpressionItem selectExpressionItem = (SelectExpressionItem)selectItem;
            if (selectExpressionItem.getExpression() instanceof SubSelect) {
                this.processSelectBody(((SubSelect)selectExpressionItem.getExpression()).getSelectBody());
            } else if (selectExpressionItem.getExpression() instanceof Function) {
                this.processFunction((Function)selectExpressionItem.getExpression());
            }
        }
    }

    protected void processFunction(Function function) {
        ExpressionList parameters = function.getParameters();
        if (parameters != null) {
            parameters.getExpressions().forEach(expression -> {
                if (expression instanceof SubSelect) {
                    this.processSelectBody(((SubSelect)expression).getSelectBody());
                } else if (expression instanceof Function) {
                    this.processFunction((Function)expression);
                }
            });
        }
    }

    protected void processOtherFromItem(FromItem fromItem) {
        SubSelect subSelect;
        LateralSubSelect lateralSubSelect;
        while (fromItem instanceof ParenthesisFromItem) {
            fromItem = ((ParenthesisFromItem)fromItem).getFromItem();
        }
        if (fromItem instanceof SubSelect) {
            SubSelect subSelect2 = (SubSelect)fromItem;
            if (subSelect2.getSelectBody() != null) {
                this.processSelectBody(subSelect2.getSelectBody());
            }
        } else if (fromItem instanceof ValuesList) {
            this.logger.debug("Perform a subquery, if you do not give us feedback");
        } else if (fromItem instanceof LateralSubSelect && (lateralSubSelect = (LateralSubSelect)fromItem).getSubSelect() != null && (subSelect = lateralSubSelect.getSubSelect()).getSelectBody() != null) {
            this.processSelectBody(subSelect.getSelectBody());
        }
    }

    private List<Table> processSubJoin(SubJoin subJoin) {
        List<Table> mainTables = new ArrayList<Table>();
        if (subJoin.getJoinList() != null) {
            List<Table> list = this.processFromItem(subJoin.getLeft());
            mainTables.addAll(list);
            mainTables = this.processJoins(mainTables, subJoin.getJoinList());
        }
        return mainTables;
    }

    private List<Table> processJoins(List<Table> mainTables, List<Join> joins) {
        if (mainTables == null) {
            mainTables = new ArrayList<Table>();
        }
        Table mainTable = null;
        Table leftTable = null;
        if (mainTables.size() == 1) {
            leftTable = mainTable = mainTables.get(0);
        }
        LinkedList<List<Table>> onTableDeque = new LinkedList<List<Table>>();
        for (Join join : joins) {
            FromItem joinItem = join.getRightItem();
            List<Object> joinTables = null;
            if (joinItem instanceof Table) {
                joinTables = new ArrayList<Table>();
                joinTables.add((Table)joinItem);
            } else if (joinItem instanceof SubJoin) {
                joinTables = this.processSubJoin((SubJoin)joinItem);
            }
            if (joinTables != null) {
                LinkedList<Expression> onExpressions;
                Collection originOnExpressions;
                if (join.isSimple()) {
                    mainTables.addAll(joinTables);
                    continue;
                }
                Table joinTable = (Table)joinTables.get(0);
                boolean joinTableNeedIgnore = this.tenantLineHandler.ignoreTable(joinTable.getName());
                List<Table> onTables = null;
                if (join.isRight()) {
                    Table table = mainTable = joinTableNeedIgnore ? null : joinTable;
                    if (leftTable != null) {
                        onTables = Collections.singletonList(leftTable);
                    }
                } else if (join.isLeft()) {
                    if (!joinTableNeedIgnore) {
                        onTables = Collections.singletonList(joinTable);
                    }
                } else if (join.isInner()) {
                    onTables = mainTable == null ? Collections.singletonList(joinTable) : Arrays.asList(mainTable, joinTable);
                    mainTable = null;
                }
                mainTables = new ArrayList<Table>();
                if (mainTable != null) {
                    mainTables.add(mainTable);
                }
                if ((originOnExpressions = join.getOnExpressions()).size() == 1 && onTables != null) {
                    onExpressions = new LinkedList<Expression>();
                    onExpressions.add(this.builderExpression((Expression)originOnExpressions.iterator().next(), onTables));
                    join.setOnExpressions(onExpressions);
                    leftTable = joinTable;
                    continue;
                }
                onTableDeque.push(onTables);
                if (originOnExpressions.size() > 1) {
                    onExpressions = new LinkedList();
                    for (Expression originOnExpression : originOnExpressions) {
                        List currentTableList = (List)onTableDeque.poll();
                        if (CollectionUtils.isEmpty((Collection)currentTableList)) {
                            onExpressions.add(originOnExpression);
                            continue;
                        }
                        onExpressions.add(this.builderExpression(originOnExpression, currentTableList));
                    }
                    join.setOnExpressions(onExpressions);
                }
                leftTable = joinTable;
                continue;
            }
            this.processOtherFromItem(joinItem);
            leftTable = null;
        }
        return mainTables;
    }

    protected Expression builderExpression(Expression currentExpression, BaseModel baseModel, List<Table> mainTables) {
        if (CollectionUtils.isEmpty(baseModel.getFromItems())) {
            return currentExpression;
        }
        if (!Objects.isNull(baseModel)) {
            Map<String, String> allTablesMap = baseModel.getAllTables();
            for (Map.Entry<String, String> entry : allTablesMap.entrySet()) {
                String aliasName = entry.getKey();
                String tableName = entry.getValue();
                if (!StringUtils.isNotBlank((String)tableName)) continue;
                Expression dpExpression = this.processDataPermission(aliasName, tableName, mainTables);
                return this.getExpression(currentExpression, dpExpression);
            }
        }
        return currentExpression;
    }

    private boolean isMainTable(String tableName, List<Table> mainTables) {
        if (Objects.isNull(mainTables) || mainTables.isEmpty()) {
            return false;
        }
        for (Table table : mainTables) {
            if (!Objects.equals(tableName, table.getName())) continue;
            return true;
        }
        return false;
    }

    public Expression processDataPermission(String aliasName, String tableName, List<Table> mainTables) {
        HexValue where = new HexValue(" 1 = 1 ");
        if (!this.isMaster) {
            try {
                User user = SdkContext.getCurrentUser();
                if (SdkContext.isQueryAll(user)) {
                    return new HexValue(" 1 = 1 ");
                }
                if (!(Objects.isNull(user) || Objects.isNull(user.getTenantId()) || Objects.isNull(user.getOrgId()))) {
                    Long orgId = user.getOrgId();
                    Map<Object, Object> rwowMap = this.getRowInfo(tableName, orgId);
                    if (Objects.isNull(rwowMap)) {
                        return new HexValue(" 1 = 2 ");
                    }
                    if (!Objects.isNull(rwowMap) && !rwowMap.isEmpty() && this.isMainTable(tableName, mainTables)) {
                        for (Object key : rwowMap.keySet()) {
                            Object object = rwowMap.get(key);
                            if (Objects.isNull(object)) continue;
                            Map val = (Map)object;
                            if (!(val.isEmpty() || Objects.isNull(val.get("oper")) || Objects.isNull(val.get("val")))) {
                                Column column = this.getAliasColumnDym(aliasName, String.valueOf(key));
                                String oper = (String)val.get("oper");
                                Object value = val.get("val");
                                ArrayList<Object> valueList = new ArrayList<Object>();
                                switch (oper) {
                                    case "contain": {
                                        valueList.add(value);
                                        InExpression inExpression = this.inExpression(valueList, column, false);
                                        where = new AndExpression((Expression)where, (Expression)inExpression);
                                        break;
                                    }
                                    case "uncontain": {
                                        valueList.add(value);
                                        InExpression notInExpression = this.inExpression(valueList, column, true);
                                        where = new AndExpression((Expression)where, (Expression)notInExpression);
                                        break;
                                    }
                                    case "gt": {
                                        GreaterThan gt = new GreaterThan();
                                        gt.setLeftExpression((Expression)column);
                                        gt.setRightExpression((Expression)new StringValue(String.valueOf(value)));
                                        where = new AndExpression((Expression)where, (Expression)gt);
                                        break;
                                    }
                                    case "lt": {
                                        MinorThan lt = new MinorThan();
                                        lt.setLeftExpression((Expression)column);
                                        lt.setRightExpression((Expression)new StringValue(String.valueOf(value)));
                                        where = new AndExpression((Expression)where, (Expression)lt);
                                        break;
                                    }
                                    case "ge": {
                                        GreaterThanEquals ge = new GreaterThanEquals();
                                        ge.setLeftExpression((Expression)column);
                                        ge.setRightExpression((Expression)new StringValue(String.valueOf(value)));
                                        where = new AndExpression((Expression)where, (Expression)ge);
                                        break;
                                    }
                                    case "le": {
                                        MinorThanEquals le = new MinorThanEquals();
                                        le.setLeftExpression((Expression)column);
                                        le.setRightExpression((Expression)new StringValue(String.valueOf(value)));
                                        where = new AndExpression((Expression)where, (Expression)le);
                                        break;
                                    }
                                    case "ne": {
                                        IsNullExpression isNotNullExpression = new IsNullExpression();
                                        isNotNullExpression.setLeftExpression((Expression)column);
                                        isNotNullExpression.setNot(true);
                                        where = new AndExpression((Expression)where, (Expression)isNotNullExpression);
                                        break;
                                    }
                                    case "ie": {
                                        IsNullExpression isNullExpression = new IsNullExpression();
                                        isNullExpression.setLeftExpression((Expression)column);
                                        isNullExpression.setNot(false);
                                        where = new AndExpression((Expression)where, (Expression)isNullExpression);
                                        break;
                                    }
                                }
                                continue;
                            }
                            break;
                        }
                    }
                } else {
                    return new HexValue(" 1 = 1 ");
                }
                return where;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return where;
    }

    private Map<Object, Object> getRowInfo(String mainTableName, Long orgId) {
        String key = StrUtil.concatStr("foton:application:datapermission:orgId:", this.appName, mainTableName, String.valueOf(orgId), "row");
        Set keys = this.dpRedisTemplate.keys((Object)key);
        if (keys.isEmpty()) {
            return null;
        }
        String rowKey = (String)keys.stream().findFirst().get();
        return this.dpRedisTemplate.opsForHash().entries((Object)rowKey);
    }

    protected Column getAliasColumnDym(String aliasName, String fieldName) {
        StringBuilder column = new StringBuilder(aliasName);
        column.append(".").append(fieldName);
        return new Column(column.toString());
    }

    protected Expression builderExpression(Expression currentExpression, List<Table> tables) {
        Table table;
        String name;
        if (CollectionUtils.isEmpty(tables)) {
            return currentExpression;
        }
        ArrayList<OrExpression> orExpressions = new ArrayList<OrExpression>();
        Iterator<Table> iterator = tables.iterator();
        while (iterator.hasNext() && !this.tenantLineHandler.ignoreTable(name = (table = iterator.next()).getName())) {
            Expression tenantId = this.tenantLineHandler.getTenantId();
            if (tenantId instanceof NullValue) continue;
            EqualsTo leftEqualsTo = new EqualsTo((Expression)this.getAliasColumn(table), tenantId);
            EqualsTo rightEqualsTo = new EqualsTo((Expression)this.getAliasColumn(table), (Expression)new LongValue(-1L));
            orExpressions.add(new OrExpression((Expression)leftEqualsTo, (Expression)rightEqualsTo));
        }
        if (orExpressions.size() > 0) {
            Expression injectExpression = (Expression)orExpressions.get(0);
            if (orExpressions.size() > 1) {
                for (int i = 1; i < orExpressions.size(); ++i) {
                    injectExpression = new AndExpression((Expression)new Parenthesis(injectExpression), (Expression)new Parenthesis((Expression)orExpressions.get(i)));
                }
            }
            return this.getExpression(currentExpression, injectExpression);
        }
        return this.getExpression(currentExpression, null);
    }

    private Expression getExpression(Expression expression1, Expression expression2) {
        return null != expression1 && null != expression2 ? new AndExpression((Expression)new Parenthesis(expression1), (Expression)new Parenthesis(expression2)) : (null != expression1 ? expression1 : expression2);
    }

    private InExpression inExpression(List<Object> valueList, Column column, boolean not) {
        InExpression inExpression = new InExpression();
        inExpression.setLeftExpression((Expression)column);
        ExpressionList expressionList = new ExpressionList();
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        for (Object value : valueList) {
            this.addExpressions(expressions, value);
        }
        expressionList.setExpressions(expressions);
        inExpression.setRightItemsList((ItemsList)expressionList);
        inExpression.setNot(not);
        return inExpression;
    }

    private void addExpressions(List<Expression> expressions, Object value) {
        String strVal = StrUtil.nvl(value);
        if (value instanceof String) {
            expressions.add((Expression)new StringValue(strVal));
        } else if (value instanceof Integer || value instanceof Long) {
            expressions.add((Expression)new LongValue(Long.valueOf(strVal).longValue()));
        } else if (value instanceof Double) {
            expressions.add((Expression)new DoubleValue(strVal));
        }
    }

    protected Column getAliasColumn(Table table) {
        StringBuilder column = new StringBuilder();
        if (table.getAlias() != null) {
            column.append(table.getAlias().getName());
        } else {
            column.append(table.getName());
        }
        column.append(".").append(this.tenantLineHandler.getTenantIdColumn());
        return new Column(column.toString());
    }

    public void setProperties(Properties properties) {
        PropertyMapper.newInstance((Properties)properties).whenNotBlank("tenantLineHandler", ClassUtils::newInstance, this::setTenantLineHandler);
    }

    public TenantLineHandler getTenantLineHandler() {
        return this.tenantLineHandler;
    }

    public List<String> getIgnoreTableNames() {
        return this.ignoreTableNames;
    }

    public RedisTemplate<String, Object> getDpRedisTemplate() {
        return this.dpRedisTemplate;
    }

    public String getAppName() {
        return this.appName;
    }

    public boolean isMaster() {
        return this.isMaster;
    }

    public DataPermissionHandlerFactory getDataPermissionHandlerFactory() {
        return this.dataPermissionHandlerFactory;
    }

    public void setTenantLineHandler(TenantLineHandler tenantLineHandler) {
        this.tenantLineHandler = tenantLineHandler;
    }

    public void setIgnoreTableNames(List<String> ignoreTableNames) {
        this.ignoreTableNames = ignoreTableNames;
    }

    public void setDpRedisTemplate(RedisTemplate<String, Object> dpRedisTemplate) {
        this.dpRedisTemplate = dpRedisTemplate;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setMaster(boolean isMaster) {
        this.isMaster = isMaster;
    }

    public void setDataPermissionHandlerFactory(DataPermissionHandlerFactory dataPermissionHandlerFactory) {
        this.dataPermissionHandlerFactory = dataPermissionHandlerFactory;
    }

    public TenantLineInnerInterceptor() {
    }

    public TenantLineInnerInterceptor(TenantLineHandler tenantLineHandler, List<String> ignoreTableNames, RedisTemplate<String, Object> dpRedisTemplate, String appName, boolean isMaster, DataPermissionHandlerFactory dataPermissionHandlerFactory) {
        this.tenantLineHandler = tenantLineHandler;
        this.ignoreTableNames = ignoreTableNames;
        this.dpRedisTemplate = dpRedisTemplate;
        this.appName = appName;
        this.isMaster = isMaster;
        this.dataPermissionHandlerFactory = dataPermissionHandlerFactory;
    }

    public String toString() {
        return "TenantLineInnerInterceptor(super=" + super.toString() + ", tenantLineHandler=" + this.getTenantLineHandler() + ", ignoreTableNames=" + this.getIgnoreTableNames() + ", dpRedisTemplate=" + this.getDpRedisTemplate() + ", appName=" + this.getAppName() + ", isMaster=" + this.isMaster() + ", dataPermissionHandlerFactory=" + this.getDataPermissionHandlerFactory() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TenantLineInnerInterceptor)) {
            return false;
        }
        TenantLineInnerInterceptor other = (TenantLineInnerInterceptor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isMaster() != other.isMaster()) {
            return false;
        }
        TenantLineHandler this$tenantLineHandler = this.getTenantLineHandler();
        TenantLineHandler other$tenantLineHandler = other.getTenantLineHandler();
        if (this$tenantLineHandler == null ? other$tenantLineHandler != null : !this$tenantLineHandler.equals(other$tenantLineHandler)) {
            return false;
        }
        List<String> this$ignoreTableNames = this.getIgnoreTableNames();
        List<String> other$ignoreTableNames = other.getIgnoreTableNames();
        if (this$ignoreTableNames == null ? other$ignoreTableNames != null : !((Object)this$ignoreTableNames).equals(other$ignoreTableNames)) {
            return false;
        }
        RedisTemplate<String, Object> this$dpRedisTemplate = this.getDpRedisTemplate();
        RedisTemplate<String, Object> other$dpRedisTemplate = other.getDpRedisTemplate();
        if (this$dpRedisTemplate == null ? other$dpRedisTemplate != null : !this$dpRedisTemplate.equals(other$dpRedisTemplate)) {
            return false;
        }
        String this$appName = this.getAppName();
        String other$appName = other.getAppName();
        if (this$appName == null ? other$appName != null : !this$appName.equals(other$appName)) {
            return false;
        }
        DataPermissionHandlerFactory this$dataPermissionHandlerFactory = this.getDataPermissionHandlerFactory();
        DataPermissionHandlerFactory other$dataPermissionHandlerFactory = other.getDataPermissionHandlerFactory();
        return !(this$dataPermissionHandlerFactory == null ? other$dataPermissionHandlerFactory != null : !this$dataPermissionHandlerFactory.equals(other$dataPermissionHandlerFactory));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TenantLineInnerInterceptor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isMaster() ? 79 : 97);
        TenantLineHandler $tenantLineHandler = this.getTenantLineHandler();
        result = result * 59 + ($tenantLineHandler == null ? 43 : $tenantLineHandler.hashCode());
        List<String> $ignoreTableNames = this.getIgnoreTableNames();
        result = result * 59 + ($ignoreTableNames == null ? 43 : ((Object)$ignoreTableNames).hashCode());
        RedisTemplate<String, Object> $dpRedisTemplate = this.getDpRedisTemplate();
        result = result * 59 + ($dpRedisTemplate == null ? 43 : $dpRedisTemplate.hashCode());
        String $appName = this.getAppName();
        result = result * 59 + ($appName == null ? 43 : $appName.hashCode());
        DataPermissionHandlerFactory $dataPermissionHandlerFactory = this.getDataPermissionHandlerFactory();
        result = result * 59 + ($dataPermissionHandlerFactory == null ? 43 : $dataPermissionHandlerFactory.hashCode());
        return result;
    }
}

