/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.common.sdk.aspect;

import com.cicv.foton.common.sdk.annotation.TableAccess;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class GroupDataAccessAspect {
    @Around(value="@annotation(tableAccess)")
    public Object interceptTableAccess(ProceedingJoinPoint joinPoint, TableAccess tableAccess) throws Throwable {
        String[] tableNames = tableAccess.value();
        Long groupId = 123L;
        HashMap<String, Long> tableAccessMap = new HashMap<String, Long>();
        for (String tableName : tableNames) {
            tableAccessMap.put(tableName, groupId);
        }
        return this.proceedWithParams(joinPoint, tableAccessMap);
    }

    private Object proceedWithParams(ProceedingJoinPoint joinPoint, Map<String, Long> tableAccessMap) throws Throwable {
        Object[] args = joinPoint.getArgs();
        args = Arrays.copyOf(args, args.length + 1);
        args[args.length - 1] = tableAccessMap;
        return joinPoint.proceed(args);
    }
}

