/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.common.sdk.extension;

import com.cicv.foton.common.sdk.extension.DataPermissionHandler;
import com.cicv.foton.common.sdk.extension.DataPermissionHandlerProvider;
import com.cicv.foton.common.sdk.extension.DataQueryContext;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class DataPermissionHandlerFactory {
    private final ApplicationContext applicationContext;
    private List<DataPermissionHandlerProvider> providers;

    @Autowired
    public DataPermissionHandlerFactory(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @PostConstruct
    public void init() {
        this.providers = this.applicationContext.getBeansOfType(DataPermissionHandlerProvider.class).values().stream().collect(Collectors.toList());
        ServiceLoader<DataPermissionHandlerProvider> spiLoader = ServiceLoader.load(DataPermissionHandlerProvider.class);
        List spiProviders = StreamSupport.stream(spiLoader.spliterator(), false).collect(Collectors.toList());
        this.providers.addAll(spiProviders.stream().filter(provider -> !this.providers.contains(provider)).collect(Collectors.toList()));
    }

    public DataPermissionHandler createHandler(DataQueryContext context) {
        String dataSourceType = context.getDataSourceType();
        for (DataPermissionHandlerProvider provider : this.providers) {
            if (!provider.supports(dataSourceType)) continue;
            return provider.createHandler();
        }
        throw new UnsupportedOperationException("Unsupported data source type: " + dataSourceType);
    }
}

