/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.common.sdk.service;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
import cn.spatiotemporal.web.core.domain.entity.admin.User;
import cn.spatiotemporal.web.core.exception.BaseBusinessException;
import com.cicv.foton.common.sdk.domain.entity.BaseModel;
import com.cicv.foton.common.sdk.domain.entity.ServiceConfig;
import com.cicv.foton.common.sdk.domain.vo.ServiceResource;
import com.cicv.foton.common.sdk.utils.AuthorityUtils;
import com.cicv.foton.common.sdk.utils.RedisDao;
import com.cicv.foton.common.sdk.utils.StrUtil;
import com.cicv.foton.common.sdk.utils.ThreadLocalUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class SdkContext {
    private static final Logger log = LoggerFactory.getLogger(SdkContext.class);
    @Resource(name="dpRedisTemplate")
    private RedisTemplate<String, Object> dpRedisTemplate;
    private static RedisTemplate<String, Object> staticDpRedisTemplate;
    @Autowired
    RedisDao redisDao;
    private static final String USER_ATTRIBUTES = "USER_ATTRIBUTES";
    private static final String LOGIN_USER_KEY = "foton:login:user:";
    @Value(value="${foton.application.name:}")
    private String appName;
    private static String applicationName;

    @PostConstruct
    public void init() {
        applicationName = this.appName;
        staticDpRedisTemplate = this.dpRedisTemplate;
    }

    public static String getApplicationName() {
        return applicationName;
    }

    public static void setSvcOrigin() {
        RequestContextHolder.getRequestAttributes().setAttribute("requestSource", (Object)SdkContext.getApplicationName(), 0);
    }

    public static void setCurrentUser(User currentUser) {
        RequestContextHolder.currentRequestAttributes().setAttribute(USER_ATTRIBUTES, (Object)currentUser, 0);
    }

    public static Object getUserAllInfo() {
        User user = SdkContext.getCurrentUser();
        if (!Objects.isNull(user) && !Objects.isNull(user.getMemberId())) {
            return staticDpRedisTemplate.opsForValue().get((Object)(LOGIN_USER_KEY + SdkContext.getCurrentUser().getMemberId()));
        }
        return null;
    }

    public static User getCurrentUser() {
        User user = null;
        try {
            String currentRequestUri = SdkContext.getCurrentRequestUri();
            user = (User)RequestContextHolder.currentRequestAttributes().getAttribute(USER_ATTRIBUTES, 0);
            if (user != null) {
                user.setUri(currentRequestUri);
                SdkContext.setCurrentUser(user);
                return user;
            }
            ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            HttpServletRequest request = requestAttributes.getRequest();
            String token = request.getHeader("X-Token");
            if (StringUtils.isNotEmpty((String)token)) {
                user = (User)AuthorityUtils.getCurrentUser4dp(token);
            }
            if (user == null) {
                throw new BaseBusinessException("400", "\u672a\u767b\u5f55\u7528\u6237!");
            }
            user.setUri(currentRequestUri);
            SdkContext.setCurrentUser(user);
        }
        catch (Exception e) {
            log.warn("\u672a\u767b\u5f55\u7528\u6237");
        }
        return user;
    }

    public static List<ServiceResource> getCurrentResource() {
        List<ServiceResource> list = new ArrayList<ServiceResource>();
        User user = SdkContext.getCurrentUser();
        if (!Objects.isNull(user) && !Objects.isNull(user.getMemberId())) {
            String key = "foton:application:resource:" + user.getMemberId();
            Object object = staticDpRedisTemplate.opsForHash().get((Object)key, (Object)SdkContext.getApplicationName());
            if (object != null) {
                list = JSONUtil.toList((JSONArray)JSONUtil.parseArray((Object)object), ServiceResource.class);
            }
        }
        return list;
    }

    public static Object getResourceByAppId(String appId) {
        User user = SdkContext.getCurrentUser();
        if (!Objects.isNull(user) && !Objects.isNull(user.getMemberId())) {
            String key = "foton:application:resource:" + user.getMemberId();
            Object object = staticDpRedisTemplate.opsForHash().get((Object)key, (Object)appId);
            return object;
        }
        return null;
    }

    public static List<ServiceConfig> getCurrentConfig(String appId) {
        List<ServiceConfig> list = new ArrayList<ServiceConfig>();
        Object object = staticDpRedisTemplate.opsForHash().get((Object)("foton:application:config:" + appId), (Object)SdkContext.getApplicationName());
        if (object != null) {
            list = JSONUtil.toList((JSONArray)JSONUtil.parseArray((Object)object), ServiceConfig.class);
        }
        return list;
    }

    public static Map<Object, Object> getCurrentDataGroupRowDataPremssion(String modelName, String dataGroupId) {
        User user = SdkContext.getCurrentUser();
        if (!Objects.isNull(user)) {
            return SdkContext.getDataPremssion(modelName, "foton:application:datapermission:datagroup:", dataGroupId, "row");
        }
        return new HashMap<Object, Object>();
    }

    public static Map<Object, Object> getCurrentOrgRowDataPremssion(String modelName) {
        User user = SdkContext.getCurrentUser();
        if (!Objects.isNull(user)) {
            return SdkContext.getDataPremssion(modelName, "foton:application:datapermission:orgId:", String.valueOf(user.getOrgId()), "row");
        }
        return new HashMap<Object, Object>();
    }

    public static Map<Object, Object> getCurrentDataGroupColDataPremssion(String modelName, String dataGroupId) {
        User user = SdkContext.getCurrentUser();
        if (!Objects.isNull(user)) {
            return SdkContext.getDataPremssion(modelName, "foton:application:datapermission:datagroup:", dataGroupId, "col");
        }
        return new HashMap<Object, Object>();
    }

    public static Map<Object, Object> getCurrentOrgColDataPremssion(String modelName) {
        User user = SdkContext.getCurrentUser();
        if (!Objects.isNull(user)) {
            return SdkContext.getDataPremssion(modelName, "foton:application:datapermission:orgId:", String.valueOf(user.getOrgId()), "col");
        }
        return new HashMap<Object, Object>();
    }

    private static Map<Object, Object> getDataPremssion(String modelName, String method, String dataGroupId, String type) {
        Map<Object, Object> map = new HashMap<Object, Object>();
        BaseModel tables = ThreadLocalUtil.getTables();
        if (StringUtils.isNotBlank((String)modelName)) {
            String key = StrUtil.concatStr(method, SdkContext.getApplicationName(), modelName, String.valueOf(dataGroupId), type);
            map = staticDpRedisTemplate.opsForHash().entries((Object)key);
            if (Objects.isNull(map)) {
                map = new HashMap();
            }
        }
        return map;
    }

    public static String getRequestSource() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null) {
            return StrUtil.nvl(requestAttributes.getAttribute("requestSource", 0));
        }
        return null;
    }

    public static String getCurrentRequestUri() {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (attributes != null) {
            HttpServletRequest request = attributes.getRequest();
            StringBuffer url = new StringBuffer(request.getRequestURI());
            if (request.getQueryString() != null) {
                url.append('?').append(request.getQueryString());
            }
            return url.toString();
        }
        return null;
    }
}

