/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.common.sdk.log.keying;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.spi.ContextAwareBase;
import com.cicv.foton.common.sdk.log.keying.KeyingStrategy;
import java.nio.ByteBuffer;

public class ContextNameKeyingStrategy
extends ContextAwareBase
implements KeyingStrategy<ILoggingEvent> {
    private byte[] contextNameHash = null;

    public void setContext(Context context) {
        super.setContext(context);
        String hostname = context.getProperty("CONTEXT_NAME");
        if (hostname == null) {
            this.addError("Hostname could not be found in context. HostNamePartitioningStrategy will not work.");
        } else {
            this.contextNameHash = ByteBuffer.allocate(4).putInt(hostname.hashCode()).array();
        }
    }

    @Override
    public byte[] createKey(ILoggingEvent e) {
        return this.contextNameHash;
    }
}

