/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.common.sdk.log;

import com.cicv.foton.common.sdk.log.FotonLoggerFactory;
import com.cicv.foton.common.sdk.log.LoggerUtil;
import java.io.ObjectStreamException;
import java.io.Serializable;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.event.Level;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public final class Logger
implements org.slf4j.Logger,
Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private LoggerUtil loggerUtil;

    public Logger(String name) {
        this.name = name;
        this.loggerUtil = new LoggerUtil();
    }

    public String getName() {
        return this.name;
    }

    protected Object readResolve() throws ObjectStreamException {
        return LoggerFactory.getLogger((String)this.getName());
    }

    public boolean isTraceEnabled() {
        return FotonLoggerFactory.INSTANCE.getLevel().ordinal() >= Level.TRACE.ordinal();
    }

    public void trace(String msg) {
        if (this.isTraceEnabled()) {
            this.sendLog(Level.TRACE, msg);
        }
    }

    public void trace(String format, Object arg) {
        if (this.isTraceEnabled()) {
            this.asyncLog(Level.TRACE, format, arg);
        }
    }

    public void trace(String format, Object arg1, Object arg2) {
        if (this.isTraceEnabled()) {
            this.asyncLog(Level.TRACE, format, arg1, arg2);
        }
    }

    public void trace(String format, Object ... arguments) {
        if (this.isTraceEnabled()) {
            this.asyncLog(Level.TRACE, format, arguments);
        }
    }

    public void trace(String msg, Throwable t) {
        if (this.isTraceEnabled()) {
            this.asyncLog(Level.TRACE, msg, t);
        }
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.isTraceEnabled();
    }

    public void trace(Marker marker, String msg) {
        this.trace(msg);
    }

    public void trace(Marker marker, String format, Object arg) {
        this.trace(format, arg);
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        this.trace(format, arg1, arg2);
    }

    public void trace(Marker marker, String format, Object ... argArray) {
        this.trace(format, argArray);
    }

    public void trace(Marker marker, String msg, Throwable t) {
        this.trace(msg, t);
    }

    public boolean isDebugEnabled() {
        return FotonLoggerFactory.INSTANCE.getLevel().ordinal() >= Level.DEBUG.ordinal();
    }

    public void debug(String msg) {
        if (this.isDebugEnabled()) {
            this.sendLog(Level.DEBUG, msg);
        }
    }

    public void debug(String format, Object arg) {
        if (this.isDebugEnabled()) {
            this.asyncLog(Level.DEBUG, format, arg);
        }
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            this.asyncLog(Level.DEBUG, format, arg1, arg2);
        }
    }

    public void debug(String format, Object ... arguments) {
        if (this.isDebugEnabled()) {
            this.asyncLog(Level.DEBUG, format, arguments);
        }
    }

    public void debug(String msg, Throwable t) {
        if (this.isDebugEnabled()) {
            this.asyncLog(Level.DEBUG, msg, t);
        }
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.isDebugEnabled();
    }

    public void debug(Marker marker, String msg) {
        this.debug(msg);
    }

    public void debug(Marker marker, String format, Object arg) {
        this.debug(format, arg);
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        this.debug(format, arg1, arg2);
    }

    public void debug(Marker marker, String format, Object ... arguments) {
        this.debug(format, arguments);
    }

    public void debug(Marker marker, String msg, Throwable t) {
        this.debug(msg, t);
    }

    public boolean isInfoEnabled() {
        return FotonLoggerFactory.INSTANCE.getLevel().ordinal() >= Level.INFO.ordinal();
    }

    public void info(String msg) {
        if (this.isInfoEnabled()) {
            this.sendLog(Level.INFO, msg);
        }
    }

    public void info(String format, Object arg) {
        if (this.isInfoEnabled()) {
            this.asyncLog(Level.INFO, format, arg);
        }
    }

    public void info(String format, Object arg1, Object arg2) {
        if (this.isInfoEnabled()) {
            this.asyncLog(Level.INFO, format, arg1, arg2);
        }
    }

    public void info(String format, Object ... arguments) {
        if (this.isInfoEnabled()) {
            this.asyncLog(Level.INFO, format, arguments);
        }
    }

    public void info(String msg, Throwable t) {
        if (this.isInfoEnabled()) {
            this.asyncLog(Level.INFO, msg, t);
        }
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.isInfoEnabled();
    }

    public void info(Marker marker, String msg) {
        this.info(msg);
    }

    public void info(Marker marker, String format, Object arg) {
        this.info(format, arg);
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        this.info(format, arg1, arg2);
    }

    public void info(Marker marker, String format, Object ... arguments) {
        this.info(format, arguments);
    }

    public void info(Marker marker, String msg, Throwable t) {
        this.info(msg, t);
    }

    public boolean isWarnEnabled() {
        return FotonLoggerFactory.INSTANCE.getLevel().ordinal() >= Level.WARN.ordinal();
    }

    public void warn(String msg) {
        if (this.isWarnEnabled()) {
            this.sendLog(Level.WARN, msg);
        }
    }

    public void warn(String format, Object arg) {
        if (this.isWarnEnabled()) {
            this.asyncLog(Level.WARN, format, arg);
        }
    }

    public void warn(String format, Object ... arguments) {
        if (this.isWarnEnabled()) {
            this.asyncLog(Level.WARN, format, arguments);
        }
    }

    public void warn(String format, Object arg1, Object arg2) {
        if (this.isWarnEnabled()) {
            this.asyncLog(Level.WARN, format, arg1, arg2);
        }
    }

    public void warn(String msg, Throwable t) {
        if (this.isWarnEnabled()) {
            this.asyncLog(Level.WARN, msg, t);
        }
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.isWarnEnabled();
    }

    public void warn(Marker marker, String msg) {
        this.warn(msg);
    }

    public void warn(Marker marker, String format, Object arg) {
        this.warn(format, arg);
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        this.warn(format, arg1, arg2);
    }

    public void warn(Marker marker, String format, Object ... arguments) {
        this.warn(format, arguments);
    }

    public void warn(Marker marker, String msg, Throwable t) {
        this.warn(msg, t);
    }

    public boolean isErrorEnabled() {
        return FotonLoggerFactory.INSTANCE.getLevel().ordinal() >= Level.ERROR.ordinal();
    }

    public void error(String msg) {
        if (this.isErrorEnabled()) {
            this.sendLog(Level.ERROR, msg);
        }
    }

    public void error(String format, Object arg) {
        if (this.isErrorEnabled()) {
            this.asyncLog(Level.ERROR, format, arg);
        }
    }

    public void error(String format, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            this.asyncLog(Level.ERROR, format, arg1, arg2);
        }
    }

    public void error(String format, Object ... arguments) {
        if (this.isErrorEnabled()) {
            this.asyncLog(Level.ERROR, format, arguments);
        }
    }

    public void error(String msg, Throwable t) {
        if (this.isErrorEnabled()) {
            this.asyncLog(Level.ERROR, msg, t);
        }
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.isErrorEnabled();
    }

    public void error(Marker marker, String msg) {
        this.error(msg);
    }

    public void error(Marker marker, String format, Object arg) {
        this.error(format, arg);
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        this.error(format, arg1, arg2);
    }

    public void error(Marker marker, String format, Object ... arguments) {
        this.error(format, arguments);
    }

    public void error(Marker marker, String msg, Throwable t) {
        this.error(msg, t);
    }

    private void asyncLog(Level level, String format, Object arg) {
        FormattingTuple formatter = MessageFormatter.format((String)format, (Object)arg);
        this.asyncLog(level, formatter.getMessage(), formatter.getThrowable());
    }

    private void asyncLog(Level level, String format, Object arg1, Object arg2) {
        FormattingTuple formatter = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
        this.asyncLog(level, formatter.getMessage(), formatter.getThrowable());
    }

    private void asyncLog(Level level, String format, Object[] args) {
        FormattingTuple formatter = MessageFormatter.arrayFormat((String)format, (Object[])args);
        this.asyncLog(level, formatter.getMessage(), formatter.getThrowable());
    }

    private void asyncLog(Level level, String msg, Throwable err) {
        StringBuilder msgBuilder = new StringBuilder();
        if (msg != null) {
            msgBuilder.append(msg).append("\n");
        }
        if (err != null) {
            msgBuilder.append(err.toString());
            StackTraceElement[] stackTraceElementArray = err.getStackTrace();
            int n = stackTraceElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement stackTrace = stackTraceElementArray[n2];
                msgBuilder.append(stackTrace).append("\n");
                ++n2;
            }
        }
        msgBuilder.setLength(msgBuilder.length() - 1);
        this.sendLog(level, msgBuilder.toString());
    }

    private void sendLog(Level level, String msg) {
        this.loggerUtil.send(level, this.name, msg);
    }
}

