/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.common.sdk.intercept;

import cn.spatiotemporal.web.core.domain.entity.admin.User;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import com.cicv.foton.common.sdk.domain.entity.ServiceConfig;
import com.cicv.foton.common.sdk.service.SdkContext;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.NullValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

public class TenantLineHandlerInterceptor
implements TenantLineHandler {
    private static final Logger log = LoggerFactory.getLogger(TenantLineHandlerInterceptor.class);
    private List<String> ignoreTableNames;
    private RedisTemplate<String, Object> dpRedisTemplate;
    private String appName;

    public TenantLineHandlerInterceptor(List<String> ignoreTableNames, RedisTemplate<String, Object> dpRedisTemplate, String appName) {
        this.ignoreTableNames = ignoreTableNames;
        this.dpRedisTemplate = dpRedisTemplate;
        this.appName = appName;
    }

    public boolean ignoreTable(String tableName) {
        return this.ignoreTableNames.contains(tableName);
    }

    public String getTenantIdColumn() {
        return "tenant_id";
    }

    public Expression getTenantId() {
        try {
            User currentUser = SdkContext.getCurrentUser();
            if (currentUser == null || currentUser.getTenantId() == null) {
                return new NullValue();
            }
            if (this.isQueryAll(currentUser.getMemberId())) {
                return new NullValue();
            }
            return new LongValue(currentUser.getTenantId().longValue());
        }
        catch (Exception e) {
            throw new RuntimeException("\u83b7\u53d6\u79df\u6237\u4fe1\u606f\u51fa\u73b0\u9519\u8bef\uff01", e);
        }
    }

    private boolean isQueryAll(Long memberId) {
        List list;
        block12: {
            Object config;
            block11: {
                Map entries;
                block10: {
                    Object appId;
                    block9: {
                        block8: {
                            if (!Objects.isNull(memberId)) break block8;
                            return false;
                        }
                        appId = this.dpRedisTemplate.opsForValue().get((Object)("foton:application:currentappid:" + memberId));
                        if (!Objects.isNull(appId)) break block9;
                        return false;
                    }
                    entries = this.dpRedisTemplate.opsForHash().entries((Object)("foton:application:config:" + appId));
                    if (!Objects.isNull(entries) && !entries.isEmpty()) break block10;
                    return false;
                }
                config = entries.get(this.appName);
                if (!Objects.isNull(config)) break block11;
                return false;
            }
            list = JSON.parseArray((String)config.toString(), ServiceConfig.class);
            list = list.stream().filter(m -> Objects.equals("visible", m.getCfgType())).collect(Collectors.toList());
            if (!Objects.isNull(list) && !list.isEmpty()) break block12;
            return false;
        }
        try {
            if (Objects.equals("1", ((ServiceConfig)list.get(0)).getValue())) {
                return true;
            }
        }
        catch (Exception e) {
            log.info("\u6821\u9a8c\u662f\u5426\u53ef\u770b\u5168\u90e8\u662f\u6570\u636e\u5f02\u5e38");
        }
        return false;
    }
}

