/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.common.sdk.log.keying;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.LifeCycle;
import com.cicv.foton.common.sdk.log.keying.KeyingStrategy;
import java.nio.ByteBuffer;

public class HostNameKeyingStrategy
extends ContextAwareBase
implements KeyingStrategy<Object>,
LifeCycle {
    private byte[] hostnameHash = null;
    private boolean errorWasShown = false;

    public void setContext(Context context) {
        super.setContext(context);
        String hostname = context.getProperty("HOSTNAME");
        if (hostname == null) {
            if (!this.errorWasShown) {
                this.addError("Hostname could not be found in context. HostNamePartitioningStrategy will not work.");
                this.errorWasShown = true;
            }
        } else {
            this.hostnameHash = ByteBuffer.allocate(4).putInt(hostname.hashCode()).array();
        }
    }

    @Override
    public byte[] createKey(Object e) {
        return this.hostnameHash;
    }

    public void start() {
    }

    public void stop() {
        this.errorWasShown = false;
    }

    public boolean isStarted() {
        return true;
    }
}

