/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.common.sdk.config.mybatis;

import cn.spatiotemporal.web.core.domain.entity.admin.User;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.cicv.foton.common.sdk.service.SdkContext;
import com.cicv.foton.common.sdk.utils.AuthorityUtils;
import java.util.Date;
import java.util.Objects;
import org.apache.ibatis.reflection.MetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Component;

@Component
public class AutoFillEntityHandler
implements MetaObjectHandler {
    private static final Logger log = LoggerFactory.getLogger(AutoFillEntityHandler.class);

    public void insertFill(MetaObject metaObject) {
        User currentUser = SdkContext.getCurrentUser();
        if (currentUser != null) {
            String memberId = Objects.isNull(currentUser.getMemberId()) ? null : String.valueOf(currentUser.getMemberId());
            log.debug("start insert-filling entity... current user is [%s]", (Object)memberId);
            this.fillFieldIfNull("createUser", memberId, metaObject);
            this.fillFieldIfNull("createTime", new Date(), metaObject);
            this.fillFieldIfNull("updateUser", memberId, metaObject);
            this.fillFieldIfNull("updateTime", new Date(), metaObject);
            this.fillFieldIfNull("tenantId", currentUser.getTenantId(), metaObject);
        } else {
            log.debug("start insert-filling entity... current user is null");
            this.fillFieldIfNull("createTime", new Date(), metaObject);
            this.fillFieldIfNull("updateTime", new Date(), metaObject);
        }
    }

    public void updateFill(MetaObject metaObject) {
        UserDetails user = AuthorityUtils.getCurrentUser();
        if (user != null) {
            this.setFieldValByName("updateUser", user.getUsername(), metaObject);
            this.setFieldValByName("updateTime", new Date(), metaObject);
        } else {
            this.setFieldValByName("updateTime", new Date(), metaObject);
        }
    }

    private void fillFieldIfNull(String fieldName, Object value, MetaObject metaObject) {
        if (this.getFieldValByName(fieldName, metaObject) == null) {
            this.setFieldValByName(fieldName, value, metaObject);
        }
    }
}

