/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.common.sdk.log;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public class LoggingEvent {
    private static final DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss:SSS");
    public String timestamp;
    private String level;
    private String threadName;
    private long threadId;
    private String loggerName;
    private Object message;

    public LoggingEvent(String level, String loggerName, Object message) {
        this.level = level;
        this.message = message;
        this.loggerName = loggerName;
        this.timestamp = LocalDateTime.now().format(dtf);
        Thread ct = Thread.currentThread();
        this.threadId = ct.getId();
        this.threadName = ct.getName();
    }

    public String toString() {
        return "LoggingEvent{timestamp=" + this.timestamp + ", level=" + this.level + ", message=" + this.message + ", threadName='" + this.threadName + "', threadId=" + this.threadId + ", loggerName='" + this.loggerName + "'}";
    }

    public String toLog() {
        FormattingTuple formatter = MessageFormatter.arrayFormat((String)"{} |-{} [{}-{}] {} -| {}", (Object[])new Object[]{this.timestamp, this.level, this.threadName, this.threadId, this.loggerName, this.message});
        return formatter.getMessage();
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getLevel() {
        return this.level;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public Object getMessage() {
        return this.message;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    public void setThreadId(long threadId) {
        this.threadId = threadId;
    }

    public void setLoggerName(String loggerName) {
        this.loggerName = loggerName;
    }

    public void setMessage(Object message) {
        this.message = message;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoggingEvent)) {
            return false;
        }
        LoggingEvent other = (LoggingEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getThreadId() != other.getThreadId()) {
            return false;
        }
        String this$timestamp = this.getTimestamp();
        String other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp)) {
            return false;
        }
        String this$level = this.getLevel();
        String other$level = other.getLevel();
        if (this$level == null ? other$level != null : !this$level.equals(other$level)) {
            return false;
        }
        String this$threadName = this.getThreadName();
        String other$threadName = other.getThreadName();
        if (this$threadName == null ? other$threadName != null : !this$threadName.equals(other$threadName)) {
            return false;
        }
        String this$loggerName = this.getLoggerName();
        String other$loggerName = other.getLoggerName();
        if (this$loggerName == null ? other$loggerName != null : !this$loggerName.equals(other$loggerName)) {
            return false;
        }
        Object this$message = this.getMessage();
        Object other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LoggingEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $threadId = this.getThreadId();
        result = result * 59 + (int)($threadId >>> 32 ^ $threadId);
        String $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : $timestamp.hashCode());
        String $level = this.getLevel();
        result = result * 59 + ($level == null ? 43 : $level.hashCode());
        String $threadName = this.getThreadName();
        result = result * 59 + ($threadName == null ? 43 : $threadName.hashCode());
        String $loggerName = this.getLoggerName();
        result = result * 59 + ($loggerName == null ? 43 : $loggerName.hashCode());
        Object $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }
}

