/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.common.sdk.utils;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Resource;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public final class RedisDao {
    @Resource
    private RedisTemplate redisTemplate;

    public RedisTemplate template() {
        return this.redisTemplate;
    }

    public boolean testConn() {
        RedisConnectionFactory connectionFactory = null;
        try {
            connectionFactory = this.redisTemplate.getConnectionFactory();
            connectionFactory.getConnection().ping();
            return true;
        }
        catch (Exception e) {
            try {
                connectionFactory.getClusterConnection().ping();
                return true;
            }
            catch (Exception e2) {
                return false;
            }
        }
    }

    public Set<String> keys(String keys) {
        try {
            return this.redisTemplate.keys((Object)keys);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean expire(String key, long time) {
        try {
            if (time > 0L) {
                this.redisTemplate.expire((Object)key, time, TimeUnit.SECONDS);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean expireAt(String key, Date time) {
        try {
            this.redisTemplate.expireAt((Object)key, time);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public long getExpire(String key) {
        return this.redisTemplate.getExpire((Object)key, TimeUnit.SECONDS);
    }

    public boolean hasKey(String key) {
        try {
            return this.redisTemplate.hasKey((Object)key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void del(String ... key) {
        if (key != null && key.length > 0) {
            if (key.length == 1) {
                this.redisTemplate.delete((Object)key[0]);
            } else {
                this.redisTemplate.delete((Collection)CollectionUtils.arrayToList((Object)key));
            }
        }
    }

    @Deprecated
    public Object get(String key) {
        return key == null ? null : this.redisTemplate.opsForValue().get((Object)key);
    }

    public String getString(String key) {
        return key == null ? null : (String)this.redisTemplate.opsForValue().get((Object)key);
    }

    public <T> T getBean(String key, Class<T> clazz) {
        JSONObject obj = (JSONObject)this.redisTemplate.opsForValue().get((Object)key);
        return (T)(obj == null ? null : obj.toJavaObject(clazz));
    }

    public boolean put(String key, Object value) {
        try {
            this.redisTemplate.opsForValue().set((Object)key, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean put(String key, Object value, long time) {
        try {
            if (time > 0L) {
                this.redisTemplate.opsForValue().set((Object)key, value, time, TimeUnit.SECONDS);
            } else {
                this.put(key, value);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public long incr(String key, long delta) {
        if (delta < 0L) {
            throw new RuntimeException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return this.redisTemplate.opsForValue().increment((Object)key, delta);
    }

    public long decr(String key, long delta) {
        if (delta < 0L) {
            throw new RuntimeException("\u9012\u51cf\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return this.redisTemplate.opsForValue().increment((Object)key, -delta);
    }

    public Object getHashValue(String key, String item) {
        return key == null || item == null ? null : this.redisTemplate.opsForHash().get((Object)key, (Object)item);
    }

    public String getHashString(String key, String item) {
        return key == null || item == null ? null : (String)this.redisTemplate.opsForHash().get((Object)key, (Object)item);
    }

    public <T> T getHashBean(String key, String item, Class<T> clazz) {
        JSONObject obj = (JSONObject)this.redisTemplate.opsForHash().get((Object)key, (Object)item);
        return (T)(obj == null ? null : obj.toJavaObject(clazz));
    }

    public Map getHashMap(String key) {
        return key == null ? null : this.redisTemplate.opsForHash().entries((Object)key);
    }

    public <T> Map<String, T> getHashMap(String key, Class<T> clazz) {
        Map map = this.getHashMap(key);
        if (map != null && !map.isEmpty()) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (Object k : map.keySet()) {
                JSONObject jsonObject = (JSONObject)map.get(k);
                hashMap.put(String.valueOf(k), jsonObject.toJavaObject(clazz));
            }
            return hashMap;
        }
        return null;
    }

    public boolean putHashMap(String key, Map map) {
        try {
            this.redisTemplate.opsForHash().putAll((Object)key, map);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean putHashMap(String key, Map map, long time) {
        try {
            this.redisTemplate.opsForHash().putAll((Object)key, map);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean putHashValue(String key, String item, Object value) {
        try {
            this.redisTemplate.opsForHash().put((Object)key, (Object)item, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean putHashValue(String key, String item, Object value, long time) {
        try {
            this.redisTemplate.opsForHash().put((Object)key, (Object)item, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void delHashItem(String key, Object ... item) {
        this.redisTemplate.opsForHash().delete((Object)key, item);
    }

    public boolean hasHashItem(String key, String item) {
        return this.redisTemplate.opsForHash().hasKey((Object)key, (Object)item);
    }

    public double incrHash(String key, String item, double by) {
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)item, by);
    }

    public double decrHash(String key, String item, double by) {
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)item, -by);
    }

    public Set getSet(String key) {
        try {
            return this.redisTemplate.opsForSet().members((Object)key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean hasSetValue(String key, Object value) {
        try {
            return this.redisTemplate.opsForSet().isMember((Object)key, value);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public Object popSetValue(String key) {
        try {
            return this.redisTemplate.opsForSet().pop((Object)key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String popSetString(String key) {
        try {
            return (String)this.redisTemplate.opsForSet().pop((Object)key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public <T> T popSetBean(String key, Class<T> clazz) {
        try {
            JSONObject obj = (JSONObject)this.redisTemplate.opsForSet().pop((Object)key);
            return (T)(obj == null ? null : obj.toJavaObject(clazz));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public long addSetValue(String key, Object ... values) {
        try {
            return this.redisTemplate.opsForSet().add((Object)key, values);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public long addSetValue(String key, long time, Object ... values) {
        try {
            Long count = this.redisTemplate.opsForSet().add((Object)key, values);
            if (time > 0L) {
                this.expire(key, time);
            }
            return count;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public long getSetSize(String key) {
        try {
            return this.redisTemplate.opsForSet().size((Object)key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public long delSetValue(String key, Object ... values) {
        try {
            Long count = this.redisTemplate.opsForSet().remove((Object)key, values);
            return count;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public List getListAll(String key) {
        return this.getList(key, 0L, -1L);
    }

    public <T> List<T> getListAll(String key, Class<T> clazz) {
        return this.getList(key, 0L, -1L, clazz);
    }

    public List getList(String key, long start, long end) {
        try {
            return this.redisTemplate.opsForList().range((Object)key, start, end);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public <T> List<T> getList(String key, long start, long end, Class<T> clazz) {
        try {
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object obj : this.redisTemplate.opsForList().range((Object)key, start, end)) {
                list.add(((JSONObject)obj).toJavaObject(clazz));
            }
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public long getListSize(String key) {
        try {
            return this.redisTemplate.opsForList().size((Object)key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public Object getListValue(String key, long index) {
        try {
            return this.redisTemplate.opsForList().index((Object)key, index);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getListString(String key, long index) {
        try {
            return (String)this.redisTemplate.opsForList().index((Object)key, index);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public <T> T getListBean(String key, long index, Class<T> clazz) {
        try {
            JSONObject obj = (JSONObject)this.redisTemplate.opsForList().index((Object)key, index);
            return (T)(obj == null ? null : obj.toJavaObject(clazz));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Deprecated
    public boolean pushListValue(String key, Object value) {
        return this.rightPushValue(key, value);
    }

    @Deprecated
    public boolean pushListValue(String key, Object value, long time) {
        return this.rightPushValue(key, value, time);
    }

    public boolean rightPushValue(String key, Object value) {
        try {
            this.redisTemplate.opsForList().rightPush((Object)key, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean rightPushValue(String key, Object value, long time) {
        try {
            this.redisTemplate.opsForList().rightPush((Object)key, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean leftPushValue(String key, Object value) {
        try {
            this.redisTemplate.opsForList().leftPush((Object)key, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean leftPushValue(String key, Object value, long time) {
        try {
            this.redisTemplate.opsForList().leftPush((Object)key, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean putList(String key, List value) {
        try {
            this.redisTemplate.opsForList().rightPushAll((Object)key, (Collection)value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean putList(String key, List value, long time) {
        try {
            this.redisTemplate.opsForList().rightPushAll((Object)key, (Collection)value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean updateListValue(String key, long index, Object value) {
        try {
            this.redisTemplate.opsForList().set((Object)key, index, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public Object leftPopValue(String key) {
        try {
            return this.redisTemplate.opsForList().leftPop((Object)key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public <T> T leftPopBean(String key, Class<T> clazz) {
        try {
            JSONObject obj = (JSONObject)this.redisTemplate.opsForList().leftPop((Object)key);
            return (T)(obj == null ? null : obj.toJavaObject(clazz));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object rightPopValue(String key) {
        try {
            return this.redisTemplate.opsForList().rightPop((Object)key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public <T> T rightPopBean(String key, Class<T> clazz) {
        try {
            JSONObject obj = (JSONObject)this.redisTemplate.opsForList().rightPop((Object)key);
            return (T)(obj == null ? null : obj.toJavaObject(clazz));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public long removeListValue(String key, Object value) {
        return this.removeListValue(key, 0L, value);
    }

    public long removeListValue(String key, long count, Object value) {
        try {
            Long remove = this.redisTemplate.opsForList().remove((Object)key, count, value);
            return remove;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public void scan(String pattern, Consumer<byte[]> consumer) {
        this.redisTemplate.execute(connection -> {
            Object var4_5;
            block8: {
                Cursor cursor = connection.scan(ScanOptions.scanOptions().count(Long.MAX_VALUE).match(pattern).build());
                try {
                    cursor.forEachRemaining(consumer);
                    cursor.close();
                    var4_5 = null;
                    if (cursor == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (cursor != null) {
                            try {
                                cursor.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        throw new RuntimeException(e);
                    }
                }
                cursor.close();
            }
            return var4_5;
        });
    }
}

