/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.common.sdk.config.mybatis;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.OptimisticLockerInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.cicv.foton.common.sdk.intercept.TenantLineHandlerInterceptor;
import com.cicv.foton.common.sdk.intercept.TenantLineInnerInterceptor;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;

@Configuration
public class MybatisPlusConfig {
    @Value(value="${mybatis-plus.pagination.db-type:postgresql}")
    private String dbType;
    @Resource(name="dpRedisTemplate")
    private RedisTemplate<String, Object> dpRedisTemplate;
    @Value(value="${foton.application.name}")
    private String appName;
    @Value(value="${foton.data-permission.tenant-ignore-table-names}")
    private List<String> ignoreTableNames;
    @Value(value="${foton.data-permission.is-master:false}")
    private boolean isMaster;

    @Bean
    public MybatisPlusInterceptor mybatisPlusInterceptor() {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        interceptor.addInnerInterceptor((InnerInterceptor)new TenantLineInnerInterceptor(new TenantLineHandlerInterceptor(this.ignoreTableNames), this.appName, this.dpRedisTemplate, this.isMaster));
        interceptor.addInnerInterceptor((InnerInterceptor)new PaginationInnerInterceptor(DbType.getDbType((String)this.dbType)));
        interceptor.addInnerInterceptor((InnerInterceptor)new OptimisticLockerInnerInterceptor());
        return interceptor;
    }
}

