/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.common.sdk.intercept;

import cn.hutool.core.util.IdUtil;
import com.cicv.foton.common.sdk.utils.ThreadLocalUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Component
public class LogInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(LogInterceptor.class);
    private static final String REQUEST_ID = "requestId";

    public boolean preHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o) throws Exception {
        String xForwardedForHeader = httpServletRequest.getHeader("X-Forwarded-For");
        String remoteIp = httpServletRequest.getRemoteAddr();
        String uuid = IdUtil.objectId();
        log.debug("put requestId ({}) to logger", (Object)uuid);
        log.debug("request id:{}, client ip:{}, X-Forwarded-For:{}", new Object[]{uuid, remoteIp, xForwardedForHeader});
        MDC.put((String)REQUEST_ID, (String)uuid);
        MDC.put((String)"remoteIp", (String)remoteIp);
        return true;
    }

    public void postHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, Exception e) throws Exception {
        MDC.remove((String)REQUEST_ID);
        ThreadLocalUtil.getInstance().clear();
    }
}

