/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.common.sdk.utils;

import cn.spatiotemporal.web.core.utils.DateUtils;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Date;
import java.util.Map;

public class JwtTokenUtils {
    private static InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("jwt-token.jks");
    private static PrivateKey privateKey = null;
    private static PublicKey publicKey = null;
    private static String salt = null;

    public static String generateToken(String subject, int expirationSeconds, Map<String, Object> claims) {
        JwtBuilder builder = Jwts.builder().setClaims(claims).setSubject(subject).setExpiration(new Date(System.currentTimeMillis() + (long)(expirationSeconds * 1000)));
        return salt == null ? builder.signWith(SignatureAlgorithm.RS256, (Key)privateKey).compact() : builder.signWith(SignatureAlgorithm.HS512, salt).compact();
    }

    public static String generateToken(String subject, Map<String, Object> claims) {
        JwtBuilder builder = Jwts.builder().setClaims(claims).setSubject(subject).setExpiration(DateUtils.parse((String)"4999-12-31", (DateUtils.DateFormatter)DateUtils.DateFormatter.DATE_FORMATTER));
        return salt == null ? builder.signWith(SignatureAlgorithm.RS256, (Key)privateKey).compact() : builder.signWith(SignatureAlgorithm.HS512, salt).compact();
    }

    public static String parseToken(String token) {
        String subject = null;
        try {
            subject = JwtTokenUtils.getTokenBody(token).getSubject();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return subject;
    }

    public static Map<String, Object> getClaims(String token) {
        Claims claims = null;
        try {
            claims = JwtTokenUtils.getTokenBody(token);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return claims;
    }

    public static boolean isExpiration(String token) {
        return JwtTokenUtils.getTokenBody(token).getExpiration().before(new Date());
    }

    private static Claims getTokenBody(String token) {
        JwtParser parser = salt == null ? Jwts.parser().setSigningKey((Key)publicKey) : Jwts.parser().setSigningKey(salt);
        return (Claims)parser.parseClaimsJws(token).getBody();
    }

    public static void main(String[] args) {
        String token = "eyJhbGciOiJIUzUxMiJ9.eyJzdWIiOiJhZG1pbiIsImV4cCI6OTU2MTc0Njg4MDAsInVzZXJJZCI6MSwidXNlcm5hbWUiOiJhZG1pbiJ9.J0DdyR8JuQSq5A9KKl1M8wQZY5qPWZJfP7AHHmdHqFMmdMD-CjNgW4vGHp4ch67AHxdKUT3lgddRgwproZ1oXw";
        Map<String, Object> claims = JwtTokenUtils.getClaims(token);
        System.out.println(JwtTokenUtils.parseToken(token));
    }

    static {
        try {
            if (inputStream != null) {
                KeyStore keyStore = KeyStore.getInstance("JKS");
                keyStore.load(inputStream, "123456".toCharArray());
                privateKey = (PrivateKey)keyStore.getKey("jwt", "123456".toCharArray());
                publicKey = keyStore.getCertificate("jwt").getPublicKey();
            } else {
                salt = "inzyme";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

