/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.common.sdk.log;

import com.cicv.foton.common.sdk.log.Logger;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.ILoggerFactory;
import org.slf4j.event.Level;

public enum FotonLoggerFactory implements ILoggerFactory
{
    INSTANCE;

    ConcurrentMap<String, Logger> loggerMap;
    private volatile Level level = Level.INFO;

    private FotonLoggerFactory() {
        this.loggerMap = new ConcurrentHashMap<String, Logger>();
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public Level getLevel() {
        return this.level;
    }

    public Logger getLogger(String name) {
        Logger logger = (Logger)this.loggerMap.get(name);
        if (logger != null) {
            return logger;
        }
        Logger newInstance = new Logger(name);
        Logger oldInstance = this.loggerMap.putIfAbsent(name, newInstance);
        return oldInstance == null ? newInstance : oldInstance;
    }

    void reset() {
        this.loggerMap.clear();
    }
}

