/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.common.sdk.intercept;

import cn.spatiotemporal.web.core.domain.entity.admin.User;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.plugins.InterceptorIgnoreHelper;
import com.baomidou.mybatisplus.core.toolkit.ClassUtils;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.extension.parser.JsqlParserSupport;
import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.toolkit.PropertyMapper;
import com.cicv.foton.common.sdk.domain.entity.BaseModel;
import com.cicv.foton.common.sdk.domain.entity.SelectEntry;
import com.cicv.foton.common.sdk.domain.entity.TableEntry;
import com.cicv.foton.common.sdk.service.SdkContext;
import com.cicv.foton.common.sdk.utils.StrUtil;
import com.cicv.foton.common.sdk.utils.ThreadLocalUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.HexValue;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.NotExpression;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExistsExpression;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.MultiExpressionList;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.LateralSubSelect;
import net.sf.jsqlparser.statement.select.ParenthesisFromItem;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubJoin;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.ValuesList;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.statement.update.Update;
import org.apache.commons.lang.StringUtils;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

public class TenantLineInnerInterceptor
extends JsqlParserSupport
implements InnerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(TenantLineInnerInterceptor.class);
    private TenantLineHandler tenantLineHandler;
    private List<String> ignoreTableNames;
    private RedisTemplate<String, Object> dpRedisTemplate;
    private String appName;
    private boolean isMaster;

    public TenantLineInnerInterceptor(TenantLineHandler tenantLineHandler, String appName, RedisTemplate<String, Object> dpRedisTemplate, boolean isMaster) {
        this.tenantLineHandler = tenantLineHandler;
        this.dpRedisTemplate = dpRedisTemplate;
        this.appName = appName;
        this.isMaster = isMaster;
    }

    public void beforeQuery(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) throws SQLException {
        if (InterceptorIgnoreHelper.willIgnoreTenantLine((String)ms.getId())) {
            return;
        }
        PluginUtils.MPBoundSql mpBs = PluginUtils.mpBoundSql((BoundSql)boundSql);
        mpBs.sql(this.parserSingle(mpBs.sql(), null));
    }

    public void beforePrepare(StatementHandler sh, Connection connection, Integer transactionTimeout) {
        PluginUtils.MPStatementHandler mpSh = PluginUtils.mpStatementHandler((StatementHandler)sh);
        MappedStatement ms = mpSh.mappedStatement();
        SqlCommandType sct = ms.getSqlCommandType();
        if (sct == SqlCommandType.INSERT || sct == SqlCommandType.UPDATE || sct == SqlCommandType.DELETE) {
            if (InterceptorIgnoreHelper.willIgnoreTenantLine((String)ms.getId())) {
                return;
            }
            PluginUtils.MPBoundSql mpBs = mpSh.mPBoundSql();
            mpBs.sql(this.parserMulti(mpBs.sql(), null));
        }
    }

    protected void processSelect(Select select, int index, String sql, Object obj) {
        this.processSelectBody(select.getSelectBody());
        List withItemsList = select.getWithItemsList();
        if (!CollectionUtils.isEmpty((Collection)withItemsList)) {
            withItemsList.forEach(this::processSelectBody);
        }
    }

    protected void processSelectBody(SelectBody selectBody) {
        if (selectBody == null) {
            return;
        }
        if (selectBody instanceof PlainSelect) {
            this.processPlainSelect((PlainSelect)selectBody);
        } else if (selectBody instanceof WithItem) {
            WithItem withItem = (WithItem)selectBody;
            this.processSelectBody(withItem.getSubSelect().getSelectBody());
        } else {
            SetOperationList operationList = (SetOperationList)selectBody;
            List selectBodys = operationList.getSelects();
            if (CollectionUtils.isNotEmpty((Collection)selectBodys)) {
                selectBodys.forEach(this::processSelectBody);
            }
        }
    }

    protected void processInsert(Insert insert, int index, String sql, Object obj) {
        Select select;
        if (this.tenantLineHandler.ignoreTable(insert.getTable().getName())) {
            return;
        }
        List columns = insert.getColumns();
        if (CollectionUtils.isEmpty((Collection)columns)) {
            return;
        }
        String tenantIdColumn = this.tenantLineHandler.getTenantIdColumn();
        if (this.tenantLineHandler.ignoreInsert(columns, tenantIdColumn)) {
            return;
        }
        columns.add(new Column(tenantIdColumn));
        List duplicateUpdateColumns = insert.getDuplicateUpdateExpressionList();
        if (CollectionUtils.isNotEmpty((Collection)duplicateUpdateColumns)) {
            EqualsTo equalsTo = new EqualsTo();
            equalsTo.setLeftExpression((Expression)new StringValue(tenantIdColumn));
            equalsTo.setRightExpression(this.tenantLineHandler.getTenantId());
            duplicateUpdateColumns.add(equalsTo);
        }
        if ((select = insert.getSelect()) != null) {
            this.processInsertSelect(select.getSelectBody());
        } else if (insert.getItemsList() != null) {
            ItemsList itemsList = insert.getItemsList();
            if (itemsList instanceof MultiExpressionList) {
                ((MultiExpressionList)itemsList).getExpressionLists().forEach(el -> el.getExpressions().add(this.tenantLineHandler.getTenantId()));
            } else {
                ((ExpressionList)itemsList).getExpressions().add(this.tenantLineHandler.getTenantId());
            }
        } else {
            throw ExceptionUtils.mpe((String)"Failed to process multiple-table update, please exclude the tableName or statementId", (Object[])new Object[0]);
        }
    }

    protected void processUpdate(Update update, int index, String sql, Object obj) {
        Table table = update.getTable();
        if (this.tenantLineHandler.ignoreTable(table.getName())) {
            return;
        }
        update.setWhere((Expression)this.andExpression(table, update.getWhere()));
    }

    protected void processDelete(Delete delete, int index, String sql, Object obj) {
        if (this.tenantLineHandler.ignoreTable(delete.getTable().getName())) {
            return;
        }
        delete.setWhere((Expression)this.andExpression(delete.getTable(), delete.getWhere()));
    }

    protected BinaryExpression andExpression(Table table, Expression where) {
        EqualsTo equalsTo = new EqualsTo();
        equalsTo.setLeftExpression((Expression)this.getAliasColumn(table));
        equalsTo.setRightExpression(this.tenantLineHandler.getTenantId());
        if (null != where) {
            if (where instanceof OrExpression) {
                return new AndExpression((Expression)equalsTo, (Expression)new Parenthesis(where));
            }
            return new AndExpression((Expression)equalsTo, where);
        }
        return equalsTo;
    }

    protected void processInsertSelect(SelectBody selectBody) {
        PlainSelect plainSelect = (PlainSelect)selectBody;
        FromItem fromItem = plainSelect.getFromItem();
        if (fromItem instanceof Table) {
            this.processPlainSelect(plainSelect);
            this.appendSelectItem(plainSelect.getSelectItems());
        } else if (fromItem instanceof SubSelect) {
            SubSelect subSelect = (SubSelect)fromItem;
            this.appendSelectItem(plainSelect.getSelectItems());
            this.processInsertSelect(subSelect.getSelectBody());
        }
    }

    protected void appendSelectItem(List<SelectItem> selectItems) {
        SelectItem item;
        if (CollectionUtils.isEmpty(selectItems)) {
            return;
        }
        if (selectItems.size() == 1 && ((item = selectItems.get(0)) instanceof AllColumns || item instanceof AllTableColumns)) {
            return;
        }
        selectItems.add((SelectItem)new SelectExpressionItem((Expression)new Column(this.tenantLineHandler.getTenantIdColumn())));
    }

    protected void processPlainSelect(PlainSelect plainSelect) {
        BaseModel baseModel = new BaseModel();
        ArrayList<SelectEntry> selectList = new ArrayList<SelectEntry>();
        ArrayList<TableEntry> fromList = new ArrayList<TableEntry>();
        ArrayList<TableEntry> joinList = new ArrayList<TableEntry>();
        List selectItems = plainSelect.getSelectItems();
        if (CollectionUtils.isNotEmpty((Collection)selectItems)) {
            selectItems.forEach(this::processSelectItem);
            for (SelectItem selectItem : selectItems) {
                if (selectItem instanceof SelectExpressionItem) {
                    SelectExpressionItem selectExpressionItem = (SelectExpressionItem)selectItem;
                    if (!(selectExpressionItem.getExpression() instanceof Column)) continue;
                    Column column = (Column)selectExpressionItem.getExpression();
                    SelectEntry selectEntry = new SelectEntry();
                    if (null != column.getTable()) {
                        selectEntry.setName(column.getTable().getName());
                    }
                    selectEntry.setColumnName(column.getColumnName());
                    if (null != selectExpressionItem.getAlias()) {
                        selectEntry.setColumnAliasName(selectExpressionItem.getAlias().getName());
                    } else {
                        selectEntry.setColumnAliasName(selectEntry.getColumnName());
                    }
                    selectList.add(selectEntry);
                    continue;
                }
                log.error("### \u6355\u83b7 'select *' \u8fdd\u89c4SQL:'{}'\uff0c\u9700\u4fee\u6b63\uff01", (Object)plainSelect.toString());
            }
            baseModel.setSelectItems(selectList);
        }
        Expression where = plainSelect.getWhere();
        this.processWhereSubSelect(where);
        FromItem fromItem = plainSelect.getFromItem();
        if (fromItem instanceof Table) {
            Table fromTable = (Table)fromItem;
            TableEntry tableEntry = new TableEntry();
            tableEntry.setName(fromTable.getName());
            tableEntry.setAliasName(null != fromTable.getAlias() ? fromTable.getAlias().getName() : tableEntry.getName());
            fromList.add(tableEntry);
            baseModel.setFromItems(fromList);
        }
        List<Table> list = this.processFromItem(fromItem);
        List<Table> mainTables = new ArrayList<Table>(list);
        List joins = plainSelect.getJoins();
        if (CollectionUtils.isNotEmpty((Collection)joins)) {
            mainTables = this.processJoins(mainTables, joins);
            for (Join join : joins) {
                FromItem joinItem = join.getRightItem();
                if (!(joinItem instanceof Table)) continue;
                Table tbl = (Table)joinItem;
                TableEntry tableEntry = new TableEntry();
                tableEntry.setName(tbl.getName());
                tableEntry.setAliasName(null != tbl.getAlias() ? tbl.getAlias().getName() : tableEntry.getName());
                joinList.add(tableEntry);
            }
            baseModel.setJoinItems(joinList);
        }
        if (CollectionUtils.isNotEmpty(mainTables)) {
            plainSelect.setWhere(this.builderExpression(where, mainTables));
        }
        if (CollectionUtils.isNotEmpty(baseModel.getFromItems())) {
            this.processBaseModel(baseModel);
            plainSelect.setWhere(this.builderExpression(plainSelect.getWhere(), baseModel));
        }
    }

    private BaseModel processBaseModel(BaseModel baseModel) {
        HashMap<String, String> allTables = new HashMap<String, String>();
        Map<String, String> fromaTables = baseModel.getFromItems().stream().collect(Collectors.toMap(TableEntry::getAliasName, TableEntry::getName, (value1, value2) -> value2));
        allTables.putAll(fromaTables);
        if (CollectionUtils.isNotEmpty(baseModel.getJoinItems())) {
            Map<String, String> joinTables = baseModel.getJoinItems().stream().collect(Collectors.toMap(TableEntry::getAliasName, TableEntry::getName, (value1, value2) -> value2));
            allTables.putAll(joinTables);
            for (SelectEntry select : baseModel.getSelectItems()) {
                String tmpName = select.getName();
                String tblName = (String)allTables.get(select.getName());
                if (StringUtils.isNotBlank((String)tblName)) {
                    select.setName(tblName);
                }
                select.setAliasName(tmpName);
            }
        } else {
            for (TableEntry table : baseModel.getFromItems()) {
                for (SelectEntry select : baseModel.getSelectItems()) {
                    if (StringUtils.isEmpty((String)select.getName())) {
                        select.setName(table.getName());
                    }
                    if (!StringUtils.isEmpty((String)select.getAliasName())) continue;
                    select.setAliasName(table.getAliasName());
                }
            }
        }
        baseModel.setAllTables(allTables);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tablesName", baseModel);
        ThreadLocalUtil.getInstance().setContext(map);
        return baseModel;
    }

    private List<Table> processFromItem(FromItem fromItem) {
        while (fromItem instanceof ParenthesisFromItem) {
            fromItem = ((ParenthesisFromItem)fromItem).getFromItem();
        }
        ArrayList<Table> mainTables = new ArrayList<Table>();
        if (fromItem instanceof Table) {
            Table fromTable = (Table)fromItem;
            if (!this.tenantLineHandler.ignoreTable(fromTable.getName())) {
                mainTables.add(fromTable);
            }
        } else if (fromItem instanceof SubJoin) {
            List<Table> tables = this.processSubJoin((SubJoin)fromItem);
            mainTables.addAll(tables);
        } else {
            this.processOtherFromItem(fromItem);
        }
        return mainTables;
    }

    protected void processWhereSubSelect(Expression where) {
        if (where == null) {
            return;
        }
        if (where instanceof FromItem) {
            this.processOtherFromItem((FromItem)where);
            return;
        }
        if (where.toString().indexOf("SELECT") > 0) {
            if (where instanceof BinaryExpression) {
                BinaryExpression expression = (BinaryExpression)where;
                this.processWhereSubSelect(expression.getLeftExpression());
                this.processWhereSubSelect(expression.getRightExpression());
            } else if (where instanceof InExpression) {
                InExpression expression = (InExpression)where;
                Expression inExpression = expression.getRightExpression();
                if (inExpression instanceof SubSelect) {
                    this.processSelectBody(((SubSelect)inExpression).getSelectBody());
                }
            } else if (where instanceof ExistsExpression) {
                ExistsExpression expression = (ExistsExpression)where;
                this.processWhereSubSelect(expression.getRightExpression());
            } else if (where instanceof NotExpression) {
                NotExpression expression = (NotExpression)where;
                this.processWhereSubSelect(expression.getExpression());
            } else if (where instanceof Parenthesis) {
                Parenthesis expression = (Parenthesis)where;
                this.processWhereSubSelect(expression.getExpression());
            }
        }
    }

    protected void processSelectItem(SelectItem selectItem) {
        if (selectItem instanceof SelectExpressionItem) {
            SelectExpressionItem selectExpressionItem = (SelectExpressionItem)selectItem;
            if (selectExpressionItem.getExpression() instanceof SubSelect) {
                this.processSelectBody(((SubSelect)selectExpressionItem.getExpression()).getSelectBody());
            } else if (selectExpressionItem.getExpression() instanceof Function) {
                this.processFunction((Function)selectExpressionItem.getExpression());
            }
        }
    }

    protected void processFunction(Function function) {
        ExpressionList parameters = function.getParameters();
        if (parameters != null) {
            parameters.getExpressions().forEach(expression -> {
                if (expression instanceof SubSelect) {
                    this.processSelectBody(((SubSelect)expression).getSelectBody());
                } else if (expression instanceof Function) {
                    this.processFunction((Function)expression);
                }
            });
        }
    }

    protected void processOtherFromItem(FromItem fromItem) {
        SubSelect subSelect;
        LateralSubSelect lateralSubSelect;
        while (fromItem instanceof ParenthesisFromItem) {
            fromItem = ((ParenthesisFromItem)fromItem).getFromItem();
        }
        if (fromItem instanceof SubSelect) {
            SubSelect subSelect2 = (SubSelect)fromItem;
            if (subSelect2.getSelectBody() != null) {
                this.processSelectBody(subSelect2.getSelectBody());
            }
        } else if (fromItem instanceof ValuesList) {
            this.logger.debug("Perform a subquery, if you do not give us feedback");
        } else if (fromItem instanceof LateralSubSelect && (lateralSubSelect = (LateralSubSelect)fromItem).getSubSelect() != null && (subSelect = lateralSubSelect.getSubSelect()).getSelectBody() != null) {
            this.processSelectBody(subSelect.getSelectBody());
        }
    }

    private List<Table> processSubJoin(SubJoin subJoin) {
        List<Table> mainTables = new ArrayList<Table>();
        if (subJoin.getJoinList() != null) {
            List<Table> list = this.processFromItem(subJoin.getLeft());
            mainTables.addAll(list);
            mainTables = this.processJoins(mainTables, subJoin.getJoinList());
        }
        return mainTables;
    }

    private List<Table> processJoins(List<Table> mainTables, List<Join> joins) {
        if (mainTables == null) {
            mainTables = new ArrayList<Table>();
        }
        Table mainTable = null;
        Table leftTable = null;
        if (mainTables.size() == 1) {
            leftTable = mainTable = mainTables.get(0);
        }
        LinkedList<List<Table>> onTableDeque = new LinkedList<List<Table>>();
        for (Join join : joins) {
            FromItem joinItem = join.getRightItem();
            List<Object> joinTables = null;
            if (joinItem instanceof Table) {
                joinTables = new ArrayList<Table>();
                joinTables.add((Table)joinItem);
            } else if (joinItem instanceof SubJoin) {
                joinTables = this.processSubJoin((SubJoin)joinItem);
            }
            if (joinTables != null) {
                LinkedList<Expression> onExpressions;
                Collection originOnExpressions;
                if (join.isSimple()) {
                    mainTables.addAll(joinTables);
                    continue;
                }
                Table joinTable = (Table)joinTables.get(0);
                boolean joinTableNeedIgnore = this.tenantLineHandler.ignoreTable(joinTable.getName());
                List<Table> onTables = null;
                if (join.isRight()) {
                    Table table = mainTable = joinTableNeedIgnore ? null : joinTable;
                    if (leftTable != null) {
                        onTables = Collections.singletonList(leftTable);
                    }
                } else if (join.isLeft()) {
                    if (!joinTableNeedIgnore) {
                        onTables = Collections.singletonList(joinTable);
                    }
                } else if (join.isInner()) {
                    onTables = mainTable == null ? Collections.singletonList(joinTable) : Arrays.asList(mainTable, joinTable);
                    mainTable = null;
                }
                mainTables = new ArrayList<Table>();
                if (mainTable != null) {
                    mainTables.add(mainTable);
                }
                if ((originOnExpressions = join.getOnExpressions()).size() == 1 && onTables != null) {
                    onExpressions = new LinkedList<Expression>();
                    onExpressions.add(this.builderExpression((Expression)originOnExpressions.iterator().next(), onTables));
                    join.setOnExpressions(onExpressions);
                    leftTable = joinTable;
                    continue;
                }
                onTableDeque.push(onTables);
                if (originOnExpressions.size() > 1) {
                    onExpressions = new LinkedList();
                    for (Expression originOnExpression : originOnExpressions) {
                        List currentTableList = (List)onTableDeque.poll();
                        if (CollectionUtils.isEmpty((Collection)currentTableList)) {
                            onExpressions.add(originOnExpression);
                            continue;
                        }
                        onExpressions.add(this.builderExpression(originOnExpression, currentTableList));
                    }
                    join.setOnExpressions(onExpressions);
                }
                leftTable = joinTable;
                continue;
            }
            this.processOtherFromItem(joinItem);
            leftTable = null;
        }
        return mainTables;
    }

    protected Expression builderExpression(Expression currentExpression, BaseModel baseModel) {
        log.info("\u5f53\u524d\u8868\u5bf9\u8c61\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)baseModel));
        log.info("\u5f53\u524d\u62fc\u88c5\u524dsql\u67e5\u8be2\u8bed\u53e5:{}", (Object)JSON.toJSONString((Object)currentExpression));
        if (CollectionUtils.isEmpty(baseModel.getFromItems())) {
            return currentExpression;
        }
        if (!Objects.isNull(baseModel)) {
            Map<String, String> allTablesMap = baseModel.getAllTables();
            for (Map.Entry<String, String> entry : allTablesMap.entrySet()) {
                String aliasName = entry.getKey();
                String tableName = entry.getValue();
                if (!StringUtils.isNotBlank((String)tableName)) continue;
                currentExpression = this.processDataPermission(currentExpression, aliasName, tableName);
            }
        }
        return currentExpression;
    }

    public Expression processDataPermission(Expression where, String aliasName, String tableName) {
        try {
            User user = SdkContext.getCurrentUser();
            if (!(Objects.isNull(user) || Objects.isNull(user.getTenantId()) || user.getTenantId() <= 0L || Objects.isNull(user.getOrgId()) || this.isMaster)) {
                Long orgId = user.getOrgId();
                Map<Object, Object> rwowMap = this.getRowInfo(tableName, orgId);
                if (Objects.isNull(rwowMap)) {
                    return new HexValue(" 1 = 2 ");
                }
                if (!Objects.isNull(rwowMap) && !rwowMap.isEmpty()) {
                    for (Object key : rwowMap.keySet()) {
                        Object object = rwowMap.get(key);
                        if (Objects.isNull(object)) continue;
                        Map val = (Map)object;
                        if (val.isEmpty() || Objects.isNull(val.get("oper")) || Objects.isNull(val.get("val"))) break;
                        Column column = this.getAliasColumnDym(aliasName, String.valueOf(key));
                        String oper = (String)val.get("oper");
                        Object value = val.get("val");
                        ArrayList<Object> valueList = new ArrayList<Object>();
                        switch (oper) {
                            case "contain": {
                                valueList.add(value);
                                InExpression inExpression = this.inExpression(valueList, column, false);
                                where = new AndExpression(where, (Expression)inExpression);
                                break;
                            }
                            case "uncontain": {
                                valueList.add(value);
                                InExpression notInExpression = this.inExpression(valueList, column, true);
                                where = new AndExpression(where, (Expression)notInExpression);
                                break;
                            }
                            case "gt": {
                                GreaterThan gt = new GreaterThan();
                                gt.setLeftExpression((Expression)column);
                                gt.setRightExpression((Expression)new StringValue(String.valueOf(value)));
                                where = new AndExpression(where, (Expression)gt);
                                break;
                            }
                            case "lt": {
                                MinorThan lt = new MinorThan();
                                lt.setLeftExpression((Expression)column);
                                lt.setRightExpression((Expression)new StringValue(String.valueOf(value)));
                                where = new AndExpression(where, (Expression)lt);
                                break;
                            }
                            case "ge": {
                                GreaterThanEquals ge = new GreaterThanEquals();
                                ge.setLeftExpression((Expression)column);
                                ge.setRightExpression((Expression)new StringValue(String.valueOf(value)));
                                where = new AndExpression(where, (Expression)ge);
                                break;
                            }
                            case "le": {
                                MinorThanEquals le = new MinorThanEquals();
                                le.setLeftExpression((Expression)column);
                                le.setRightExpression((Expression)new StringValue(String.valueOf(value)));
                                where = new AndExpression(where, (Expression)le);
                                break;
                            }
                            case "ne": {
                                IsNullExpression isNotNullExpression = new IsNullExpression();
                                isNotNullExpression.setLeftExpression((Expression)column);
                                isNotNullExpression.setNot(true);
                                where = new AndExpression(where, (Expression)isNotNullExpression);
                                break;
                            }
                            case "ie": {
                                IsNullExpression isNullExpression = new IsNullExpression();
                                isNullExpression.setLeftExpression((Expression)column);
                                isNullExpression.setNot(false);
                                where = new AndExpression(where, (Expression)isNullExpression);
                                break;
                            }
                        }
                    }
                }
            }
            return where;
        }
        catch (Exception e) {
            e.printStackTrace();
            return where;
        }
    }

    private Map<Object, Object> getRowInfo(String mainTableName, Long orgId) {
        String key = StrUtil.concatStr("foton:application:datapermission:orgId:", this.appName, mainTableName, String.valueOf(orgId), "row");
        Set keys = this.dpRedisTemplate.keys((Object)key);
        if (keys.isEmpty()) {
            return null;
        }
        String rowKey = (String)keys.stream().findFirst().get();
        return this.dpRedisTemplate.opsForHash().entries((Object)rowKey);
    }

    protected Column getAliasColumnDym(String aliasName, String fieldName) {
        StringBuilder column = new StringBuilder(aliasName);
        column.append(".").append(fieldName);
        return new Column(column.toString());
    }

    protected Expression builderExpression(Expression currentExpression, List<Table> tables) {
        String name = tables.get(0).getName();
        if (this.tenantLineHandler.ignoreTable(name)) {
            return currentExpression;
        }
        if (CollectionUtils.isEmpty(tables)) {
            return currentExpression;
        }
        Expression tenantId = this.tenantLineHandler.getTenantId();
        ArrayList<OrExpression> orExpressions = new ArrayList<OrExpression>();
        for (Table table : tables) {
            EqualsTo leftEqualsTo = new EqualsTo((Expression)this.getAliasColumn(table), tenantId);
            EqualsTo rightEqualsTo = new EqualsTo((Expression)this.getAliasColumn(table), (Expression)new LongValue(-1L));
            orExpressions.add(new OrExpression((Expression)leftEqualsTo, (Expression)rightEqualsTo));
        }
        Expression injectExpression = (Expression)orExpressions.get(0);
        if (orExpressions.size() > 1) {
            for (int i = 1; i < orExpressions.size(); ++i) {
                injectExpression = new AndExpression(injectExpression, (Expression)orExpressions.get(i));
            }
        }
        if (currentExpression == null) {
            return injectExpression;
        }
        if (currentExpression instanceof OrExpression) {
            return new AndExpression((Expression)new Parenthesis(currentExpression), injectExpression);
        }
        return new AndExpression(currentExpression, injectExpression);
    }

    private InExpression inExpression(List<Object> valueList, Column column, boolean not) {
        InExpression inExpression = new InExpression();
        inExpression.setLeftExpression((Expression)column);
        ExpressionList expressionList = new ExpressionList();
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        for (Object value : valueList) {
            this.addExpressions(expressions, value);
        }
        expressionList.setExpressions(expressions);
        inExpression.setRightItemsList((ItemsList)expressionList);
        inExpression.setNot(not);
        return inExpression;
    }

    private void addExpressions(List<Expression> expressions, Object value) {
        String strVal = StrUtil.nvl(value);
        if (value instanceof String) {
            expressions.add((Expression)new StringValue(strVal));
        } else if (value instanceof Integer || value instanceof Long) {
            expressions.add((Expression)new LongValue(Long.valueOf(strVal).longValue()));
        } else if (value instanceof Double) {
            expressions.add((Expression)new DoubleValue(strVal));
        }
    }

    protected Column getAliasColumn(Table table) {
        StringBuilder column = new StringBuilder();
        if (table.getAlias() != null) {
            column.append(table.getAlias().getName());
        } else {
            column.append(table.getName());
        }
        column.append(".").append(this.tenantLineHandler.getTenantIdColumn());
        return new Column(column.toString());
    }

    public void setProperties(Properties properties) {
        PropertyMapper.newInstance((Properties)properties).whenNotBlank("tenantLineHandler", ClassUtils::newInstance, this::setTenantLineHandler);
    }

    public TenantLineHandler getTenantLineHandler() {
        return this.tenantLineHandler;
    }

    public List<String> getIgnoreTableNames() {
        return this.ignoreTableNames;
    }

    public RedisTemplate<String, Object> getDpRedisTemplate() {
        return this.dpRedisTemplate;
    }

    public String getAppName() {
        return this.appName;
    }

    public boolean isMaster() {
        return this.isMaster;
    }

    public void setTenantLineHandler(TenantLineHandler tenantLineHandler) {
        this.tenantLineHandler = tenantLineHandler;
    }

    public void setIgnoreTableNames(List<String> ignoreTableNames) {
        this.ignoreTableNames = ignoreTableNames;
    }

    public void setDpRedisTemplate(RedisTemplate<String, Object> dpRedisTemplate) {
        this.dpRedisTemplate = dpRedisTemplate;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setMaster(boolean isMaster) {
        this.isMaster = isMaster;
    }

    public TenantLineInnerInterceptor() {
    }

    public TenantLineInnerInterceptor(TenantLineHandler tenantLineHandler, List<String> ignoreTableNames, RedisTemplate<String, Object> dpRedisTemplate, String appName, boolean isMaster) {
        this.tenantLineHandler = tenantLineHandler;
        this.ignoreTableNames = ignoreTableNames;
        this.dpRedisTemplate = dpRedisTemplate;
        this.appName = appName;
        this.isMaster = isMaster;
    }

    public String toString() {
        return "TenantLineInnerInterceptor(super=" + super.toString() + ", tenantLineHandler=" + this.getTenantLineHandler() + ", ignoreTableNames=" + this.getIgnoreTableNames() + ", dpRedisTemplate=" + this.getDpRedisTemplate() + ", appName=" + this.getAppName() + ", isMaster=" + this.isMaster() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TenantLineInnerInterceptor)) {
            return false;
        }
        TenantLineInnerInterceptor other = (TenantLineInnerInterceptor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isMaster() != other.isMaster()) {
            return false;
        }
        TenantLineHandler this$tenantLineHandler = this.getTenantLineHandler();
        TenantLineHandler other$tenantLineHandler = other.getTenantLineHandler();
        if (this$tenantLineHandler == null ? other$tenantLineHandler != null : !this$tenantLineHandler.equals(other$tenantLineHandler)) {
            return false;
        }
        List<String> this$ignoreTableNames = this.getIgnoreTableNames();
        List<String> other$ignoreTableNames = other.getIgnoreTableNames();
        if (this$ignoreTableNames == null ? other$ignoreTableNames != null : !((Object)this$ignoreTableNames).equals(other$ignoreTableNames)) {
            return false;
        }
        RedisTemplate<String, Object> this$dpRedisTemplate = this.getDpRedisTemplate();
        RedisTemplate<String, Object> other$dpRedisTemplate = other.getDpRedisTemplate();
        if (this$dpRedisTemplate == null ? other$dpRedisTemplate != null : !this$dpRedisTemplate.equals(other$dpRedisTemplate)) {
            return false;
        }
        String this$appName = this.getAppName();
        String other$appName = other.getAppName();
        return !(this$appName == null ? other$appName != null : !this$appName.equals(other$appName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TenantLineInnerInterceptor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isMaster() ? 79 : 97);
        TenantLineHandler $tenantLineHandler = this.getTenantLineHandler();
        result = result * 59 + ($tenantLineHandler == null ? 43 : $tenantLineHandler.hashCode());
        List<String> $ignoreTableNames = this.getIgnoreTableNames();
        result = result * 59 + ($ignoreTableNames == null ? 43 : ((Object)$ignoreTableNames).hashCode());
        RedisTemplate<String, Object> $dpRedisTemplate = this.getDpRedisTemplate();
        result = result * 59 + ($dpRedisTemplate == null ? 43 : $dpRedisTemplate.hashCode());
        String $appName = this.getAppName();
        result = result * 59 + ($appName == null ? 43 : $appName.hashCode());
        return result;
    }
}

