/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.common.sdk.service;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
import cn.spatiotemporal.web.core.domain.entity.admin.User;
import cn.spatiotemporal.web.core.exception.BaseBusinessException;
import com.cicv.foton.common.sdk.domain.entity.BaseModel;
import com.cicv.foton.common.sdk.domain.vo.ServiceConfig;
import com.cicv.foton.common.sdk.domain.vo.ServiceResource;
import com.cicv.foton.common.sdk.utils.AuthorityUtils;
import com.cicv.foton.common.sdk.utils.RedisDao;
import com.cicv.foton.common.sdk.utils.StrUtil;
import com.cicv.foton.common.sdk.utils.ThreadLocalUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class SdkContext {
    private static final Logger log = LoggerFactory.getLogger(SdkContext.class);
    @Resource(name="dpRedisTemplate")
    private RedisTemplate<String, Object> dpRedisTemplate;
    private static RedisTemplate<String, Object> staticDpRedisTemplate;
    @Autowired
    RedisDao redisDao;
    private static final String USER_ATTRIBUTES = "USER_ATTRIBUTES";
    @Value(value="${foton.application.name:}")
    private String appName;
    private static String applicationName;

    @PostConstruct
    public void init() {
        applicationName = this.appName;
        staticDpRedisTemplate = this.dpRedisTemplate;
    }

    public static String getApplicationName() {
        return applicationName;
    }

    public static void setCurrentUser(User currentUser) {
        RequestContextHolder.currentRequestAttributes().setAttribute(USER_ATTRIBUTES, (Object)currentUser, 0);
    }

    public static User getCurrentUser() {
        User user = (User)RequestContextHolder.currentRequestAttributes().getAttribute(USER_ATTRIBUTES, 0);
        try {
            if (user != null) {
                return user;
            }
            ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            HttpServletRequest request = requestAttributes.getRequest();
            String token = request.getHeader("X-Token");
            if (StringUtils.isNotEmpty((String)token)) {
                user = (User)AuthorityUtils.getCurrentUser4dp(token);
            }
            if (user == null) {
                throw new BaseBusinessException("400", "\u672a\u767b\u5f55\u7528\u6237!");
            }
            SdkContext.setCurrentUser(user);
        }
        catch (Exception e) {
            log.warn("\u7528\u6237\u672a\u767b\u5f55");
        }
        return user;
    }

    public static List<ServiceResource> getCurrentResource() {
        List<ServiceResource> list = new ArrayList<ServiceResource>();
        User user = SdkContext.getCurrentUser();
        if (!Objects.isNull(user) && !Objects.isNull(user.getMemberId())) {
            String key = "foton:application:resource:" + user.getMemberId();
            Object object = staticDpRedisTemplate.opsForHash().get((Object)key, (Object)SdkContext.getApplicationName());
            if (object != null) {
                list = JSONUtil.toList((JSONArray)JSONUtil.parseArray((Object)object), ServiceResource.class);
            }
        }
        return list;
    }

    public static List<ServiceConfig> getCurrentConfig() {
        List<ServiceConfig> list = new ArrayList<ServiceConfig>();
        Object object = staticDpRedisTemplate.opsForHash().get((Object)"foton:application:config", (Object)SdkContext.getApplicationName());
        if (object != null) {
            list = JSONUtil.toList((JSONArray)JSONUtil.parseArray((Object)object), ServiceConfig.class);
        }
        return list;
    }

    public static Map<Object, Object> getCurrentDataGroupRowDataPremssion(String modelName, Long dataGroupId) {
        User user = SdkContext.getCurrentUser();
        if (!Objects.isNull(user)) {
            return SdkContext.getDataPremssion("foton:application:datapermission:datagroup:", dataGroupId, "row");
        }
        return new HashMap<Object, Object>();
    }

    public static Map<Object, Object> getCurrentDataGroupColDataPremssion(String modelName, Long dataGroupId) {
        HashMap map = new HashMap();
        User user = SdkContext.getCurrentUser();
        if (!Objects.isNull(user)) {
            return SdkContext.getDataPremssion(modelName, dataGroupId, "col");
        }
        return new HashMap<Object, Object>();
    }

    private static Map<Object, Object> getDataPremssion(String modelName, Long dataGroupId, String type) {
        Map<Object, Object> map = new HashMap<Object, Object>();
        BaseModel tables = ThreadLocalUtil.getTables();
        if (StringUtils.isNotBlank((String)modelName)) {
            String key = StrUtil.concatStr("foton:application:datapermission:datagroup:", SdkContext.getApplicationName(), modelName, String.valueOf(dataGroupId), type);
            map = staticDpRedisTemplate.opsForHash().entries((Object)key);
            if (Objects.isNull(map)) {
                map = new HashMap();
            }
        }
        return map;
    }
}

