/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.common.sdk.intercept;

import cn.hutool.core.util.StrUtil;
import cn.spatiotemporal.web.core.constants.enums.ReturnEnum;
import cn.spatiotemporal.web.core.domain.entity.admin.User;
import cn.spatiotemporal.web.core.domain.vo.ReturnVO;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.cicv.foton.common.sdk.config.ConstantsSDK;
import com.cicv.foton.common.sdk.domain.entity.BaseModel;
import com.cicv.foton.common.sdk.domain.entity.SelectEntry;
import com.cicv.foton.common.sdk.service.SdkContext;
import com.cicv.foton.common.sdk.utils.ThreadLocalUtil;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.MethodParameter;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
public class ResponseBodyInterceptor
implements ResponseBodyAdvice<Object> {
    private static final Logger log = LoggerFactory.getLogger(ResponseBodyInterceptor.class);
    @Resource
    private RedisTemplate<String, Object> dpRedisTemplate;
    @Value(value="${foton.application.name}")
    private String appName;
    @Value(value="${foton.data-permission.is-master:false}")
    private boolean isMaster;

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return true;
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        try {
            User currentUser;
            Object data;
            ReturnVO result;
            if (body instanceof ReturnVO && (result = (ReturnVO)body).getCode().equals(ReturnEnum.SUCCESS.getCode()) && !Objects.isNull(data = result.getData()) && !Objects.isNull(currentUser = SdkContext.getCurrentUser()) && !Objects.isNull(currentUser.getTenantId()) && currentUser.getTenantId() > 0L && !this.isMaster) {
                Long orgId = currentUser.getOrgId();
                BaseModel tables = ThreadLocalUtil.getTables();
                if (null != tables && CollectionUtils.isNotEmpty(tables.getAllTables()) && CollectionUtils.isNotEmpty(tables.getSelectItems())) {
                    Map<String, List<SelectEntry>> selectItemsMap;
                    Map<String, Map<Object, Object>> colInfoList;
                    log.info("===== process threadlocal model:{}", (Object)tables.toString());
                    Map<String, String> allTablesMap = tables.getAllTables();
                    List<SelectEntry> selectItems = tables.getSelectItems();
                    if (!(allTablesMap.isEmpty() || selectItems.isEmpty() || (colInfoList = this.getDesensitization(allTablesMap, orgId, selectItemsMap = selectItems.stream().collect(Collectors.groupingBy(SelectEntry::getName)))).isEmpty() && selectItemsMap.isEmpty())) {
                        if (data instanceof Collection) {
                            Collection objList = (Collection)data;
                            ArrayList<Object> resultList = new ArrayList<Object>();
                            for (Object obj : objList) {
                                resultList.add(this.desensitize(obj, com.cicv.foton.common.sdk.utils.StrUtil.isJson(obj), colInfoList, selectItemsMap));
                            }
                            result.setData(resultList);
                        } else {
                            this.desensitize(data, com.cicv.foton.common.sdk.utils.StrUtil.isJson(data), colInfoList, selectItemsMap);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("ResponseBody\u5904\u7406\u53d1\u751f\u5f02\u5e38\u3002", (Throwable)e);
        }
        return body;
    }

    private Map<String, Map<Object, Object>> getDesensitization(Map<String, String> allTablesMap, Long orgId, Map<String, List<SelectEntry>> selectItemsMap) {
        HashMap<String, Map<Object, Object>> desensitizationMap = new HashMap<String, Map<Object, Object>>();
        for (Map.Entry<String, String> entry : allTablesMap.entrySet()) {
            String modelName = entry.getKey();
            String key = com.cicv.foton.common.sdk.utils.StrUtil.concatStr("foton:application:datapermission:orgId:", this.appName, modelName, String.valueOf(orgId), "col");
            Set keys = this.dpRedisTemplate.keys((Object)key);
            if (Objects.isNull(keys) || keys.isEmpty()) {
                selectItemsMap.remove(modelName);
                continue;
            }
            String rowKey = (String)keys.stream().findFirst().get();
            Map entries = this.dpRedisTemplate.opsForHash().entries((Object)rowKey);
            if (entries.isEmpty()) {
                selectItemsMap.remove(modelName);
                continue;
            }
            desensitizationMap.put(modelName, entries);
        }
        return desensitizationMap;
    }

    private Object desensitize(Object object, boolean flag, Map<String, Map<Object, Object>> colInfoList, Map<String, List<SelectEntry>> selectItemsMap) throws InvocationTargetException, IllegalAccessException {
        Object nullVal = null;
        Field[] fields = object.getClass().getDeclaredFields();
        Set<String> currentFeilds = ResponseBodyInterceptor.getCurrentFeilds(fields, object.getClass().getSuperclass());
        Map<Object, Object> currentLevel = ResponseBodyInterceptor.isCurrentLevel(currentFeilds, colInfoList, selectItemsMap);
        Set<Object> keySet = currentLevel.keySet();
        for (String name : currentFeilds) {
            System.out.println(name);
            PropertyDescriptor ps = BeanUtils.getPropertyDescriptor(object.getClass(), (String)name);
            if (null == ps || ps.getReadMethod() == null || ps.getWriteMethod() == null) continue;
            Object value = ps.getReadMethod().invoke(object, new Object[0]);
            if (value instanceof Collection) {
                Collection objList = (Collection)value;
                for (Object obj : objList) {
                    this.desensitize(obj, com.cicv.foton.common.sdk.utils.StrUtil.isJson(obj), colInfoList, selectItemsMap);
                }
                continue;
            }
            if (value == null) continue;
            if (!currentLevel.isEmpty()) {
                if (value instanceof String && keySet.contains(name)) {
                    String strValue = com.cicv.foton.common.sdk.utils.StrUtil.nvl(value);
                    ps.getWriteMethod().invoke(object, ResponseBodyInterceptor.getReplaceVal(strValue, currentLevel, name));
                    continue;
                }
                if (com.cicv.foton.common.sdk.utils.StrUtil.isJson(value)) {
                    this.desensitize(value, true, colInfoList, selectItemsMap);
                    continue;
                }
                ps.getWriteMethod().invoke(object, nullVal);
                continue;
            }
            if (!com.cicv.foton.common.sdk.utils.StrUtil.isJson(value)) continue;
            this.desensitize(value, true, colInfoList, selectItemsMap);
        }
        return object;
    }

    private static Object getReplaceVal(Object feildVal, Map<Object, Object> currentLevel, String key) {
        Integer deseType;
        Map colConfig = (Map)currentLevel.get(key);
        if (!Objects.isNull(colConfig) && !Objects.isNull(feildVal) && feildVal instanceof String && !Objects.isNull(deseType = (Integer)colConfig.get("deseType"))) {
            String replacedChar = (String)colConfig.get("replacedChar");
            String strValue = com.cicv.foton.common.sdk.utils.StrUtil.nvl(feildVal);
            if (Objects.equals(ConstantsSDK.PART_REPLACE, deseType)) {
                Integer startInclude = (Integer)colConfig.get("startInclude");
                Integer endExclude = (Integer)colConfig.get("endExclude");
                feildVal = com.cicv.foton.common.sdk.utils.StrUtil.replace((CharSequence)strValue, (int)(strValue.length() < startInclude ? strValue.length() : startInclude.intValue()), (int)(strValue.length() < endExclude ? strValue.length() : endExclude.intValue()), (CharSequence)replacedChar);
            } else if (Objects.equals(ConstantsSDK.ALL_REPLACE, deseType)) {
                feildVal = com.cicv.foton.common.sdk.utils.StrUtil.replace((CharSequence)strValue, (int)0, (int)strValue.length(), (CharSequence)replacedChar);
            }
        }
        return feildVal;
    }

    private static Set<String> getCurrentFeilds(Field[] fields, Class<?> superclass) {
        Set<String> currentKeySet = new HashSet<String>();
        for (Field field : fields) {
            currentKeySet.add(field.getName());
        }
        currentKeySet = ResponseBodyInterceptor.currentKeySet(currentKeySet, superclass);
        log.info("\u5f53\u524d\u5c42\u7ea7\u5b57\u6bb5:{}", (Object)JSON.toJSONString(currentKeySet));
        return currentKeySet;
    }

    private static Map<Object, Object> isCurrentLevel(Set<String> getCurrentFeilds, Map<String, Map<Object, Object>> colInfoList, Map<String, List<SelectEntry>> selectItemsMap) {
        HashMap<Object, Object> currentMap = new HashMap<Object, Object>();
        for (Map.Entry<String, List<SelectEntry>> entry : selectItemsMap.entrySet()) {
            double total;
            List<SelectEntry> value = entry.getValue();
            List collect = value.stream().map(o -> StrUtil.toCamelCase((CharSequence)o.getColumnAliasName())).distinct().collect(Collectors.toList());
            HashSet intersection = new HashSet(collect);
            intersection.retainAll(getCurrentFeilds);
            double intersectionToal = intersection.size();
            double percent = intersectionToal / (total = (double)collect.size()) * 100.0;
            if (!(percent > 60.0)) continue;
            return colInfoList.get(entry.getKey());
        }
        return currentMap;
    }

    private static Set<String> currentKeySet(Set<String> currentKeySet, Class<?> superclass) {
        Field[] superFields = superclass.getDeclaredFields();
        if (superFields.length > 0) {
            for (Field field : superFields) {
                currentKeySet.add(field.getName());
            }
            ResponseBodyInterceptor.currentKeySet(currentKeySet, superclass.getSuperclass());
        }
        return currentKeySet;
    }
}

