/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.common.sdk.intercept;

import cn.spatiotemporal.web.core.constants.enums.ReturnEnum;
import cn.spatiotemporal.web.core.domain.entity.admin.User;
import cn.spatiotemporal.web.core.domain.vo.ReturnVO;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.cicv.foton.common.sdk.config.ConstantsSDK;
import com.cicv.foton.common.sdk.domain.entity.BaseModel;
import com.cicv.foton.common.sdk.service.SdkContext;
import com.cicv.foton.common.sdk.utils.StrUtil;
import com.cicv.foton.common.sdk.utils.ThreadLocalUtil;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.MethodParameter;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
public class ResponseBodyInterceptor
implements ResponseBodyAdvice<Object> {
    private static final Logger log = LoggerFactory.getLogger(ResponseBodyInterceptor.class);
    @Resource
    private RedisTemplate<String, Object> dpRedisTemplate;
    @Value(value="${foton.application.name}")
    private String appName;

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return true;
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        try {
            User currentUser;
            Object data;
            ReturnVO result;
            if (body instanceof ReturnVO && (result = (ReturnVO)body).getCode().equals(ReturnEnum.SUCCESS.getCode()) && !Objects.isNull(data = result.getData()) && !Objects.isNull(currentUser = SdkContext.getCurrentUser()) && !Objects.isNull(currentUser.getTenantId()) && currentUser.getTenantId() > 0L) {
                Long orgId = currentUser.getOrgId();
                BaseModel tables = ThreadLocalUtil.getTables();
                if (null != tables && CollectionUtils.isNotEmpty(tables.getFromItems()) && CollectionUtils.isNotEmpty(tables.getSelectItems())) {
                    log.info("===== process threadlocal model:{}", (Object)tables.toString());
                }
            }
        }
        catch (Exception e) {
            log.error("ResponseBody\u5904\u7406\u53d1\u751f\u5f02\u5e38\u3002", (Throwable)e);
        }
        return body;
    }

    private Map<Object, Object> getColInfo(String mainTableName, Long orgId) {
        String key = StrUtil.concatStr("foton:application:datapermission:orgId:", this.appName, mainTableName, String.valueOf(orgId), "col");
        Set keys = this.dpRedisTemplate.keys((Object)key);
        if (Objects.isNull(keys) || keys.isEmpty()) {
            return null;
        }
        String rowKey = (String)keys.stream().findFirst().get();
        return this.dpRedisTemplate.opsForHash().entries((Object)rowKey);
    }

    private Object desensitize(Object object, boolean flag, Map<Object, Object> colMap) throws InvocationTargetException, IllegalAccessException {
        Integer nullVal = null;
        Field[] fields = object.getClass().getDeclaredFields();
        Set<Object> keySet = colMap.keySet();
        boolean currentLevel = ResponseBodyInterceptor.isCurrentLevel(fields, keySet);
        for (Field field : fields) {
            PropertyDescriptor ps;
            String name = field.getName();
            System.out.println(name);
            if (Objects.equals("total", name)) {
                nullVal = 1;
            }
            if (null == (ps = BeanUtils.getPropertyDescriptor(object.getClass(), (String)field.getName())) || ps.getReadMethod() == null || ps.getWriteMethod() == null) continue;
            Object value = ps.getReadMethod().invoke(object, new Object[0]);
            if (value instanceof Collection) {
                Collection objList = (Collection)value;
                for (Object obj : objList) {
                    this.desensitize(obj, StrUtil.isJson(obj), colMap);
                }
                continue;
            }
            if (value == null) continue;
            if (currentLevel) {
                if (value instanceof String && keySet.contains(name)) {
                    String strValue = StrUtil.nvl(value);
                    ps.getWriteMethod().invoke(object, ResponseBodyInterceptor.getReplaceVal(strValue, colMap, name));
                    continue;
                }
                if (StrUtil.isJson(value)) {
                    this.desensitize(value, true, colMap);
                    continue;
                }
                ps.getWriteMethod().invoke(object, nullVal);
                continue;
            }
            if (!StrUtil.isJson(value)) continue;
            this.desensitize(value, true, colMap);
        }
        return object;
    }

    private static Object getReplaceVal(Object feildVal, Map<Object, Object> colMap, String key) {
        Integer deseType;
        Map colConfig = (Map)colMap.get(key);
        if (!Objects.isNull(colConfig) && !Objects.isNull(feildVal) && feildVal instanceof String && !Objects.isNull(deseType = (Integer)colConfig.get("deseType"))) {
            Integer startInclude = (Integer)colConfig.get("startInclude");
            Integer endExclude = (Integer)colConfig.get("endExclude");
            String replacedChar = (String)colConfig.get("replacedChar");
            String strValue = StrUtil.nvl(feildVal);
            if (Objects.equals(ConstantsSDK.PART_REPLACE, deseType)) {
                feildVal = StrUtil.replace((CharSequence)strValue, (int)startInclude, (int)endExclude, (CharSequence)replacedChar);
            } else if (Objects.equals(ConstantsSDK.ALL_REPLACE, deseType)) {
                feildVal = StrUtil.replace((CharSequence)strValue, (int)0, (int)strValue.length(), (CharSequence)replacedChar);
            }
        }
        return feildVal;
    }

    private static boolean isCurrentLevel(Field[] fields, Set<Object> keySet) {
        HashSet<String> currentKeySet = new HashSet<String>();
        for (Field field : fields) {
            currentKeySet.add(field.getName());
        }
        HashSet<Object> intersection = new HashSet<Object>(keySet);
        intersection.retainAll(currentKeySet);
        double intersectionToal = intersection.size();
        double total = keySet.size();
        double percent = intersectionToal / total * 100.0;
        return !(percent < 30.0);
    }
}

