/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.common.sdk.config;

import cn.spatiotemporal.web.core.config.security.SecurityProperties;
import cn.spatiotemporal.web.core.security.RestAccessDeniedHandler;
import cn.spatiotemporal.web.core.security.RestAuthenticationEntryPoint;
import cn.spatiotemporal.web.core.security.RestAuthenticationFailureHandler;
import cn.spatiotemporal.web.core.security.RestLogoutSuccessHandler;
import com.cicv.foton.common.sdk.filter.JwtAuthenticationTokenFilter;
import com.cicv.foton.common.sdk.service.RestAuthenticationSuccessHandler;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;

@EnableWebSecurity
@Configuration
@EnableConfigurationProperties(value={SecurityProperties.class})
@EnableGlobalMethodSecurity(prePostEnabled=true)
public class SpringSecurityConf
extends WebSecurityConfigurerAdapter {
    @Autowired
    SecurityProperties securityProperties;
    @Autowired
    RestAuthenticationEntryPoint authenticationEntryPoint;
    @Autowired
    RestAuthenticationSuccessHandler authenticationSuccessHandler;
    @Autowired
    RestAuthenticationFailureHandler authenticationFailureHandler;
    @Autowired
    RestLogoutSuccessHandler logoutSuccessHandler;
    @Autowired
    RestAccessDeniedHandler accessDeniedHandler;
    @Autowired
    JwtAuthenticationTokenFilter jwtAuthenticationTokenFilter;

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
    }

    protected void configure(HttpSecurity http) throws Exception {
        if ("disable".equals(this.securityProperties.getMode())) {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.csrf().disable()).authorizeRequests().antMatchers(new String[]{"/**"})).permitAll();
        } else {
            ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.csrf().disable()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).httpBasic().authenticationEntryPoint((AuthenticationEntryPoint)this.authenticationEntryPoint).and()).authorizeRequests().antMatchers(this.securityProperties.getPermitAccess())).permitAll().antMatchers(this.securityProperties.getAuthAccess())).authenticated().and()).exceptionHandling().accessDeniedHandler((AccessDeniedHandler)this.accessDeniedHandler).authenticationEntryPoint((AuthenticationEntryPoint)this.authenticationEntryPoint).and()).logout().logoutSuccessHandler((LogoutSuccessHandler)this.logoutSuccessHandler).and()).authorizeRequests().antMatchers(HttpMethod.OPTIONS)).permitAll().antMatchers(new String[]{"/admin/sso/logout"})).permitAll();
            http.addFilterBefore((Filter)this.jwtAuthenticationTokenFilter, UsernamePasswordAuthenticationFilter.class);
            http.headers().cacheControl();
        }
    }

    public void configure(WebSecurity web) throws Exception {
        web.ignoring().antMatchers(new String[]{"/css/**", "/js/**", "/images/**"});
    }

    @Bean(name={"org.springframework.security.authenticationManager"})
    public AuthenticationManager authenticationManagerBean() throws Exception {
        return super.authenticationManagerBean();
    }
}

