/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.common.sdk.service;

import com.alibaba.fastjson.JSON;
import com.cicv.foton.common.sdk.utils.JwtTokenUtils;
import com.cicv.foton.common.sdk.utils.RedisDao;
import com.inzyme.spatiotemporal.web.core.constants.enums.ReturnEnum;
import com.inzyme.spatiotemporal.web.core.domain.entity.admin.User;
import com.inzyme.spatiotemporal.web.core.domain.vo.ReturnVO;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cglib.beans.BeanMap;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.stereotype.Component;

@Component
public class RestAuthenticationSuccessHandler
implements AuthenticationSuccessHandler {
    @Value(value="${spatiotemporal.cache.jwtKey:spatiotemporal:jwt:token}")
    private String jwtKey;
    @Autowired
    RedisDao redisDao;
    @Resource(name="dpRedisTemplate")
    private RedisTemplate<String, Object> dpRedisTemplate;

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setHeader("Access-Control-Allow-Headers", "token, Accept, Origin, X-Requested-With, Content-Type, Last-Modified");
        User userDetails = (User)authentication.getPrincipal();
        String jwtToken = JwtTokenUtils.generateToken(userDetails.getUsername(), 3600, (Map<String, Object>)BeanMap.create((Object)userDetails));
        this.redisDao.put(this.jwtKey + ":" + jwtToken, userDetails);
        if (null != this.dpRedisTemplate) {
            this.dpRedisTemplate.opsForValue().set((Object)(this.jwtKey + ":" + jwtToken), (Object)userDetails);
        }
        response.getWriter().write(JSON.toJSONString((Object)new ReturnVO(ReturnEnum.SUCCESS, (Object)jwtToken)));
    }
}

