/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.common.sdk.intercept;

import com.baomidou.mybatisplus.extension.plugins.handler.DataPermissionHandler;
import com.cicv.foton.common.sdk.service.SdkContext;
import com.cicv.foton.common.sdk.utils.StrUtil;
import com.cicv.foton.common.sdk.utils.ThreadLocalUtil;
import com.inzyme.spatiotemporal.web.core.domain.entity.admin.User;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.HexValue;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.PlainSelect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class MyDataPermissionHandler
implements DataPermissionHandler {
    private static final Logger log = LoggerFactory.getLogger(MyDataPermissionHandler.class);
    private RedisTemplate<String, Object> dpRedisTemplate;
    private String appName;

    public MyDataPermissionHandler(RedisTemplate<String, Object> dpRedisTemplate, String appName) {
        this.dpRedisTemplate = dpRedisTemplate;
        this.appName = appName;
    }

    public void processDataPermission(PlainSelect plainSelect, String whereSegment) {
        try {
            HashMap<String, Object> map;
            Expression where;
            block32: {
                Long orgId;
                Map<Object, Object> rwowMap;
                User user = SdkContext.getCurrentUser();
                where = plainSelect.getWhere();
                if (where == null) {
                    where = new HexValue(" 1 = 1 ");
                }
                log.info("\u5f00\u59cb\u8fdb\u884c\u6743\u9650\u8fc7\u6ee4,where: {},whereSegment: {}", (Object)where, (Object)whereSegment);
                String className = whereSegment.substring(0, whereSegment.lastIndexOf("."));
                String methodName = whereSegment.substring(whereSegment.lastIndexOf(".") + 1);
                Table fromItem = (Table)plainSelect.getFromItem();
                Alias fromItemAlias = fromItem.getAlias();
                String mainTableName = fromItemAlias == null ? fromItem.getName() : fromItemAlias.getName();
                log.info("\u7528\u5230\u7684\u8868\u540d:{}", (Object)mainTableName);
                map = new HashMap<String, Object>();
                map.put("tableName", mainTableName);
                if (Objects.isNull(user) || Objects.isNull(user.getTenantId()) || user.getTenantId() <= 0L || Objects.isNull(user.getOrgId()) || Objects.isNull(rwowMap = this.getRowInfo(mainTableName, orgId = user.getOrgId())) || rwowMap.isEmpty()) break block32;
                for (Object key : rwowMap.keySet()) {
                    Object object = rwowMap.get(key);
                    if (Objects.isNull(object)) continue;
                    Map val = (Map)object;
                    if (val.isEmpty() || Objects.isNull(val.get("oper")) || Objects.isNull(val.get("val"))) break;
                    Column column = new Column(String.valueOf(key));
                    String oper = (String)val.get("oper");
                    Object value = val.get("val");
                    ArrayList<Object> valueList = new ArrayList<Object>();
                    switch (oper) {
                        case "in": {
                            valueList.add(value);
                            InExpression inExpression = this.inExpression(valueList, column, false);
                            where = new AndExpression(where, (Expression)inExpression);
                            break;
                        }
                        case "not in": {
                            valueList.add(value);
                            InExpression notInExpression = this.inExpression(valueList, column, true);
                            where = new AndExpression(where, (Expression)notInExpression);
                            break;
                        }
                        case ">": {
                            GreaterThan gt = new GreaterThan();
                            gt.setLeftExpression((Expression)column);
                            gt.setRightExpression((Expression)new StringValue(String.valueOf(value)));
                            where = new AndExpression(where, (Expression)gt);
                            break;
                        }
                        case "<": {
                            MinorThan lt = new MinorThan();
                            lt.setLeftExpression((Expression)column);
                            lt.setRightExpression((Expression)new StringValue(String.valueOf(value)));
                            where = new AndExpression(where, (Expression)lt);
                            break;
                        }
                        case ">=": {
                            GreaterThanEquals ge = new GreaterThanEquals();
                            ge.setLeftExpression((Expression)column);
                            ge.setRightExpression((Expression)new StringValue(String.valueOf(value)));
                            where = new AndExpression(where, (Expression)ge);
                            break;
                        }
                        case "<=": {
                            MinorThanEquals le = new MinorThanEquals();
                            le.setLeftExpression((Expression)column);
                            le.setRightExpression((Expression)new StringValue(String.valueOf(value)));
                            where = new AndExpression(where, (Expression)le);
                            break;
                        }
                        case "is not null": {
                            IsNullExpression isNotNullExpression = new IsNullExpression();
                            isNotNullExpression.setLeftExpression((Expression)column);
                            isNotNullExpression.setNot(true);
                            where = new AndExpression(where, (Expression)isNotNullExpression);
                            break;
                        }
                        case "is null": {
                            IsNullExpression isNullExpression = new IsNullExpression();
                            isNullExpression.setLeftExpression((Expression)column);
                            isNullExpression.setNot(false);
                            where = new AndExpression(where, (Expression)isNullExpression);
                            break;
                        }
                    }
                    plainSelect.setWhere(where);
                }
            }
            ThreadLocalUtil.getInstance().setContext(map);
            log.info(plainSelect.toString());
            where = new HexValue(" 1 = 2 ");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Map<Object, Object> getRowInfo(String mainTableName, Long orgId) {
        String key = StrUtil.concatStr("foton:application:datapermission:orgId:", this.appName, mainTableName, String.valueOf(orgId), "row");
        Set keys = this.dpRedisTemplate.keys((Object)key);
        if (this.dpRedisTemplate.hasKey((Object)key).booleanValue()) {
            String string = "1";
        }
        if (keys.isEmpty()) {
            return null;
        }
        String rowKey = (String)keys.stream().findFirst().get();
        return this.dpRedisTemplate.opsForHash().entries((Object)rowKey);
    }

    private InExpression inExpression(List<Object> valueList, Column column, boolean not) {
        InExpression inExpression = new InExpression();
        inExpression.setLeftExpression((Expression)column);
        ExpressionList expressionList = new ExpressionList();
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        for (Object value : valueList) {
            this.addExpressions(expressions, value);
        }
        expressionList.setExpressions(expressions);
        inExpression.setRightItemsList((ItemsList)expressionList);
        inExpression.setNot(not);
        return inExpression;
    }

    private void addExpressions(List<Expression> expressions, Object value) {
        String strVal = StrUtil.nvl(value);
        if (value instanceof String) {
            expressions.add((Expression)new StringValue(strVal));
        } else if (value instanceof Integer || value instanceof Long) {
            expressions.add((Expression)new LongValue(Long.valueOf(strVal).longValue()));
        } else if (value instanceof Double) {
            expressions.add((Expression)new DoubleValue(strVal));
        }
    }

    public Expression getSqlSegment(Expression where, String mappedStatementId) {
        log.info("***** \u5f00\u59cb\u8fdb\u884c\u6743\u9650\u8fc7\u6ee4,\u539fwhere: {},mappedStatementId: {}", (Object)where.toString(), (Object)mappedStatementId);
        return null;
    }

    @Autowired
    public MyDataPermissionHandler() {
    }
}

