/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.common.sdk.intercept;

import com.baomidou.mybatisplus.core.plugins.InterceptorIgnoreHelper;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.extension.plugins.inner.DataPermissionInterceptor;
import com.cicv.foton.common.sdk.intercept.MyDataPermissionHandler;
import java.sql.SQLException;
import java.util.List;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SetOperationList;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

public class MyDataPermissionInterceptor
extends DataPermissionInterceptor {
    private MyDataPermissionHandler dataPermissionHandler;

    public void beforeQuery(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) throws SQLException {
        if (!InterceptorIgnoreHelper.willIgnoreDataPermission((String)ms.getId())) {
            PluginUtils.MPBoundSql mpBs = PluginUtils.mpBoundSql((BoundSql)boundSql);
            mpBs.sql(this.parserSingle(mpBs.sql(), ms.getId()));
        }
    }

    protected void processSelect(Select select, int index, String sql, Object obj) {
        SelectBody selectBody = select.getSelectBody();
        if (selectBody instanceof PlainSelect) {
            PlainSelect plainSelect = (PlainSelect)selectBody;
            this.processDataPermission(plainSelect, (String)obj);
        } else if (selectBody instanceof SetOperationList) {
            SetOperationList setOperationList = (SetOperationList)selectBody;
            List selectBodyList = setOperationList.getSelects();
            selectBodyList.forEach(s -> {
                PlainSelect plainSelect = (PlainSelect)s;
                this.processDataPermission(plainSelect, (String)obj);
            });
        }
    }

    protected void processDataPermission(PlainSelect plainSelect, String whereSegment) {
        this.dataPermissionHandler.processDataPermission(plainSelect, whereSegment);
    }

    public MyDataPermissionHandler getDataPermissionHandler() {
        return this.dataPermissionHandler;
    }

    public void setDataPermissionHandler(MyDataPermissionHandler dataPermissionHandler) {
        this.dataPermissionHandler = dataPermissionHandler;
    }

    public MyDataPermissionInterceptor() {
    }

    public MyDataPermissionInterceptor(MyDataPermissionHandler dataPermissionHandler) {
        this.dataPermissionHandler = dataPermissionHandler;
    }

    public String toString() {
        return "MyDataPermissionInterceptor(super=" + super.toString() + ", dataPermissionHandler=" + this.getDataPermissionHandler() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MyDataPermissionInterceptor)) {
            return false;
        }
        MyDataPermissionInterceptor other = (MyDataPermissionInterceptor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MyDataPermissionHandler this$dataPermissionHandler = this.getDataPermissionHandler();
        MyDataPermissionHandler other$dataPermissionHandler = other.getDataPermissionHandler();
        return !(this$dataPermissionHandler == null ? other$dataPermissionHandler != null : !this$dataPermissionHandler.equals(other$dataPermissionHandler));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MyDataPermissionInterceptor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        MyDataPermissionHandler $dataPermissionHandler = this.getDataPermissionHandler();
        result = result * 59 + ($dataPermissionHandler == null ? 43 : $dataPermissionHandler.hashCode());
        return result;
    }
}

