/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.common.sdk.service;

import com.cicv.foton.common.sdk.utils.AuthorityUtils;
import com.cicv.foton.common.sdk.utils.RedisDao;
import com.inzyme.spatiotemporal.web.core.domain.entity.admin.User;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class SdkContext {
    private static final Logger log = LoggerFactory.getLogger(SdkContext.class);
    @Resource(name="dpRedisTemplate")
    private RedisTemplate<String, Object> dpRedisTemplate;
    @Autowired
    RedisDao redisDao;
    private static final String USER_ATTRIBUTES = "USER_ATTRIBUTES";
    @Value(value="${foton.application.name:}")
    private String appName;
    private static String applicationName;

    @PostConstruct
    public void init() {
        applicationName = this.appName;
    }

    public static String getApplicationName() {
        return applicationName;
    }

    public static void setCurrentUser(User currentUser) {
        RequestContextHolder.currentRequestAttributes().setAttribute(USER_ATTRIBUTES, (Object)currentUser, 0);
    }

    public static User getCurrentUser() {
        User user = (User)RequestContextHolder.currentRequestAttributes().getAttribute(USER_ATTRIBUTES, 0);
        try {
            if (null != user) {
                return user;
            }
            ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            HttpServletRequest request = requestAttributes.getRequest();
            String token = request.getHeader("X-Token");
            if (StringUtils.isNotEmpty((String)token)) {
                user = (User)AuthorityUtils.getCurrentUser(token);
            }
            if (null == user) {
                throw new BaseBusinessException("400", "\u672a\u767b\u5f55\u7528\u6237!");
            }
            SdkContext.setCurrentUser(user);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        return user;
    }
}

