/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.common.sdk.intercept;

import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import com.cicv.foton.common.sdk.service.TenantInterceptor;
import com.cicv.foton.common.sdk.utils.AuthorityUtils;
import com.inzyme.spatiotemporal.web.core.domain.entity.admin.User;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantLineHandlerInterceptor
implements TenantInterceptor,
TenantLineHandler {
    private static final Logger log = LoggerFactory.getLogger(TenantLineHandlerInterceptor.class);
    private List<String> ignoreTableNames;

    public TenantLineHandlerInterceptor(List<String> ignoreTableNames) {
        this.ignoreTableNames = ignoreTableNames;
    }

    public boolean ignoreTable(String tableName) {
        return this.ignoreTableNames.contains(tableName);
    }

    public String getTenantIdColumn() {
        return "tenant_id";
    }

    public Expression getTenantId() {
        try {
            User currentUser = AuthorityUtils.getLoginUser();
            if (null == currentUser || null == currentUser.getTenantId()) {
                log.warn("\u5f53\u524d\u672a\u767b\u5f55\u7528\u6237\uff01");
                return new LongValue(0L);
            }
            return new LongValue(currentUser.getTenantId().longValue());
        }
        catch (Exception e) {
            throw new RuntimeException("\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff01", e);
        }
    }

    @Override
    public Object intercept() throws Throwable {
        return this.getTenantId();
    }
}

