/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.common.sdk.log.delivery;

import com.cicv.foton.common.sdk.log.delivery.DeliveryStrategy;
import com.cicv.foton.common.sdk.log.delivery.FailedDeliveryCallback;
import org.apache.kafka.clients.producer.BufferExhaustedException;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.errors.TimeoutException;

public class AsyncDeliveryStrategy
implements DeliveryStrategy {
    @Override
    public <K, V, E> boolean send(Producer<K, V> producer, ProducerRecord<K, V> record, final E event, final FailedDeliveryCallback<E> failedDeliveryCallback) {
        try {
            producer.send(record, new Callback(){

                public void onCompletion(RecordMetadata metadata, Exception exception) {
                    if (exception != null) {
                        failedDeliveryCallback.onFailedDelivery(event, exception);
                    }
                }
            });
            return true;
        }
        catch (BufferExhaustedException | TimeoutException e) {
            failedDeliveryCallback.onFailedDelivery(event, e);
            return false;
        }
    }
}

