/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.common.sdk.intercept;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.cicv.foton.common.sdk.utils.AuthorityUtils;
import com.cicv.foton.common.sdk.utils.StrUtil;
import com.cicv.foton.common.sdk.utils.ThreadLocalUtil;
import com.inzyme.spatiotemporal.web.core.constants.enums.ReturnEnum;
import com.inzyme.spatiotemporal.web.core.domain.entity.admin.User;
import com.inzyme.spatiotemporal.web.core.domain.vo.ReturnVO;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.MethodParameter;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
public class ResponseBodyInterceptor
implements ResponseBodyAdvice<Object> {
    private static final Logger log = LoggerFactory.getLogger(ResponseBodyInterceptor.class);
    private static final String PERMISSION_PRE = "datapermission:";
    private static final String COL = "col";
    private static final Integer PART_REPLACE = 0;
    private static final Integer ALL_REPLACE = 1;
    @Resource
    private RedisTemplate<String, Object> dpRedisTemplate;
    @Value(value="${foton.application.name}")
    private String appName;

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return true;
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        try {
            ReturnVO result;
            if (body instanceof ReturnVO && (result = (ReturnVO)body).getCode().equals(ReturnEnum.SUCCESS.getCode())) {
                Object data = result.getData();
                log.info("===== process table:{}", (Object)ThreadLocalUtil.getTblName());
                if (result.getData() instanceof Collection) {
                    result.setData(this.desensitize((JSONArray)JSON.toJSON((Object)data)));
                } else {
                    result.setData(this.desensitize((JSONObject)JSON.toJSON((Object)data)));
                }
            }
        }
        catch (Exception e) {
            log.error("ResponseBody\u5904\u7406\u53d1\u751f\u5f02\u5e38\u3002", (Throwable)e);
        }
        return body;
    }

    private Object desensitize(Object object) throws InvocationTargetException, IllegalAccessException {
        User currentUser;
        Long tenantId;
        if (!Objects.isNull(object) && !Objects.isNull(tenantId = (currentUser = AuthorityUtils.getLoginUser()).getTenantId()) && tenantId > 0L) {
            String mainTableName = ThreadLocalUtil.getTblName();
            Map<Object, Object> colMap = this.getColInfo(mainTableName, tenantId);
            if (Objects.isNull(colMap)) {
                return object;
            }
            ResponseBodyInterceptor.updateNodeJson(object, colMap);
        }
        return object;
    }

    private Map<Object, Object> getColInfo(String mainTableName, Long tenantId) {
        StringBuffer sb = new StringBuffer(PERMISSION_PRE);
        StringBuffer preKey = sb.append(tenantId);
        String concat = String.valueOf(preKey).concat(":*:").concat(this.appName).concat(":").concat(mainTableName).concat(":").concat(COL);
        Set keys = this.dpRedisTemplate.keys((Object)concat);
        if (Objects.isNull(keys) || keys.isEmpty()) {
            return null;
        }
        String rowKey = (String)keys.stream().findFirst().get();
        return this.dpRedisTemplate.opsForHash().entries((Object)rowKey);
    }

    public static Object updateNodeJson(Object objJson, Map<Object, Object> colMap) {
        block10: {
            block9: {
                if (!(objJson instanceof JSONArray)) break block9;
                JSONArray objArray = (JSONArray)objJson;
                for (int i = 0; i < objArray.size(); ++i) {
                    ResponseBodyInterceptor.updateNodeJson(objArray.get(i), colMap);
                }
                break block10;
            }
            if (!(objJson instanceof JSONObject)) break block10;
            boolean flag = false;
            Set<Object> keySet = colMap.keySet();
            JSONObject jsonObject = (JSONObject)objJson;
            Set currentKeySet = jsonObject.keySet();
            if (ResponseBodyInterceptor.isCurrentLevel(currentKeySet, keySet)) {
                flag = true;
            }
            Iterator it = jsonObject.keySet().iterator();
            while (it.hasNext()) {
                JSONArray objArray;
                String key = it.next().toString();
                Object object = jsonObject.get((Object)key);
                if (flag) {
                    if (keySet.contains(key)) {
                        ResponseBodyInterceptor.setJsonValue(object, key, object, colMap, jsonObject);
                        continue;
                    }
                    if (object instanceof JSONArray) {
                        objArray = (JSONArray)object;
                        ResponseBodyInterceptor.updateNodeJson(objArray, colMap);
                        continue;
                    }
                    if (object instanceof JSONObject) {
                        ResponseBodyInterceptor.updateNodeJson(object, colMap);
                        continue;
                    }
                    ResponseBodyInterceptor.setJsonValue(object, key, object, null, jsonObject);
                    continue;
                }
                if (object instanceof JSONArray) {
                    objArray = (JSONArray)object;
                    if (objArray.isEmpty()) continue;
                    Object chird = objArray.get(0);
                    if (chird instanceof JSONArray || chird instanceof JSONObject) {
                        ResponseBodyInterceptor.updateNodeJson(objArray, colMap);
                        continue;
                    }
                    ResponseBodyInterceptor.setJsonValue(chird, key, chird, null, jsonObject);
                    continue;
                }
                if (!(object instanceof JSONObject)) continue;
                ResponseBodyInterceptor.updateNodeJson(object, colMap);
            }
        }
        return objJson;
    }

    public static void setJsonValue(Object obj, String key, Object val, Map<Object, Object> colMap, JSONObject currentJsonObject) {
        if (!(obj instanceof JSONArray) && !(obj instanceof JSONObject)) {
            currentJsonObject.put(key, Objects.isNull(colMap) ? null : ResponseBodyInterceptor.getReplaceVal(val, colMap, key));
        }
    }

    private static Object getReplaceVal(Object feildVal, Map<Object, Object> colMap, String key) {
        Integer deseType;
        Map colConfig = (Map)colMap.get(key);
        if (!Objects.isNull(colConfig) && !Objects.isNull(feildVal) && feildVal instanceof String && !Objects.isNull(deseType = (Integer)colConfig.get("deseType"))) {
            Integer startInclude = (Integer)colConfig.get("startInclude");
            Integer endExclude = (Integer)colConfig.get("endExclude");
            String replacedChar = (String)colConfig.get("replacedChar");
            String strValue = StrUtil.nvl(feildVal);
            if (Objects.equals(PART_REPLACE, deseType)) {
                feildVal = StrUtil.replace((CharSequence)strValue, (int)startInclude, (int)endExclude, (CharSequence)replacedChar);
            } else if (Objects.equals(ALL_REPLACE, deseType)) {
                feildVal = StrUtil.replace((CharSequence)strValue, (int)0, (int)strValue.length(), (CharSequence)replacedChar);
            }
        }
        return feildVal;
    }

    private static boolean isCurrentLevel(Set<String> currentKeySet, Set<Object> keySet) {
        HashSet<Object> intersection = new HashSet<Object>(keySet);
        intersection.retainAll(currentKeySet);
        double intersectionToal = intersection.size();
        double total = keySet.size();
        double percent = intersectionToal / total * 100.0;
        return !(percent < 30.0);
    }
}

