/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.common.sdk.config;

import com.alibaba.fastjson.support.spring.FastJsonRedisSerializer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisClientConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import redis.clients.jedis.JedisPoolConfig;

@Configuration
public class DataPermissionRedisConfig {
    @Value(value="${spring.redis.dataPermission.host}")
    private String dpHost;
    @Value(value="${spring.redis.dataPermission.port}")
    private String dpPort;
    @Value(value="${spring.redis.dataPermission.password}")
    private String dpPassword;
    @Value(value="${spring.redis.dataPermission.database}")
    private Integer dpDatabase;
    @Value(value="${spring.redis.pool.max-idle:8}")
    private Integer MAX_IDLE;
    @Value(value="${spring.redis.pool.max-active:20}")
    private Integer MAX_TOTAL;
    private static final long MAX_WAIT_MILLIS = 6000L;

    private RedisConnectionFactory connectionFactory(String host, int port, String password, int maxIdle, int maxTotal, long maxWaitMillis, int index) {
        RedisStandaloneConfiguration redisConfiguration = new RedisStandaloneConfiguration();
        redisConfiguration.setHostName(host);
        redisConfiguration.setPort(port);
        if (!StringUtils.isEmpty((String)password)) {
            redisConfiguration.setPassword(password);
        }
        if (index != 0) {
            redisConfiguration.setDatabase(index);
        }
        JedisClientConfiguration.JedisPoolingClientConfigurationBuilder jpccb = (JedisClientConfiguration.JedisPoolingClientConfigurationBuilder)JedisClientConfiguration.builder();
        jpccb.poolConfig((GenericObjectPoolConfig)this.poolConfig(maxIdle, maxTotal, maxWaitMillis, false));
        JedisClientConfiguration jedisClientConfiguration = jpccb.build();
        return new JedisConnectionFactory(redisConfiguration, jedisClientConfiguration);
    }

    private JedisPoolConfig poolConfig(int maxIdle, int maxTotal, long maxWaitMillis, boolean testOnBorrow) {
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxIdle(maxIdle);
        poolConfig.setMaxTotal(maxTotal);
        poolConfig.setMaxWaitMillis(maxWaitMillis);
        poolConfig.setTestOnBorrow(testOnBorrow);
        return poolConfig;
    }

    @Bean(name={"dpRedisTemplate"})
    public RedisTemplate<String, Object> dpRedisTemplate() {
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory(this.connectionFactory(this.dpHost, Integer.parseInt(this.dpPort), this.dpPassword, this.MAX_IDLE, this.MAX_TOTAL, 6000L, this.dpDatabase));
        FastJsonRedisSerializer fastJsonRedisSerializer = new FastJsonRedisSerializer(Object.class);
        template.setValueSerializer((RedisSerializer)fastJsonRedisSerializer);
        template.setHashValueSerializer((RedisSerializer)fastJsonRedisSerializer);
        StringRedisSerializer stringRedisSerializer = new StringRedisSerializer();
        template.setKeySerializer((RedisSerializer)stringRedisSerializer);
        template.setHashKeySerializer((RedisSerializer)stringRedisSerializer);
        return template;
    }
}

