/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.common.sdk.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.cicv.foton.common.sdk.utils.RedisDao;
import com.inzyme.spatiotemporal.web.core.constants.enums.ReturnEnum;
import com.inzyme.spatiotemporal.web.core.domain.entity.admin.User;
import com.inzyme.spatiotemporal.web.core.exception.BaseBusinessException;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class AuthorityUtils {
    private static final Logger log = LoggerFactory.getLogger(AuthorityUtils.class);
    @Value(value="${spatiotemporal.cache.jwtKey:spatiotemporal:jwt:token}")
    private String jwtKey;
    @Value(value="${spatiotemporal.cache.usernameKey:spatiotemporal:username}")
    private String usernameKey;
    @Value(value="${spatiotemporal.cache.expire:1800}")
    private int expire;
    @Value(value="${spatiotemporal.cache.delayExpireByAccess:false}")
    private boolean resume;
    @Resource
    private RedisDao redisDao;
    private static AuthorityUtils instance;

    static {
        JSON.DEFAULT_GENERATE_FEATURE = SerializerFeature.config((int)JSON.DEFAULT_GENERATE_FEATURE, (SerializerFeature)SerializerFeature.SkipTransientField, (boolean)false);
    }

    @PostConstruct
    public void init() {
        instance = this;
        AuthorityUtils.instance.jwtKey = this.jwtKey;
        AuthorityUtils.instance.usernameKey = this.usernameKey;
        AuthorityUtils.instance.expire = this.expire;
        AuthorityUtils.instance.redisDao = this.redisDao;
    }

    public static String checkToken(String username) {
        return (String)AuthorityUtils.instance.redisDao.get(String.valueOf(AuthorityUtils.instance.usernameKey) + ":" + username);
    }

    public static void putCurrentUser(String token, UserDetails user) {
        String userJson = JSONObject.toJSONString((Object)user);
        if (AuthorityUtils.instance.redisDao != null) {
            AuthorityUtils.instance.redisDao.put(String.valueOf(AuthorityUtils.instance.jwtKey) + ":" + token, user, AuthorityUtils.instance.expire);
            AuthorityUtils.instance.redisDao.put(String.valueOf(AuthorityUtils.instance.usernameKey) + ":" + user.getUsername(), token, AuthorityUtils.instance.expire);
        } else {
            log.error("AuthorityUtils.redisTemplate is null");
        }
    }

    public static void putPrefixUser(String token, String prefix, UserDetails user) {
        String userJson = JSONObject.toJSONString((Object)user);
        if (AuthorityUtils.instance.redisDao != null) {
            AuthorityUtils.instance.redisDao.put(String.valueOf(AuthorityUtils.instance.jwtKey) + ":" + token, user, AuthorityUtils.instance.expire);
            AuthorityUtils.instance.redisDao.put(String.valueOf(AuthorityUtils.instance.usernameKey) + ":" + prefix + user.getUsername(), token, AuthorityUtils.instance.expire);
        } else {
            log.error("AuthorityUtils.redisTemplate is null");
        }
    }

    public static UserDetails getCurrentUser(String token) {
        Object user = AuthorityUtils.instance.redisDao.get(String.valueOf(AuthorityUtils.instance.jwtKey) + ":" + token);
        if (user == null) {
            throw new BaseBusinessException(ReturnEnum.ERROR_TOKEN_EXPIRED);
        }
        if (user instanceof JSONObject) {
            return (UserDetails)((JSONObject)user).toJavaObject(User.class);
        }
        if (user instanceof Map) {
            String json = JSON.toJSONString((Object)((Map)user));
            return (UserDetails)JSON.parseObject((String)json, User.class);
        }
        return (UserDetails)AuthorityUtils.instance.redisDao.getBean(String.valueOf(AuthorityUtils.instance.jwtKey) + ":" + token, User.class);
    }

    public static UserDetails getCurrentUser() {
        UserDetails user = null;
        if (RequestContextHolder.getRequestAttributes() != null) {
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            if (request != null && request.getAttribute("portalUser") != null) {
                user = (UserDetails)request.getAttribute("portalUser");
            } else if (SecurityContextHolder.getContext().getAuthentication() != null) {
                Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
                if (principal instanceof UserDetails) {
                    user = (UserDetails)principal;
                } else {
                    User dummy = new User();
                    dummy.setUsername(String.valueOf(principal));
                    user = dummy;
                }
            }
        }
        return user;
    }

    public static User getLoginUser() {
        UserDetails user = null;
        if (RequestContextHolder.getRequestAttributes() != null) {
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            if (request != null && request.getAttribute("portalUser") != null) {
                user = (UserDetails)request.getAttribute("portalUser");
            } else if (SecurityContextHolder.getContext().getAuthentication() != null) {
                Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
                if (principal instanceof UserDetails) {
                    user = (UserDetails)principal;
                } else {
                    User dummy = new User();
                    dummy.setUsername(String.valueOf(principal));
                    user = dummy;
                }
            }
        }
        return (User)user;
    }

    public static boolean needResume() {
        return AuthorityUtils.instance.resume;
    }

    public static void resetExpire(String token, UserDetails user) {
        AuthorityUtils.instance.redisDao.expire(String.valueOf(AuthorityUtils.instance.jwtKey) + ":" + token, AuthorityUtils.instance.expire);
        AuthorityUtils.instance.redisDao.expire(String.valueOf(AuthorityUtils.instance.usernameKey) + ":" + user.getUsername(), AuthorityUtils.instance.expire);
    }
}

