/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.common.sdk.filter;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.cicv.foton.common.sdk.utils.AuthorityUtils;
import com.cicv.foton.common.sdk.utils.JwtTokenUtils;
import com.cicv.foton.common.sdk.utils.RedisDao;
import com.inzyme.spatiotemporal.web.core.config.security.SecurityProperties;
import com.inzyme.spatiotemporal.web.core.constants.enums.ReturnEnum;
import com.inzyme.spatiotemporal.web.core.domain.vo.ReturnVO;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.stereotype.Component;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
@Order(value=1)
public class JwtAuthenticationTokenFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(JwtAuthenticationTokenFilter.class);
    @Autowired
    SecurityProperties securityProperties;
    @Autowired
    RedisDao redisDao;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if ("disable".equals(this.securityProperties.getMode())) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String token = request.getHeader("X-Token");
        if (token == null) {
            if (this.permitAccess(request.getServletPath())) {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            this.sendError(request, response, ReturnEnum.ERROR_NO_AUTHORITY);
            return;
        }
        String username = JwtTokenUtils.parseToken(token);
        this.logger.info((Object)("checking authentication " + username));
        String userToken = AuthorityUtils.checkToken(username);
        if (StringUtils.isEmpty((CharSequence)userToken)) {
            this.sendError(request, response, ReturnEnum.ERROR_TOKEN_EXPIRED);
            return;
        }
        if (!token.equals(userToken)) {
            this.sendError(request, response, ReturnEnum.ERROR_OTHER_DEVICE);
            return;
        }
        if (username != null) {
            UserDetails userDetails = AuthorityUtils.getCurrentUser(token);
            if (userDetails != null) {
                UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)userDetails, null, userDetails.getAuthorities());
                authentication.setDetails((Object)new WebAuthenticationDetailsSource().buildDetails(request));
                this.logger.info((Object)("authenticated user " + username + ", setting security context"));
                SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
                if (AuthorityUtils.needResume()) {
                    AuthorityUtils.resetExpire(token, userDetails);
                }
            }
        } else {
            this.sendError(request, response, ReturnEnum.ERROR_NO_AUTHORITY);
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void sendError(HttpServletRequest request, HttpServletResponse response, ReturnEnum returnEnum) throws ServletException, IOException {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/html;charset=utf-8");
        String failed = new String(JSON.toJSONString((Object)new ReturnVO(returnEnum)).getBytes("utf-8"), "utf-8");
        log.error(failed);
        response.getWriter().write(failed);
    }

    private boolean permitAccess(String path) {
        String[] permitAccess = this.securityProperties.getPermitAccess();
        if (permitAccess == null) {
            return false;
        }
        AntPathMatcher matcher = new AntPathMatcher();
        String[] stringArray = permitAccess;
        int n = permitAccess.length;
        int n2 = 0;
        while (n2 < n) {
            String pattern = stringArray[n2];
            if (matcher.match(pattern, path)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

