/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.common.sdk.intercept;

import com.cicv.foton.common.sdk.utils.ThreadLocalUtil;
import com.inzyme.spatiotemporal.web.core.constants.enums.ReturnEnum;
import com.inzyme.spatiotemporal.web.core.domain.vo.ReturnVO;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
public class ResponseBodyInterceptor
implements ResponseBodyAdvice<Object> {
    private static final Logger log = LoggerFactory.getLogger(ResponseBodyInterceptor.class);

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return true;
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        try {
            ReturnVO result;
            if (body instanceof ReturnVO && (result = (ReturnVO)body).getCode().equals(ReturnEnum.SUCCESS.getCode())) {
                log.info("===== process table:{}", (Object)ThreadLocalUtil.getTblName());
                if (result.getData() instanceof Collection) {
                    Collection objList = (Collection)result.getData();
                    ArrayList<Object> resultList = new ArrayList<Object>();
                    for (Object obj : objList) {
                        resultList.add(this.desensitize(obj));
                    }
                    result.setData(resultList);
                } else {
                    this.desensitize(result.getData());
                }
            }
        }
        catch (Exception e) {
            log.error("ResponseBody\u5904\u7406\u53d1\u751f\u5f02\u5e38\u3002", (Throwable)e);
        }
        return body;
    }

    private Object desensitize(Object object) throws InvocationTargetException, IllegalAccessException {
        Field[] fields;
        for (Field field : fields = object.getClass().getDeclaredFields()) {
            PropertyDescriptor ps = BeanUtils.getPropertyDescriptor(object.getClass(), (String)field.getName());
            if (null == ps || ps.getReadMethod() == null || ps.getWriteMethod() == null) continue;
            Object object2 = ps.getReadMethod().invoke(object, new Object[0]);
        }
        return object;
    }
}

