/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.common.sdk.aspect;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.cicv.foton.common.sdk.utils.AuthorityUtils;
import com.inzyme.spatiotemporal.web.core.annotation.DisableSysLog;
import com.inzyme.spatiotemporal.web.core.annotation.UserLog;
import com.inzyme.spatiotemporal.web.core.domain.entity.admin.OperationLog;
import com.inzyme.spatiotemporal.web.core.domain.entity.admin.User;
import com.inzyme.spatiotemporal.web.core.service.IOperationLogService;
import com.inzyme.spatiotemporal.web.core.utils.IPAddressUtils;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
@ConditionalOnMissingBean(annotation={DisableSysLog.class})
public class UserLogAspect {
    @Autowired
    private IOperationLogService logService;

    @Pointcut(value="@annotation(com.inzyme.spatiotemporal.web.core.annotation.UserLog)")
    public void logPointCut() {
    }

    @Around(value="logPointCut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        long beginTime = System.currentTimeMillis();
        Object result = null;
        Exception ex = null;
        try {
            result = point.proceed();
        }
        catch (Exception e) {
            ex = e;
            throw e;
        }
        finally {
            long time = System.currentTimeMillis() - beginTime;
            StringBuffer sb = new StringBuffer();
            if (ex != null) {
                sb.append(ex.toString()).append(" \n");
            }
            this.saveOperationLog(point, result, time, sb.toString());
        }
        return result;
    }

    private void saveOperationLog(ProceedingJoinPoint joinPoint, Object result, long time, String errorMsg) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        OperationLog log = new OperationLog();
        UserLog userLog = method.getAnnotation(UserLog.class);
        if (log != null) {
            log.setOperation(userLog.value());
        }
        String className = joinPoint.getTarget().getClass().getName();
        String methodName = signature.getName();
        log.setMethod(className + "." + methodName + "()");
        Object[] args = joinPoint.getArgs();
        try {
            String params = JSON.toJSONString((Object)args[0]);
            params = this.chgPwd(params);
            log.setParams(params);
            if (methodName.equals("login")) {
                JSONObject jsonObj = (JSONObject)JSONObject.parse((String)JSON.toJSONString((Object)result));
                JSONObject jsonData = (JSONObject)jsonObj.get((Object)"data");
                JSONObject jsonUser = (JSONObject)jsonData.get((Object)"user");
                String userId = jsonUser.getString("userId");
                String userName = jsonUser.getString("username");
                if (StringUtils.isBlank((String)userId)) {
                    log.setOperatorId("-1");
                    log.setOperatorName("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
                } else {
                    log.setOperatorId(userId);
                    log.setOperatorName(userName);
                }
            } else {
                User currUser = (User)AuthorityUtils.getCurrentUser();
                if (null == currUser) {
                    log.setOperatorId("-1");
                    log.setOperatorName("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
                } else {
                    log.setOperatorId(currUser.getId().toString());
                    log.setOperatorName(currUser.getUsername());
                }
            }
        }
        catch (Exception params) {
        }
        catch (Throwable params) {
            // empty catch block
        }
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        log.setLogIp(IPAddressUtils.getClientIP((HttpServletRequest)request));
        log.setResponseTime(Integer.valueOf(Integer.parseInt(Long.toString(time))));
        log.setStatus("Success");
        if (StringUtils.isNotEmpty((String)errorMsg)) {
            log.setErrorMsg(errorMsg);
            log.setStatus("Fail");
        }
        this.logService.save(log);
    }

    private String chgPwd(String param) {
        int index;
        String data = param;
        if (null != param && (index = data.indexOf("\"password\":\"")) >= 0) {
            int endIndex = param.indexOf(",", index);
            String pwd = param.substring(index, endIndex);
            data = param.replace(pwd, "\"password\":\"******");
        }
        return data;
    }
}

