/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.common.sdk.aspect;

import com.inzyme.spatiotemporal.web.core.annotation.DisableSysLog;
import com.inzyme.spatiotemporal.web.core.annotation.SysLog;
import com.inzyme.spatiotemporal.web.core.domain.entity.admin.ServiceLog;
import com.inzyme.spatiotemporal.web.core.service.IServiceLogService;
import com.inzyme.spatiotemporal.web.core.utils.IPAddressUtils;
import java.lang.reflect.Method;
import org.apache.commons.lang.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Component;

@Aspect
@Component
@ConditionalOnMissingBean(annotation={DisableSysLog.class})
public class SysLogAspect {
    private String compId;
    @Autowired
    private IServiceLogService service;

    @Pointcut(value="@annotation(com.inzyme.spatiotemporal.web.core.annotation.SysLog)")
    public void logPointCut() {
    }

    @Around(value="logPointCut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        long beginTime = System.currentTimeMillis();
        Object result = null;
        Exception ex = null;
        try {
            result = point.proceed();
        }
        catch (Exception e) {
            ex = e;
            throw e;
        }
        finally {
            long time = System.currentTimeMillis() - beginTime;
            StringBuffer sb = new StringBuffer();
            if (ex != null) {
                sb.append(ex.toString()).append(" \n");
            }
            this.saveSysLog(point, result, time, sb.toString());
        }
        return result;
    }

    private void saveSysLog(ProceedingJoinPoint joinPoint, Object result, long time, String errorMsg) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        ServiceLog log = new ServiceLog();
        SysLog syslog = method.getAnnotation(SysLog.class);
        if (syslog != null) {
            log.setService(syslog.value());
        }
        String className = joinPoint.getTarget().getClass().getName();
        String methodName = signature.getName();
        log.setModuleId(this.compId);
        log.setClassName(className);
        log.setMethod(className + "." + methodName + "()");
        log.setLogIp(IPAddressUtils.getServerIP());
        log.setResponseTime(Integer.valueOf(Integer.parseInt(Long.toString(time))));
        log.setStatus("Success");
        if (StringUtils.isNotEmpty((String)errorMsg)) {
            log.setErrorMsg(errorMsg);
            log.setStatus("Fail");
        }
        this.service.save(log);
    }
}

