/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.common.sdk.config.mybatis;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.handler.DataPermissionHandler;
import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.DataPermissionInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.OptimisticLockerInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.TenantLineInnerInterceptor;
import com.cicv.foton.common.sdk.intercept.MyDataPermissionHandler;
import com.cicv.foton.common.sdk.intercept.TenantLineHandlerInterceptor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MybatisPlusConfig {
    @Value(value="${mybatis-plus.pagination.db-type:postgresql}")
    private String dbType;

    @Bean
    public MybatisPlusInterceptor mybatisPlusInterceptor() {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        interceptor.addInnerInterceptor((InnerInterceptor)new TenantLineInnerInterceptor((TenantLineHandler)new TenantLineHandlerInterceptor()));
        interceptor.addInnerInterceptor((InnerInterceptor)new DataPermissionInterceptor((DataPermissionHandler)new MyDataPermissionHandler()));
        interceptor.addInnerInterceptor((InnerInterceptor)new PaginationInnerInterceptor(DbType.getDbType((String)this.dbType)));
        interceptor.addInnerInterceptor((InnerInterceptor)new OptimisticLockerInnerInterceptor());
        return interceptor;
    }
}

