/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin;

import com.cicv.foton.admin.SwaggerProperties;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableConfigurationProperties(value={SwaggerProperties.class})
@EnableSwagger2
@ConditionalOnProperty(name={"futian.swagger.enabled"}, havingValue="true", matchIfMissing=true)
public class SwaggerAutoConfiguration
implements BeanFactoryAware {
    private BeanFactory beanFactory;
    @Autowired
    SwaggerProperties swaggerProperties;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    @Bean
    @ConditionalOnMissingBean
    public List<Docket> createRestApi() {
        ConfigurableBeanFactory configurableBeanFactory = (ConfigurableBeanFactory)this.beanFactory;
        LinkedList<Docket> docketList = new LinkedList<Docket>();
        if (this.swaggerProperties.getDocket().isEmpty()) {
            Docket docket = this.createDocket(this.swaggerProperties);
            configurableBeanFactory.registerSingleton(this.swaggerProperties.getTitle(), (Object)docket);
            docketList.add(docket);
        } else {
            Set keySet = this.swaggerProperties.getDocket().keySet();
            for (String key : keySet) {
                Object path2;
                SwaggerProperties.DocketInfo docketInfo = (SwaggerProperties.DocketInfo)this.swaggerProperties.getDocket().get(key);
                ApiInfo apiInfo = new ApiInfoBuilder().title(docketInfo.getTitle()).contact(new Contact(docketInfo.getContact().getName(), docketInfo.getContact().getUrl(), docketInfo.getContact().getEmail())).version(docketInfo.getVersion()).description(docketInfo.getDescription()).build();
                if (docketInfo.getBasePath().isEmpty()) {
                    docketInfo.getBasePath().add("/**");
                }
                ArrayList<Predicate> basePath = new ArrayList<Predicate>();
                for (Object path2 : docketInfo.getBasePath()) {
                    basePath.add(PathSelectors.ant((String)path2));
                }
                ArrayList<Predicate> excludePath = new ArrayList<Predicate>();
                path2 = docketInfo.getExcludePath().iterator();
                while (path2.hasNext()) {
                    String path3 = (String)path2.next();
                    excludePath.add(PathSelectors.ant((String)path3));
                }
                Docket docket = new Docket(DocumentationType.SWAGGER_2).apiInfo(apiInfo).groupName(docketInfo.getGroup()).select().apis(RequestHandlerSelectors.basePackage((String)docketInfo.getBasePackage())).paths(Predicates.and((Predicate)Predicates.not((Predicate)Predicates.or(excludePath)), (Predicate)Predicates.or(basePath))).build();
                configurableBeanFactory.registerSingleton(key, (Object)docket);
                docketList.add(docket);
            }
        }
        return docketList;
    }

    private ApiInfo apiInfo(SwaggerProperties swaggerProperties) {
        return new ApiInfoBuilder().title(swaggerProperties.getTitle()).contact(new Contact(swaggerProperties.getContact().getName(), swaggerProperties.getContact().getUrl(), swaggerProperties.getContact().getEmail())).version(swaggerProperties.getVersion()).description(swaggerProperties.getDescription()).build();
    }

    private Docket createDocket(SwaggerProperties swaggerProperties) {
        ApiInfo apiInfo = this.apiInfo(swaggerProperties);
        if (swaggerProperties.getBasePath().isEmpty()) {
            swaggerProperties.getBasePath().add("/**");
        }
        ArrayList<Predicate> basePath = new ArrayList<Predicate>();
        for (String path : swaggerProperties.getBasePath()) {
            basePath.add(PathSelectors.ant((String)path));
        }
        ArrayList<Predicate> excludePath = new ArrayList<Predicate>();
        for (String path : swaggerProperties.getExcludePath()) {
            excludePath.add(PathSelectors.ant((String)path));
        }
        return new Docket(DocumentationType.SWAGGER_2).apiInfo(apiInfo).groupName(swaggerProperties.getGroup()).select().apis(RequestHandlerSelectors.basePackage((String)swaggerProperties.getBasePackage())).paths(Predicates.and((Predicate)Predicates.not((Predicate)Predicates.or(excludePath)), (Predicate)Predicates.or(basePath))).build();
    }
}

