/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.gatewayimpl;

import com.cicv.foton.admin.domain.gateway.RedisGateway;
import com.cicv.foton.common.sdk.utils.RedisDao;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class RedisGatewayImpl
implements RedisGateway {
    private static final Logger log = LoggerFactory.getLogger(RedisGatewayImpl.class);
    @Autowired
    private RedisDao redisDao;
    @Autowired
    private RedisTemplate redisTemplate;

    public Map<String, String> getHashValue(String key, String code) {
        return (Map)this.redisDao.getHashValue(key, code);
    }

    public void delHashItem(String dictKey, String dictType) {
        this.redisDao.delHashItem(dictKey, new Object[]{dictType});
    }

    public void putHashValue(String dictKey, String dictType, Map<String, String> subDict) {
        this.redisDao.putHashValue(dictKey, dictType, subDict);
    }

    public void saveVerificationCode(String redisKey, String code) {
        this.redisTemplate.expire((Object)redisKey, 1L, TimeUnit.MINUTES);
        this.redisTemplate.opsForList().leftPush((Object)redisKey, (Object)code);
    }

    public String getVerificationCode(String redisKey) {
        Object o1 = this.redisTemplate.opsForList().rightPop((Object)redisKey);
        return String.valueOf(o1);
    }

    public void saveUserUpdateById(String redisKey, Long userId) {
        this.redisTemplate.expire((Object)redisKey, 30L, TimeUnit.DAYS);
        this.redisTemplate.opsForList().leftPush((Object)redisKey, (Object)userId);
    }

    public void redisPullObject(String redisKey, Map<String, Object> map) {
        this.redisDao.putHashMap(redisKey, map);
    }
}

