/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.gatewayimpl;

import cn.spatiotemporal.web.core.exception.BaseBusinessException;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.cicv.foton.admin.domain.gateway.DictGateway;
import com.cicv.foton.admin.domain.system.Dict;
import com.cicv.foton.admin.gatewayimpl.rmdb.DictDao;
import com.cicv.foton.common.sdk.utils.RedisDao;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DictGatewayImpl
implements DictGateway {
    @Value(value="${spatiotemporal.cache.dictKey:spatiotemporal\\:dict\\:list}")
    private String dictKey;
    @Autowired
    private RedisDao redisDao;
    @Resource
    private DictDao dictDao;

    public Map<String, String> getDictItemsByDictType(String code) {
        Map map = (Map)this.redisDao.getHashValue(this.dictKey, code);
        return map;
    }

    public void removeById(Serializable id) {
        if (this.dictDao.deleteById(id) < 1) {
            throw new BaseBusinessException("602", "\u65e0\u6cd5\u5199\u5165\u6570\u636e\u5e93\uff0c\u5220\u9664\u6570\u636e\u5b57\u5178\u5931\u8d25\u3002");
        }
        this.deleteByIdRecursion((long)((Long)id));
    }

    public List<Dict> selectDictList(QueryWrapper<Dict> wrapper) {
        return this.dictDao.selectList((Wrapper)wrapper);
    }

    public Dict selectDictById(Long id) {
        return (Dict)this.dictDao.selectById(id);
    }

    public int deleteById(Long id) {
        return this.dictDao.deleteById(id);
    }

    public int updateById(Dict dict) {
        return this.dictDao.updateById(dict);
    }

    public int updateDictChildType(Dict dict) {
        return this.dictDao.updateDictChildType(dict);
    }

    public int insert(Dict dict) {
        return this.dictDao.insert(dict);
    }

    public Dict queryDictByName(QueryWrapper<Dict> qw) {
        return (Dict)this.dictDao.selectOne((Wrapper)qw);
    }

    private void deleteByIdRecursion(Long id) {
        int deleteById = this.dictDao.deleteById(id);
        List selectList = this.dictDao.selectList((Wrapper)new QueryWrapper().eq((Object)"parent_id", (Object)id));
        for (Dict dict : selectList) {
            this.deleteByIdRecursion(dict.getId());
        }
    }
}

