/*
 * Decompiled with CFR 0.152.
 */
package com.cicv.foton.admin.gatewayimpl;

import cn.spatiotemporal.web.core.exception.BaseBusinessException;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.cicv.foton.admin.domain.enums.CommonEnum;
import com.cicv.foton.admin.domain.gateway.AdminOrgGateway;
import com.cicv.foton.admin.domain.system.AdminOrg;
import com.cicv.foton.admin.gatewayimpl.rmdb.AdminOrgDao;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class AdminOrgGatewayImpl
implements AdminOrgGateway {
    @Resource
    private AdminOrgDao adminOrgDao;

    public List<AdminOrg> selectAdminOrgList(LambdaQueryWrapper<AdminOrg> wrapper) {
        return this.adminOrgDao.selectList((Wrapper)wrapper);
    }

    public List<AdminOrg> queryAllOrg(LambdaQueryWrapper<AdminOrg> wrapper) {
        return this.adminOrgDao.selectList((Wrapper)wrapper);
    }

    public AdminOrg selectById(Long parentId) {
        AdminOrg adminOrg = (AdminOrg)this.adminOrgDao.selectById(parentId);
        if (null == adminOrg) {
            throw new BaseBusinessException(CommonEnum.PERMSSION_APPOINT_ORG_THE_SAME.getCode(), CommonEnum.PERMSSION_APPOINT_ORG_THE_SAME.getMessage());
        }
        return adminOrg;
    }

    public void selectByName(String name, Long tenantId) {
        QueryWrapper qw = new QueryWrapper();
        qw.eq((Object)"name", (Object)name);
        qw.eq((Object)"tenant_id", (Object)tenantId);
        Long count = this.adminOrgDao.selectCount((Wrapper)qw);
        if (count > 0L) {
            throw new BaseBusinessException(CommonEnum.PERMSSION_ORG_THE_SAME.getCode(), CommonEnum.PERMSSION_ORG_THE_SAME.getMessage());
        }
    }

    public Boolean saveOrg(AdminOrg adminOrg) {
        int insert = this.adminOrgDao.insert(adminOrg);
        return insert > 0;
    }

    public Boolean updateOrg(AdminOrg adminOrg) {
        int update = this.adminOrgDao.update(adminOrg, (Wrapper)Wrappers.lambdaUpdate().eq(AdminOrg::getId, (Object)adminOrg.getId()));
        return update > 0;
    }

    public Boolean selectByParentId(Long id) {
        Long count = this.adminOrgDao.selectCount((Wrapper)Wrappers.lambdaQuery().eq(AdminOrg::getParentId, (Object)id));
        return count > 0L;
    }

    public Boolean deleteOrg(Long id) {
        int flag = this.adminOrgDao.deleteById(id);
        return flag > 0;
    }

    public List<AdminOrg> selectList() {
        return this.adminOrgDao.selectList((Wrapper)Wrappers.lambdaQuery().orderByAsc(AdminOrg::getId));
    }

    public void deleteBatchById(List<Long> subsetData) {
        this.adminOrgDao.deleteBatchIds(subsetData);
    }

    public List<AdminOrg> selectChildOrg() {
        return this.adminOrgDao.selectList((Wrapper)Wrappers.lambdaQuery().eq(AdminOrg::getParentId, (Object)0L));
    }

    public List<AdminOrg> selectChildOrg(Long id) {
        return this.adminOrgDao.selectList((Wrapper)Wrappers.lambdaQuery().eq(AdminOrg::getParentId, (Object)id));
    }

    public Set<Integer> selectAllLevel() {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.select(new String[]{"DISTINCT level"});
        List adminOrgList = this.adminOrgDao.selectList((Wrapper)wrapper);
        return adminOrgList.stream().map(AdminOrg::getLevel).collect(Collectors.toSet());
    }

    public void selectByNameUpdate(String name, Long id, Long tenantId) {
        Long count = this.adminOrgDao.selectCount((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AdminOrg::getName, (Object)name)).eq(AdminOrg::getTenantId, (Object)tenantId)).ne(AdminOrg::getId, (Object)id));
        if (count > 0L) {
            throw new BaseBusinessException(CommonEnum.PERMSSION_ORG_THE_SAME.getCode(), CommonEnum.PERMSSION_ORG_THE_SAME.getMessage());
        }
    }

    public List<AdminOrg> selectListByTenantId(LambdaQueryWrapper<AdminOrg> wrapper) {
        wrapper.orderByAsc(AdminOrg::getId);
        return this.adminOrgDao.selectList((Wrapper)wrapper);
    }

    public String selectNameById(Long orgId) {
        AdminOrg adminOrg = (AdminOrg)this.adminOrgDao.selectById(orgId);
        return null == adminOrg ? "" : adminOrg.getName();
    }
}

